# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 license_model: pulumi.Input[builtins.str],
                 recipe_type: pulumi.Input[builtins.str],
                 source_connection_details: pulumi.Input['PipelineSourceConnectionDetailsArgs'],
                 target_connection_details: pulumi.Input['PipelineTargetConnectionDetailsArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]] = None,
                 process_options: Optional[pulumi.Input['PipelineProcessOptionsArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[builtins.str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[builtins.str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[builtins.str] recipe_type: (Updatable) The type of the recipe
        :param pulumi.Input['PipelineSourceConnectionDetailsArgs'] source_connection_details: The source connection details for creating a pipeline.
        :param pulumi.Input['PipelineTargetConnectionDetailsArgs'] target_connection_details: The target connection details for creating a pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input['PipelineProcessOptionsArgs'] process_options: (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "license_model", license_model)
        pulumi.set(__self__, "recipe_type", recipe_type)
        pulumi.set(__self__, "source_connection_details", source_connection_details)
        pulumi.set(__self__, "target_connection_details", target_connection_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if process_options is not None:
            pulumi.set(__self__, "process_options", process_options)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="recipeType")
    def recipe_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of the recipe
        """
        return pulumi.get(self, "recipe_type")

    @recipe_type.setter
    def recipe_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recipe_type", value)

    @property
    @pulumi.getter(name="sourceConnectionDetails")
    def source_connection_details(self) -> pulumi.Input['PipelineSourceConnectionDetailsArgs']:
        """
        The source connection details for creating a pipeline.
        """
        return pulumi.get(self, "source_connection_details")

    @source_connection_details.setter
    def source_connection_details(self, value: pulumi.Input['PipelineSourceConnectionDetailsArgs']):
        pulumi.set(self, "source_connection_details", value)

    @property
    @pulumi.getter(name="targetConnectionDetails")
    def target_connection_details(self) -> pulumi.Input['PipelineTargetConnectionDetailsArgs']:
        """
        The target connection details for creating a pipeline.
        """
        return pulumi.get(self, "target_connection_details")

    @target_connection_details.setter
    def target_connection_details(self, value: pulumi.Input['PipelineTargetConnectionDetailsArgs']):
        pulumi.set(self, "target_connection_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="processOptions")
    def process_options(self) -> Optional[pulumi.Input['PipelineProcessOptionsArgs']]:
        """
        (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        """
        return pulumi.get(self, "process_options")

    @process_options.setter
    def process_options(self, value: Optional[pulumi.Input['PipelineProcessOptionsArgs']]):
        pulumi.set(self, "process_options", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_sub_state: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]] = None,
                 mapping_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMappingRuleArgs']]]] = None,
                 pipeline_diagnostic_datas: Optional[pulumi.Input[Sequence[pulumi.Input['PipelinePipelineDiagnosticDataArgs']]]] = None,
                 process_options: Optional[pulumi.Input['PipelineProcessOptionsArgs']] = None,
                 recipe_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_connection_details: Optional[pulumi.Input['PipelineSourceConnectionDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_connection_details: Optional[pulumi.Input['PipelineTargetConnectionDetailsArgs']] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_recorded: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[builtins.int] cpu_core_count: The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[builtins.str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[builtins.str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[builtins.str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[builtins.str] lifecycle_sub_state: Possible lifecycle substates when retrieving a pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineMappingRuleArgs']]] mapping_rules: Mapping for source/target schema/tables for the pipeline data replication.
        :param pulumi.Input[Sequence[pulumi.Input['PipelinePipelineDiagnosticDataArgs']]] pipeline_diagnostic_datas: Information regarding the pipeline diagnostic collection
        :param pulumi.Input['PipelineProcessOptionsArgs'] process_options: (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        :param pulumi.Input[builtins.str] recipe_type: (Updatable) The type of the recipe
        :param pulumi.Input['PipelineSourceConnectionDetailsArgs'] source_connection_details: The source connection details for creating a pipeline.
        :param pulumi.Input[builtins.str] state: Lifecycle state of the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input['PipelineTargetConnectionDetailsArgs'] target_connection_details: The target connection details for creating a pipeline.
        :param pulumi.Input[builtins.str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_last_recorded: When the resource was last updated. This option applies when retrieving a pipeline. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2024-07-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_scaling_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_sub_state is not None:
            pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if mapping_rules is not None:
            pulumi.set(__self__, "mapping_rules", mapping_rules)
        if pipeline_diagnostic_datas is not None:
            pulumi.set(__self__, "pipeline_diagnostic_datas", pipeline_diagnostic_datas)
        if process_options is not None:
            pulumi.set(__self__, "process_options", process_options)
        if recipe_type is not None:
            pulumi.set(__self__, "recipe_type", recipe_type)
        if source_connection_details is not None:
            pulumi.set(__self__, "source_connection_details", source_connection_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_connection_details is not None:
            pulumi.set(__self__, "target_connection_details", target_connection_details)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_recorded is not None:
            pulumi.set(__self__, "time_last_recorded", time_last_recorded)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible lifecycle substates when retrieving a pipeline.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @lifecycle_sub_state.setter
    def lifecycle_sub_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_sub_state", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMappingRuleArgs']]]]:
        """
        Mapping for source/target schema/tables for the pipeline data replication.
        """
        return pulumi.get(self, "mapping_rules")

    @mapping_rules.setter
    def mapping_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMappingRuleArgs']]]]):
        pulumi.set(self, "mapping_rules", value)

    @property
    @pulumi.getter(name="pipelineDiagnosticDatas")
    def pipeline_diagnostic_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelinePipelineDiagnosticDataArgs']]]]:
        """
        Information regarding the pipeline diagnostic collection
        """
        return pulumi.get(self, "pipeline_diagnostic_datas")

    @pipeline_diagnostic_datas.setter
    def pipeline_diagnostic_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelinePipelineDiagnosticDataArgs']]]]):
        pulumi.set(self, "pipeline_diagnostic_datas", value)

    @property
    @pulumi.getter(name="processOptions")
    def process_options(self) -> Optional[pulumi.Input['PipelineProcessOptionsArgs']]:
        """
        (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        """
        return pulumi.get(self, "process_options")

    @process_options.setter
    def process_options(self, value: Optional[pulumi.Input['PipelineProcessOptionsArgs']]):
        pulumi.set(self, "process_options", value)

    @property
    @pulumi.getter(name="recipeType")
    def recipe_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of the recipe
        """
        return pulumi.get(self, "recipe_type")

    @recipe_type.setter
    def recipe_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recipe_type", value)

    @property
    @pulumi.getter(name="sourceConnectionDetails")
    def source_connection_details(self) -> Optional[pulumi.Input['PipelineSourceConnectionDetailsArgs']]:
        """
        The source connection details for creating a pipeline.
        """
        return pulumi.get(self, "source_connection_details")

    @source_connection_details.setter
    def source_connection_details(self, value: Optional[pulumi.Input['PipelineSourceConnectionDetailsArgs']]):
        pulumi.set(self, "source_connection_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle state of the pipeline.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetConnectionDetails")
    def target_connection_details(self) -> Optional[pulumi.Input['PipelineTargetConnectionDetailsArgs']]:
        """
        The target connection details for creating a pipeline.
        """
        return pulumi.get(self, "target_connection_details")

    @target_connection_details.setter
    def target_connection_details(self, value: Optional[pulumi.Input['PipelineTargetConnectionDetailsArgs']]):
        pulumi.set(self, "target_connection_details", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastRecorded")
    def time_last_recorded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the resource was last updated. This option applies when retrieving a pipeline. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2024-07-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_recorded")

    @time_last_recorded.setter
    def time_last_recorded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_recorded", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:GoldenGate/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineLockArgs', 'PipelineLockArgsDict']]]]] = None,
                 process_options: Optional[pulumi.Input[Union['PipelineProcessOptionsArgs', 'PipelineProcessOptionsArgsDict']]] = None,
                 recipe_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_connection_details: Optional[pulumi.Input[Union['PipelineSourceConnectionDetailsArgs', 'PipelineSourceConnectionDetailsArgsDict']]] = None,
                 target_connection_details: Optional[pulumi.Input[Union['PipelineTargetConnectionDetailsArgs', 'PipelineTargetConnectionDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Pipeline resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Pipeline.

        ## Import

        Pipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/pipeline:Pipeline test_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[builtins.str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineLockArgs', 'PipelineLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Union['PipelineProcessOptionsArgs', 'PipelineProcessOptionsArgsDict']] process_options: (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        :param pulumi.Input[builtins.str] recipe_type: (Updatable) The type of the recipe
        :param pulumi.Input[Union['PipelineSourceConnectionDetailsArgs', 'PipelineSourceConnectionDetailsArgsDict']] source_connection_details: The source connection details for creating a pipeline.
        :param pulumi.Input[Union['PipelineTargetConnectionDetailsArgs', 'PipelineTargetConnectionDetailsArgsDict']] target_connection_details: The target connection details for creating a pipeline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Pipeline resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Pipeline.

        ## Import

        Pipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/pipeline:Pipeline test_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineLockArgs', 'PipelineLockArgsDict']]]]] = None,
                 process_options: Optional[pulumi.Input[Union['PipelineProcessOptionsArgs', 'PipelineProcessOptionsArgsDict']]] = None,
                 recipe_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_connection_details: Optional[pulumi.Input[Union['PipelineSourceConnectionDetailsArgs', 'PipelineSourceConnectionDetailsArgsDict']]] = None,
                 target_connection_details: Optional[pulumi.Input[Union['PipelineTargetConnectionDetailsArgs', 'PipelineTargetConnectionDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if license_model is None and not opts.urn:
                raise TypeError("Missing required property 'license_model'")
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["locks"] = locks
            __props__.__dict__["process_options"] = process_options
            if recipe_type is None and not opts.urn:
                raise TypeError("Missing required property 'recipe_type'")
            __props__.__dict__["recipe_type"] = recipe_type
            if source_connection_details is None and not opts.urn:
                raise TypeError("Missing required property 'source_connection_details'")
            __props__.__dict__["source_connection_details"] = source_connection_details
            if target_connection_details is None and not opts.urn:
                raise TypeError("Missing required property 'target_connection_details'")
            __props__.__dict__["target_connection_details"] = target_connection_details
            __props__.__dict__["cpu_core_count"] = None
            __props__.__dict__["is_auto_scaling_enabled"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_sub_state"] = None
            __props__.__dict__["mapping_rules"] = None
            __props__.__dict__["pipeline_diagnostic_datas"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_recorded"] = None
            __props__.__dict__["time_updated"] = None
        super(Pipeline, __self__).__init__(
            'oci:GoldenGate/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_auto_scaling_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            license_model: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_sub_state: Optional[pulumi.Input[builtins.str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineLockArgs', 'PipelineLockArgsDict']]]]] = None,
            mapping_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineMappingRuleArgs', 'PipelineMappingRuleArgsDict']]]]] = None,
            pipeline_diagnostic_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelinePipelineDiagnosticDataArgs', 'PipelinePipelineDiagnosticDataArgsDict']]]]] = None,
            process_options: Optional[pulumi.Input[Union['PipelineProcessOptionsArgs', 'PipelineProcessOptionsArgsDict']]] = None,
            recipe_type: Optional[pulumi.Input[builtins.str]] = None,
            source_connection_details: Optional[pulumi.Input[Union['PipelineSourceConnectionDetailsArgs', 'PipelineSourceConnectionDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_connection_details: Optional[pulumi.Input[Union['PipelineTargetConnectionDetailsArgs', 'PipelineTargetConnectionDetailsArgsDict']]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_recorded: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[builtins.int] cpu_core_count: The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[builtins.str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[builtins.str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[builtins.str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[builtins.str] lifecycle_sub_state: Possible lifecycle substates when retrieving a pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineLockArgs', 'PipelineLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineMappingRuleArgs', 'PipelineMappingRuleArgsDict']]]] mapping_rules: Mapping for source/target schema/tables for the pipeline data replication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelinePipelineDiagnosticDataArgs', 'PipelinePipelineDiagnosticDataArgsDict']]]] pipeline_diagnostic_datas: Information regarding the pipeline diagnostic collection
        :param pulumi.Input[Union['PipelineProcessOptionsArgs', 'PipelineProcessOptionsArgsDict']] process_options: (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        :param pulumi.Input[builtins.str] recipe_type: (Updatable) The type of the recipe
        :param pulumi.Input[Union['PipelineSourceConnectionDetailsArgs', 'PipelineSourceConnectionDetailsArgsDict']] source_connection_details: The source connection details for creating a pipeline.
        :param pulumi.Input[builtins.str] state: Lifecycle state of the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[Union['PipelineTargetConnectionDetailsArgs', 'PipelineTargetConnectionDetailsArgsDict']] target_connection_details: The target connection details for creating a pipeline.
        :param pulumi.Input[builtins.str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_last_recorded: When the resource was last updated. This option applies when retrieving a pipeline. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2024-07-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_scaling_enabled"] = is_auto_scaling_enabled
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_sub_state"] = lifecycle_sub_state
        __props__.__dict__["locks"] = locks
        __props__.__dict__["mapping_rules"] = mapping_rules
        __props__.__dict__["pipeline_diagnostic_datas"] = pipeline_diagnostic_datas
        __props__.__dict__["process_options"] = process_options
        __props__.__dict__["recipe_type"] = recipe_type
        __props__.__dict__["source_connection_details"] = source_connection_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_connection_details"] = target_connection_details
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_recorded"] = time_last_recorded
        __props__.__dict__["time_updated"] = time_updated
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[builtins.int]:
        """
        The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> pulumi.Output[builtins.str]:
        """
        Possible lifecycle substates when retrieving a pipeline.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.PipelineLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> pulumi.Output[Sequence['outputs.PipelineMappingRule']]:
        """
        Mapping for source/target schema/tables for the pipeline data replication.
        """
        return pulumi.get(self, "mapping_rules")

    @property
    @pulumi.getter(name="pipelineDiagnosticDatas")
    def pipeline_diagnostic_datas(self) -> pulumi.Output[Sequence['outputs.PipelinePipelineDiagnosticData']]:
        """
        Information regarding the pipeline diagnostic collection
        """
        return pulumi.get(self, "pipeline_diagnostic_datas")

    @property
    @pulumi.getter(name="processOptions")
    def process_options(self) -> pulumi.Output['outputs.PipelineProcessOptions']:
        """
        (Updatable) Required pipeline options to configure the replication process (Extract or Replicat).
        """
        return pulumi.get(self, "process_options")

    @property
    @pulumi.getter(name="recipeType")
    def recipe_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of the recipe
        """
        return pulumi.get(self, "recipe_type")

    @property
    @pulumi.getter(name="sourceConnectionDetails")
    def source_connection_details(self) -> pulumi.Output['outputs.PipelineSourceConnectionDetails']:
        """
        The source connection details for creating a pipeline.
        """
        return pulumi.get(self, "source_connection_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Lifecycle state of the pipeline.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetConnectionDetails")
    def target_connection_details(self) -> pulumi.Output['outputs.PipelineTargetConnectionDetails']:
        """
        The target connection details for creating a pipeline.
        """
        return pulumi.get(self, "target_connection_details")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastRecorded")
    def time_last_recorded(self) -> pulumi.Output[builtins.str]:
        """
        When the resource was last updated. This option applies when retrieving a pipeline. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2024-07-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_recorded")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

