# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIamWorkRequestErrorsResult',
    'AwaitableGetIamWorkRequestErrorsResult',
    'get_iam_work_request_errors',
    'get_iam_work_request_errors_output',
]

@pulumi.output_type
class GetIamWorkRequestErrorsResult:
    """
    A collection of values returned by getIamWorkRequestErrors.
    """
    def __init__(__self__, filters=None, iam_work_request_errors=None, iam_work_request_id=None, id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if iam_work_request_errors and not isinstance(iam_work_request_errors, list):
            raise TypeError("Expected argument 'iam_work_request_errors' to be a list")
        pulumi.set(__self__, "iam_work_request_errors", iam_work_request_errors)
        if iam_work_request_id and not isinstance(iam_work_request_id, str):
            raise TypeError("Expected argument 'iam_work_request_id' to be a str")
        pulumi.set(__self__, "iam_work_request_id", iam_work_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIamWorkRequestErrorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="iamWorkRequestErrors")
    def iam_work_request_errors(self) -> Sequence['outputs.GetIamWorkRequestErrorsIamWorkRequestErrorResult']:
        """
        The list of iam_work_request_errors.
        """
        return pulumi.get(self, "iam_work_request_errors")

    @property
    @pulumi.getter(name="iamWorkRequestId")
    def iam_work_request_id(self) -> builtins.str:
        return pulumi.get(self, "iam_work_request_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetIamWorkRequestErrorsResult(GetIamWorkRequestErrorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamWorkRequestErrorsResult(
            filters=self.filters,
            iam_work_request_errors=self.iam_work_request_errors,
            iam_work_request_id=self.iam_work_request_id,
            id=self.id)


def get_iam_work_request_errors(filters: Optional[Sequence[Union['GetIamWorkRequestErrorsFilterArgs', 'GetIamWorkRequestErrorsFilterArgsDict']]] = None,
                                iam_work_request_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamWorkRequestErrorsResult:
    """
    This data source provides the list of Iam Work Request Errors in Oracle Cloud Infrastructure Identity service.

    Gets error details for a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request_errors = oci.Identity.get_iam_work_request_errors(iam_work_request_id=test_iam_work_request["id"])
    ```


    :param builtins.str iam_work_request_id: The OCID of the IAM work request.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['iamWorkRequestId'] = iam_work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIamWorkRequestErrors:getIamWorkRequestErrors', __args__, opts=opts, typ=GetIamWorkRequestErrorsResult).value

    return AwaitableGetIamWorkRequestErrorsResult(
        filters=pulumi.get(__ret__, 'filters'),
        iam_work_request_errors=pulumi.get(__ret__, 'iam_work_request_errors'),
        iam_work_request_id=pulumi.get(__ret__, 'iam_work_request_id'),
        id=pulumi.get(__ret__, 'id'))
def get_iam_work_request_errors_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIamWorkRequestErrorsFilterArgs', 'GetIamWorkRequestErrorsFilterArgsDict']]]]] = None,
                                       iam_work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamWorkRequestErrorsResult]:
    """
    This data source provides the list of Iam Work Request Errors in Oracle Cloud Infrastructure Identity service.

    Gets error details for a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request_errors = oci.Identity.get_iam_work_request_errors(iam_work_request_id=test_iam_work_request["id"])
    ```


    :param builtins.str iam_work_request_id: The OCID of the IAM work request.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['iamWorkRequestId'] = iam_work_request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getIamWorkRequestErrors:getIamWorkRequestErrors', __args__, opts=opts, typ=GetIamWorkRequestErrorsResult)
    return __ret__.apply(lambda __response__: GetIamWorkRequestErrorsResult(
        filters=pulumi.get(__response__, 'filters'),
        iam_work_request_errors=pulumi.get(__response__, 'iam_work_request_errors'),
        iam_work_request_id=pulumi.get(__response__, 'iam_work_request_id'),
        id=pulumi.get(__response__, 'id')))
