# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetCryptoAnalysisResultsResult',
    'AwaitableGetFleetCryptoAnalysisResultsResult',
    'get_fleet_crypto_analysis_results',
    'get_fleet_crypto_analysis_results_output',
]

@pulumi.output_type
class GetFleetCryptoAnalysisResultsResult:
    """
    A collection of values returned by getFleetCryptoAnalysisResults.
    """
    def __init__(__self__, aggregation_mode=None, crypto_analysis_result_collections=None, filters=None, finding_count=None, finding_count_greater_than=None, fleet_id=None, host_name=None, id=None, managed_instance_id=None, non_compliant_finding_count=None, non_compliant_finding_count_greater_than=None, time_end=None, time_start=None):
        if aggregation_mode and not isinstance(aggregation_mode, str):
            raise TypeError("Expected argument 'aggregation_mode' to be a str")
        pulumi.set(__self__, "aggregation_mode", aggregation_mode)
        if crypto_analysis_result_collections and not isinstance(crypto_analysis_result_collections, list):
            raise TypeError("Expected argument 'crypto_analysis_result_collections' to be a list")
        pulumi.set(__self__, "crypto_analysis_result_collections", crypto_analysis_result_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if finding_count and not isinstance(finding_count, int):
            raise TypeError("Expected argument 'finding_count' to be a int")
        pulumi.set(__self__, "finding_count", finding_count)
        if finding_count_greater_than and not isinstance(finding_count_greater_than, int):
            raise TypeError("Expected argument 'finding_count_greater_than' to be a int")
        pulumi.set(__self__, "finding_count_greater_than", finding_count_greater_than)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if non_compliant_finding_count and not isinstance(non_compliant_finding_count, int):
            raise TypeError("Expected argument 'non_compliant_finding_count' to be a int")
        pulumi.set(__self__, "non_compliant_finding_count", non_compliant_finding_count)
        if non_compliant_finding_count_greater_than and not isinstance(non_compliant_finding_count_greater_than, int):
            raise TypeError("Expected argument 'non_compliant_finding_count_greater_than' to be a int")
        pulumi.set(__self__, "non_compliant_finding_count_greater_than", non_compliant_finding_count_greater_than)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="aggregationMode")
    def aggregation_mode(self) -> Optional[builtins.str]:
        """
        The result aggregation mode
        """
        return pulumi.get(self, "aggregation_mode")

    @property
    @pulumi.getter(name="cryptoAnalysisResultCollections")
    def crypto_analysis_result_collections(self) -> Sequence['outputs.GetFleetCryptoAnalysisResultsCryptoAnalysisResultCollectionResult']:
        """
        The list of crypto_analysis_result_collection.
        """
        return pulumi.get(self, "crypto_analysis_result_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetCryptoAnalysisResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="findingCount")
    def finding_count(self) -> Optional[builtins.int]:
        """
        Total number of findings with the analysis.
        """
        return pulumi.get(self, "finding_count")

    @property
    @pulumi.getter(name="findingCountGreaterThan")
    def finding_count_greater_than(self) -> Optional[builtins.int]:
        return pulumi.get(self, "finding_count_greater_than")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[builtins.str]:
        """
        The hostname of the managed instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[builtins.str]:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="nonCompliantFindingCount")
    def non_compliant_finding_count(self) -> Optional[builtins.int]:
        """
        Total number of non-compliant findings with the analysis. A non-compliant finding means the application won't work properly with the changes introduced by the Crypto Roadmap version used by the analysis.
        """
        return pulumi.get(self, "non_compliant_finding_count")

    @property
    @pulumi.getter(name="nonCompliantFindingCountGreaterThan")
    def non_compliant_finding_count_greater_than(self) -> Optional[builtins.int]:
        return pulumi.get(self, "non_compliant_finding_count_greater_than")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetCryptoAnalysisResultsResult(GetFleetCryptoAnalysisResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetCryptoAnalysisResultsResult(
            aggregation_mode=self.aggregation_mode,
            crypto_analysis_result_collections=self.crypto_analysis_result_collections,
            filters=self.filters,
            finding_count=self.finding_count,
            finding_count_greater_than=self.finding_count_greater_than,
            fleet_id=self.fleet_id,
            host_name=self.host_name,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            non_compliant_finding_count=self.non_compliant_finding_count,
            non_compliant_finding_count_greater_than=self.non_compliant_finding_count_greater_than,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_crypto_analysis_results(aggregation_mode: Optional[builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetFleetCryptoAnalysisResultsFilterArgs', 'GetFleetCryptoAnalysisResultsFilterArgsDict']]] = None,
                                      finding_count: Optional[builtins.int] = None,
                                      finding_count_greater_than: Optional[builtins.int] = None,
                                      fleet_id: Optional[builtins.str] = None,
                                      host_name: Optional[builtins.str] = None,
                                      managed_instance_id: Optional[builtins.str] = None,
                                      non_compliant_finding_count: Optional[builtins.int] = None,
                                      non_compliant_finding_count_greater_than: Optional[builtins.int] = None,
                                      time_end: Optional[builtins.str] = None,
                                      time_start: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetCryptoAnalysisResultsResult:
    """
    This data source provides the list of Fleet Crypto Analysis Results in Oracle Cloud Infrastructure Jms service.

    Lists the results of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_results = oci.Jms.get_fleet_crypto_analysis_results(fleet_id=test_fleet["id"],
        aggregation_mode=fleet_crypto_analysis_result_aggregation_mode,
        finding_count=fleet_crypto_analysis_result_finding_count,
        finding_count_greater_than=fleet_crypto_analysis_result_finding_count_greater_than,
        host_name=fleet_crypto_analysis_result_host_name,
        managed_instance_id=fleet_crypto_analysis_result_managed_instance_ocid,
        non_compliant_finding_count=fleet_crypto_analysis_result_non_compliant_finding_count,
        non_compliant_finding_count_greater_than=fleet_crypto_analysis_result_non_compliant_finding_count_greater_than,
        time_end=fleet_crypto_analysis_result_time_end,
        time_start=fleet_crypto_analysis_result_time_start)
    ```


    :param builtins.str aggregation_mode: The aggregation mode of the crypto event analysis result.
    :param builtins.int finding_count: FindingCount of CryptoAnalysis Report.
    :param builtins.int finding_count_greater_than: FindingCount of CryptoAnalysis Report.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param builtins.int non_compliant_finding_count: Non Compliant Finding Count of CryptoAnalysis Report.
    :param builtins.int non_compliant_finding_count_greater_than: Non Compliant Finding Count of CryptoAnalysis Report.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['aggregationMode'] = aggregation_mode
    __args__['filters'] = filters
    __args__['findingCount'] = finding_count
    __args__['findingCountGreaterThan'] = finding_count_greater_than
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['managedInstanceId'] = managed_instance_id
    __args__['nonCompliantFindingCount'] = non_compliant_finding_count
    __args__['nonCompliantFindingCountGreaterThan'] = non_compliant_finding_count_greater_than
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetCryptoAnalysisResults:getFleetCryptoAnalysisResults', __args__, opts=opts, typ=GetFleetCryptoAnalysisResultsResult).value

    return AwaitableGetFleetCryptoAnalysisResultsResult(
        aggregation_mode=pulumi.get(__ret__, 'aggregation_mode'),
        crypto_analysis_result_collections=pulumi.get(__ret__, 'crypto_analysis_result_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        finding_count=pulumi.get(__ret__, 'finding_count'),
        finding_count_greater_than=pulumi.get(__ret__, 'finding_count_greater_than'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        non_compliant_finding_count=pulumi.get(__ret__, 'non_compliant_finding_count'),
        non_compliant_finding_count_greater_than=pulumi.get(__ret__, 'non_compliant_finding_count_greater_than'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_fleet_crypto_analysis_results_output(aggregation_mode: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetCryptoAnalysisResultsFilterArgs', 'GetFleetCryptoAnalysisResultsFilterArgsDict']]]]] = None,
                                             finding_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                             finding_count_greater_than: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                             fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                             host_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             managed_instance_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             non_compliant_finding_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                             non_compliant_finding_count_greater_than: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                             time_end: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             time_start: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetCryptoAnalysisResultsResult]:
    """
    This data source provides the list of Fleet Crypto Analysis Results in Oracle Cloud Infrastructure Jms service.

    Lists the results of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_results = oci.Jms.get_fleet_crypto_analysis_results(fleet_id=test_fleet["id"],
        aggregation_mode=fleet_crypto_analysis_result_aggregation_mode,
        finding_count=fleet_crypto_analysis_result_finding_count,
        finding_count_greater_than=fleet_crypto_analysis_result_finding_count_greater_than,
        host_name=fleet_crypto_analysis_result_host_name,
        managed_instance_id=fleet_crypto_analysis_result_managed_instance_ocid,
        non_compliant_finding_count=fleet_crypto_analysis_result_non_compliant_finding_count,
        non_compliant_finding_count_greater_than=fleet_crypto_analysis_result_non_compliant_finding_count_greater_than,
        time_end=fleet_crypto_analysis_result_time_end,
        time_start=fleet_crypto_analysis_result_time_start)
    ```


    :param builtins.str aggregation_mode: The aggregation mode of the crypto event analysis result.
    :param builtins.int finding_count: FindingCount of CryptoAnalysis Report.
    :param builtins.int finding_count_greater_than: FindingCount of CryptoAnalysis Report.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param builtins.int non_compliant_finding_count: Non Compliant Finding Count of CryptoAnalysis Report.
    :param builtins.int non_compliant_finding_count_greater_than: Non Compliant Finding Count of CryptoAnalysis Report.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['aggregationMode'] = aggregation_mode
    __args__['filters'] = filters
    __args__['findingCount'] = finding_count
    __args__['findingCountGreaterThan'] = finding_count_greater_than
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['managedInstanceId'] = managed_instance_id
    __args__['nonCompliantFindingCount'] = non_compliant_finding_count
    __args__['nonCompliantFindingCountGreaterThan'] = non_compliant_finding_count_greater_than
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetCryptoAnalysisResults:getFleetCryptoAnalysisResults', __args__, opts=opts, typ=GetFleetCryptoAnalysisResultsResult)
    return __ret__.apply(lambda __response__: GetFleetCryptoAnalysisResultsResult(
        aggregation_mode=pulumi.get(__response__, 'aggregation_mode'),
        crypto_analysis_result_collections=pulumi.get(__response__, 'crypto_analysis_result_collections'),
        filters=pulumi.get(__response__, 'filters'),
        finding_count=pulumi.get(__response__, 'finding_count'),
        finding_count_greater_than=pulumi.get(__response__, 'finding_count_greater_than'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        non_compliant_finding_count=pulumi.get(__response__, 'non_compliant_finding_count'),
        non_compliant_finding_count_greater_than=pulumi.get(__response__, 'non_compliant_finding_count_greater_than'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
