# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetErrorAnalyticsResult',
    'AwaitableGetFleetErrorAnalyticsResult',
    'get_fleet_error_analytics',
    'get_fleet_error_analytics_output',
]

@pulumi.output_type
class GetFleetErrorAnalyticsResult:
    """
    A collection of values returned by getFleetErrorAnalytics.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, fleet_error_aggregation_collections=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_error_aggregation_collections and not isinstance(fleet_error_aggregation_collections, list):
            raise TypeError("Expected argument 'fleet_error_aggregation_collections' to be a list")
        pulumi.set(__self__, "fleet_error_aggregation_collections", fleet_error_aggregation_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetErrorAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetErrorAggregationCollections")
    def fleet_error_aggregation_collections(self) -> Sequence['outputs.GetFleetErrorAnalyticsFleetErrorAggregationCollectionResult']:
        """
        The list of fleet_error_aggregation_collection.
        """
        return pulumi.get(self, "fleet_error_aggregation_collections")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFleetErrorAnalyticsResult(GetFleetErrorAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetErrorAnalyticsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            fleet_error_aggregation_collections=self.fleet_error_aggregation_collections,
            id=self.id)


def get_fleet_error_analytics(compartment_id: Optional[builtins.str] = None,
                              compartment_id_in_subtree: Optional[builtins.bool] = None,
                              filters: Optional[Sequence[Union['GetFleetErrorAnalyticsFilterArgs', 'GetFleetErrorAnalyticsFilterArgsDict']]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetErrorAnalyticsResult:
    """
    This data source provides the list of Fleet Error Analytics in Oracle Cloud Infrastructure Jms service.

    Returns a high level summary of FleetErrors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_error_analytics = oci.Jms.get_fleet_error_analytics(compartment_id=compartment_id,
        compartment_id_in_subtree=fleet_error_analytic_compartment_id_in_subtree)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetErrorAnalytics:getFleetErrorAnalytics', __args__, opts=opts, typ=GetFleetErrorAnalyticsResult).value

    return AwaitableGetFleetErrorAnalyticsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_error_aggregation_collections=pulumi.get(__ret__, 'fleet_error_aggregation_collections'),
        id=pulumi.get(__ret__, 'id'))
def get_fleet_error_analytics_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetErrorAnalyticsFilterArgs', 'GetFleetErrorAnalyticsFilterArgsDict']]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetErrorAnalyticsResult]:
    """
    This data source provides the list of Fleet Error Analytics in Oracle Cloud Infrastructure Jms service.

    Returns a high level summary of FleetErrors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_error_analytics = oci.Jms.get_fleet_error_analytics(compartment_id=compartment_id,
        compartment_id_in_subtree=fleet_error_analytic_compartment_id_in_subtree)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetErrorAnalytics:getFleetErrorAnalytics', __args__, opts=opts, typ=GetFleetErrorAnalyticsResult)
    return __ret__.apply(lambda __response__: GetFleetErrorAnalyticsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_error_aggregation_collections=pulumi.get(__response__, 'fleet_error_aggregation_collections'),
        id=pulumi.get(__response__, 'id')))
