# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLimitValuesResult',
    'AwaitableGetLimitValuesResult',
    'get_limit_values',
    'get_limit_values_output',
]

@pulumi.output_type
class GetLimitValuesResult:
    """
    A collection of values returned by getLimitValues.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, limit_values=None, name=None, scope_type=None, service_name=None, subscription_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit_values and not isinstance(limit_values, list):
            raise TypeError("Expected argument 'limit_values' to be a list")
        pulumi.set(__self__, "limit_values", limit_values)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scope_type and not isinstance(scope_type, str):
            raise TypeError("Expected argument 'scope_type' to be a str")
        pulumi.set(__self__, "scope_type", scope_type)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        If present, the returned value is only specific to this availability domain.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLimitValuesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="limitValues")
    def limit_values(self) -> Sequence['outputs.GetLimitValuesLimitValueResult']:
        """
        The list of limit_values.
        """
        return pulumi.get(self, "limit_values")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The resource limit name. To be used for writing policies (in case of quotas) or other programmatic calls.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> Optional[builtins.str]:
        """
        The scope type of the limit.
        """
        return pulumi.get(self, "scope_type")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subscription_id")


class AwaitableGetLimitValuesResult(GetLimitValuesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLimitValuesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            limit_values=self.limit_values,
            name=self.name,
            scope_type=self.scope_type,
            service_name=self.service_name,
            subscription_id=self.subscription_id)


def get_limit_values(availability_domain: Optional[builtins.str] = None,
                     compartment_id: Optional[builtins.str] = None,
                     filters: Optional[Sequence[Union['GetLimitValuesFilterArgs', 'GetLimitValuesFilterArgsDict']]] = None,
                     name: Optional[builtins.str] = None,
                     scope_type: Optional[builtins.str] = None,
                     service_name: Optional[builtins.str] = None,
                     subscription_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLimitValuesResult:
    """
    This data source provides the list of Limit Values in Oracle Cloud Infrastructure Limits service.

    Includes a full list of resource limits belonging to a given service. If subscription Id is provided, limit value for subscription will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_limit_values = oci.Limits.get_limit_values(compartment_id=tenancy_ocid,
        service_name=test_service["name"],
        availability_domain=limit_value_availability_domain,
        name=limit_value_name,
        scope_type=limit_value_scope_type,
        subscription_id=subscription_ocid)
    ```


    :param builtins.str availability_domain: Filter entries by availability domain. This implies that only AD-specific values are returned.
    :param builtins.str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param builtins.str name: Optional field, can be used to see a specific resource limit value.
    :param builtins.str scope_type: Filter entries by scope type.
    :param builtins.str service_name: The target service name.
    :param builtins.str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['scopeType'] = scope_type
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Limits/getLimitValues:getLimitValues', __args__, opts=opts, typ=GetLimitValuesResult).value

    return AwaitableGetLimitValuesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        limit_values=pulumi.get(__ret__, 'limit_values'),
        name=pulumi.get(__ret__, 'name'),
        scope_type=pulumi.get(__ret__, 'scope_type'),
        service_name=pulumi.get(__ret__, 'service_name'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_limit_values_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLimitValuesFilterArgs', 'GetLimitValuesFilterArgsDict']]]]] = None,
                            name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            scope_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            service_name: Optional[pulumi.Input[builtins.str]] = None,
                            subscription_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLimitValuesResult]:
    """
    This data source provides the list of Limit Values in Oracle Cloud Infrastructure Limits service.

    Includes a full list of resource limits belonging to a given service. If subscription Id is provided, limit value for subscription will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_limit_values = oci.Limits.get_limit_values(compartment_id=tenancy_ocid,
        service_name=test_service["name"],
        availability_domain=limit_value_availability_domain,
        name=limit_value_name,
        scope_type=limit_value_scope_type,
        subscription_id=subscription_ocid)
    ```


    :param builtins.str availability_domain: Filter entries by availability domain. This implies that only AD-specific values are returned.
    :param builtins.str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param builtins.str name: Optional field, can be used to see a specific resource limit value.
    :param builtins.str scope_type: Filter entries by scope type.
    :param builtins.str service_name: The target service name.
    :param builtins.str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['scopeType'] = scope_type
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Limits/getLimitValues:getLimitValues', __args__, opts=opts, typ=GetLimitValuesResult)
    return __ret__.apply(lambda __response__: GetLimitValuesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        limit_values=pulumi.get(__response__, 'limit_values'),
        name=pulumi.get(__response__, 'name'),
        scope_type=pulumi.get(__response__, 'scope_type'),
        service_name=pulumi.get(__response__, 'service_name'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
