# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSslCipherSuiteResult',
    'AwaitableGetSslCipherSuiteResult',
    'get_ssl_cipher_suite',
    'get_ssl_cipher_suite_output',
]

@pulumi.output_type
class GetSslCipherSuiteResult:
    """
    A collection of values returned by getSslCipherSuite.
    """
    def __init__(__self__, ciphers=None, id=None, load_balancer_id=None, name=None, state=None):
        if ciphers and not isinstance(ciphers, list):
            raise TypeError("Expected argument 'ciphers' to be a list")
        pulumi.set(__self__, "ciphers", ciphers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ciphers(self) -> Sequence[builtins.str]:
        """
        A list of SSL ciphers the load balancer must support for HTTPS or SSL connections.
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")


class AwaitableGetSslCipherSuiteResult(GetSslCipherSuiteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSslCipherSuiteResult(
            ciphers=self.ciphers,
            id=self.id,
            load_balancer_id=self.load_balancer_id,
            name=self.name,
            state=self.state)


def get_ssl_cipher_suite(load_balancer_id: Optional[builtins.str] = None,
                         name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSslCipherSuiteResult:
    """
    This data source provides details about a specific Ssl Cipher Suite resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the specified SSL cipher suite's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ssl_cipher_suite = oci.LoadBalancer.get_ssl_cipher_suite(load_balancer_id=test_load_balancer["id"],
        name=ssl_cipher_suite_name)
    ```


    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
    :param builtins.str name: The name of the SSL cipher suite to retrieve.
           
           example: `example_cipher_suite`
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getSslCipherSuite:getSslCipherSuite', __args__, opts=opts, typ=GetSslCipherSuiteResult).value

    return AwaitableGetSslCipherSuiteResult(
        ciphers=pulumi.get(__ret__, 'ciphers'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_ssl_cipher_suite_output(load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                                name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSslCipherSuiteResult]:
    """
    This data source provides details about a specific Ssl Cipher Suite resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the specified SSL cipher suite's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ssl_cipher_suite = oci.LoadBalancer.get_ssl_cipher_suite(load_balancer_id=test_load_balancer["id"],
        name=ssl_cipher_suite_name)
    ```


    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
    :param builtins.str name: The name of the SSL cipher suite to retrieve.
           
           example: `example_cipher_suite`
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LoadBalancer/getSslCipherSuite:getSslCipherSuite', __args__, opts=opts, typ=GetSslCipherSuiteResult)
    return __ret__.apply(lambda __response__: GetSslCipherSuiteResult(
        ciphers=pulumi.get(__response__, 'ciphers'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
