# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespaceScheduledTaskResult',
    'AwaitableGetNamespaceScheduledTaskResult',
    'get_namespace_scheduled_task',
    'get_namespace_scheduled_task_output',
]

@pulumi.output_type
class GetNamespaceScheduledTaskResult:
    """
    A collection of values returned by getNamespaceScheduledTask.
    """
    def __init__(__self__, actions=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, kind=None, namespace=None, num_occurrences=None, saved_search_id=None, scheduled_task_id=None, schedules=None, state=None, task_status=None, task_type=None, time_created=None, time_updated=None, work_request_id=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if num_occurrences and not isinstance(num_occurrences, str):
            raise TypeError("Expected argument 'num_occurrences' to be a str")
        pulumi.set(__self__, "num_occurrences", num_occurrences)
        if saved_search_id and not isinstance(saved_search_id, str):
            raise TypeError("Expected argument 'saved_search_id' to be a str")
        pulumi.set(__self__, "saved_search_id", saved_search_id)
        if scheduled_task_id and not isinstance(scheduled_task_id, str):
            raise TypeError("Expected argument 'scheduled_task_id' to be a str")
        pulumi.set(__self__, "scheduled_task_id", scheduled_task_id)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if task_status and not isinstance(task_status, str):
            raise TypeError("Expected argument 'task_status' to be a str")
        pulumi.set(__self__, "task_status", task_status)
        if task_type and not isinstance(task_type, str):
            raise TypeError("Expected argument 'task_type' to be a str")
        pulumi.set(__self__, "task_type", task_type)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetNamespaceScheduledTaskActionResult']:
        """
        Action for scheduled task.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name that is changeable and that does not have to be unique. Format: a leading alphanumeric, followed by zero or more alphanumerics, underscores, spaces, backslashes, or hyphens in any order). No trailing spaces allowed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the data plane resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        Discriminator.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace of the extracted metric. A valid value starts with an alphabetical character and includes only alphanumeric characters and underscores (_).
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="numOccurrences")
    def num_occurrences(self) -> builtins.str:
        """
        Number of execution occurrences.
        """
        return pulumi.get(self, "num_occurrences")

    @property
    @pulumi.getter(name="savedSearchId")
    def saved_search_id(self) -> builtins.str:
        """
        The ManagementSavedSearch id [OCID] utilized in the action.
        """
        return pulumi.get(self, "saved_search_id")

    @property
    @pulumi.getter(name="scheduledTaskId")
    def scheduled_task_id(self) -> builtins.str:
        return pulumi.get(self, "scheduled_task_id")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetNamespaceScheduledTaskScheduleResult']:
        """
        Schedules.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the scheduled task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> builtins.str:
        """
        Status of the scheduled task. - PURGE_RESOURCE_NOT_FOUND
        """
        return pulumi.get(self, "task_status")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> builtins.str:
        """
        Task type.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the scheduled task was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the scheduled task was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> builtins.str:
        """
        most recent Work Request Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the asynchronous request.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetNamespaceScheduledTaskResult(GetNamespaceScheduledTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceScheduledTaskResult(
            actions=self.actions,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            kind=self.kind,
            namespace=self.namespace,
            num_occurrences=self.num_occurrences,
            saved_search_id=self.saved_search_id,
            scheduled_task_id=self.scheduled_task_id,
            schedules=self.schedules,
            state=self.state,
            task_status=self.task_status,
            task_type=self.task_type,
            time_created=self.time_created,
            time_updated=self.time_updated,
            work_request_id=self.work_request_id)


def get_namespace_scheduled_task(namespace: Optional[builtins.str] = None,
                                 scheduled_task_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceScheduledTaskResult:
    """
    This data source provides details about a specific Namespace Scheduled Task resource in Oracle Cloud Infrastructure Log Analytics service.

    Get the scheduled task for the specified task identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_scheduled_task = oci.LogAnalytics.get_namespace_scheduled_task(namespace=namespace_scheduled_task_namespace,
        scheduled_task_id=test_scheduled_task["id"])
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str scheduled_task_id: Unique scheduledTask id returned from task create. If invalid will lead to a 404 not found.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['scheduledTaskId'] = scheduled_task_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceScheduledTask:getNamespaceScheduledTask', __args__, opts=opts, typ=GetNamespaceScheduledTaskResult).value

    return AwaitableGetNamespaceScheduledTaskResult(
        actions=pulumi.get(__ret__, 'actions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        namespace=pulumi.get(__ret__, 'namespace'),
        num_occurrences=pulumi.get(__ret__, 'num_occurrences'),
        saved_search_id=pulumi.get(__ret__, 'saved_search_id'),
        scheduled_task_id=pulumi.get(__ret__, 'scheduled_task_id'),
        schedules=pulumi.get(__ret__, 'schedules'),
        state=pulumi.get(__ret__, 'state'),
        task_status=pulumi.get(__ret__, 'task_status'),
        task_type=pulumi.get(__ret__, 'task_type'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_namespace_scheduled_task_output(namespace: Optional[pulumi.Input[builtins.str]] = None,
                                        scheduled_task_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceScheduledTaskResult]:
    """
    This data source provides details about a specific Namespace Scheduled Task resource in Oracle Cloud Infrastructure Log Analytics service.

    Get the scheduled task for the specified task identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_scheduled_task = oci.LogAnalytics.get_namespace_scheduled_task(namespace=namespace_scheduled_task_namespace,
        scheduled_task_id=test_scheduled_task["id"])
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str scheduled_task_id: Unique scheduledTask id returned from task create. If invalid will lead to a 404 not found.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['scheduledTaskId'] = scheduled_task_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getNamespaceScheduledTask:getNamespaceScheduledTask', __args__, opts=opts, typ=GetNamespaceScheduledTaskResult)
    return __ret__.apply(lambda __response__: GetNamespaceScheduledTaskResult(
        actions=pulumi.get(__response__, 'actions'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        namespace=pulumi.get(__response__, 'namespace'),
        num_occurrences=pulumi.get(__response__, 'num_occurrences'),
        saved_search_id=pulumi.get(__response__, 'saved_search_id'),
        scheduled_task_id=pulumi.get(__response__, 'scheduled_task_id'),
        schedules=pulumi.get(__response__, 'schedules'),
        state=pulumi.get(__response__, 'state'),
        task_status=pulumi.get(__response__, 'task_status'),
        task_type=pulumi.get(__response__, 'task_type'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
