# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamespaceStorageArchivalConfigArgs', 'NamespaceStorageArchivalConfig']

@pulumi.input_type
class NamespaceStorageArchivalConfigArgs:
    def __init__(__self__, *,
                 archiving_configuration: pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs'],
                 namespace: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a NamespaceStorageArchivalConfig resource.
        :param pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs'] archiving_configuration: (Updatable) This is the configuration for data archiving in object storage
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "archiving_configuration", archiving_configuration)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="archivingConfiguration")
    def archiving_configuration(self) -> pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs']:
        """
        (Updatable) This is the configuration for data archiving in object storage
        """
        return pulumi.get(self, "archiving_configuration")

    @archiving_configuration.setter
    def archiving_configuration(self, value: pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs']):
        pulumi.set(self, "archiving_configuration", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The Logging Analytics namespace used for the request.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _NamespaceStorageArchivalConfigState:
    def __init__(__self__, *,
                 archiving_configuration: Optional[pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs']] = None,
                 is_archiving_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamespaceStorageArchivalConfig resources.
        :param pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs'] archiving_configuration: (Updatable) This is the configuration for data archiving in object storage
        :param pulumi.Input[builtins.bool] is_archiving_enabled: This indicates if old data can be archived for a tenancy
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if archiving_configuration is not None:
            pulumi.set(__self__, "archiving_configuration", archiving_configuration)
        if is_archiving_enabled is not None:
            pulumi.set(__self__, "is_archiving_enabled", is_archiving_enabled)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="archivingConfiguration")
    def archiving_configuration(self) -> Optional[pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs']]:
        """
        (Updatable) This is the configuration for data archiving in object storage
        """
        return pulumi.get(self, "archiving_configuration")

    @archiving_configuration.setter
    def archiving_configuration(self, value: Optional[pulumi.Input['NamespaceStorageArchivalConfigArchivingConfigurationArgs']]):
        pulumi.set(self, "archiving_configuration", value)

    @property
    @pulumi.getter(name="isArchivingEnabled")
    def is_archiving_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This indicates if old data can be archived for a tenancy
        """
        return pulumi.get(self, "is_archiving_enabled")

    @is_archiving_enabled.setter
    def is_archiving_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_archiving_enabled", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Logging Analytics namespace used for the request.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.type_token("oci:LogAnalytics/namespaceStorageArchivalConfig:NamespaceStorageArchivalConfig")
class NamespaceStorageArchivalConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archiving_configuration: Optional[pulumi.Input[Union['NamespaceStorageArchivalConfigArchivingConfigurationArgs', 'NamespaceStorageArchivalConfigArchivingConfigurationArgsDict']]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Namespace Storage Archival Config resource in Oracle Cloud Infrastructure Log Analytics service.

        This API updates the archiving configuration

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_storage_archival_config = oci.log_analytics.NamespaceStorageArchivalConfig("test_namespace_storage_archival_config",
            archiving_configuration={
                "active_storage_duration": namespace_storage_archival_config_archiving_configuration_active_storage_duration,
                "archival_storage_duration": namespace_storage_archival_config_archiving_configuration_archival_storage_duration,
            },
            namespace=namespace_storage_archival_config_namespace)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamespaceStorageArchivalConfigArchivingConfigurationArgs', 'NamespaceStorageArchivalConfigArchivingConfigurationArgsDict']] archiving_configuration: (Updatable) This is the configuration for data archiving in object storage
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceStorageArchivalConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Namespace Storage Archival Config resource in Oracle Cloud Infrastructure Log Analytics service.

        This API updates the archiving configuration

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_storage_archival_config = oci.log_analytics.NamespaceStorageArchivalConfig("test_namespace_storage_archival_config",
            archiving_configuration={
                "active_storage_duration": namespace_storage_archival_config_archiving_configuration_active_storage_duration,
                "archival_storage_duration": namespace_storage_archival_config_archiving_configuration_archival_storage_duration,
            },
            namespace=namespace_storage_archival_config_namespace)
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceStorageArchivalConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceStorageArchivalConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archiving_configuration: Optional[pulumi.Input[Union['NamespaceStorageArchivalConfigArchivingConfigurationArgs', 'NamespaceStorageArchivalConfigArchivingConfigurationArgsDict']]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceStorageArchivalConfigArgs.__new__(NamespaceStorageArchivalConfigArgs)

            if archiving_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'archiving_configuration'")
            __props__.__dict__["archiving_configuration"] = archiving_configuration
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["is_archiving_enabled"] = None
        super(NamespaceStorageArchivalConfig, __self__).__init__(
            'oci:LogAnalytics/namespaceStorageArchivalConfig:NamespaceStorageArchivalConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archiving_configuration: Optional[pulumi.Input[Union['NamespaceStorageArchivalConfigArchivingConfigurationArgs', 'NamespaceStorageArchivalConfigArchivingConfigurationArgsDict']]] = None,
            is_archiving_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None) -> 'NamespaceStorageArchivalConfig':
        """
        Get an existing NamespaceStorageArchivalConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamespaceStorageArchivalConfigArchivingConfigurationArgs', 'NamespaceStorageArchivalConfigArchivingConfigurationArgsDict']] archiving_configuration: (Updatable) This is the configuration for data archiving in object storage
        :param pulumi.Input[builtins.bool] is_archiving_enabled: This indicates if old data can be archived for a tenancy
        :param pulumi.Input[builtins.str] namespace: The Logging Analytics namespace used for the request.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceStorageArchivalConfigState.__new__(_NamespaceStorageArchivalConfigState)

        __props__.__dict__["archiving_configuration"] = archiving_configuration
        __props__.__dict__["is_archiving_enabled"] = is_archiving_enabled
        __props__.__dict__["namespace"] = namespace
        return NamespaceStorageArchivalConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archivingConfiguration")
    def archiving_configuration(self) -> pulumi.Output['outputs.NamespaceStorageArchivalConfigArchivingConfiguration']:
        """
        (Updatable) This is the configuration for data archiving in object storage
        """
        return pulumi.get(self, "archiving_configuration")

    @property
    @pulumi.getter(name="isArchivingEnabled")
    def is_archiving_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This indicates if old data can be archived for a tenancy
        """
        return pulumi.get(self, "is_archiving_enabled")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        The Logging Analytics namespace used for the request.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

