# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ManagementAgentDataSourceList',
    'ManagementAgentDataSourceListMetricDimension',
    'ManagementAgentDataSourceMetricDimension',
    'ManagementAgentDataSourceSummaryList',
    'ManagementAgentManagementAgentProperty',
    'ManagementAgentPluginList',
    'GetManagementAgentAvailableHistoriesAvailabilityHistoryResult',
    'GetManagementAgentAvailableHistoriesFilterResult',
    'GetManagementAgentCountItemResult',
    'GetManagementAgentCountItemDimensionResult',
    'GetManagementAgentDataSourceListResult',
    'GetManagementAgentDataSourceListMetricDimensionResult',
    'GetManagementAgentDataSourceMetricDimensionResult',
    'GetManagementAgentDataSourceSummaryListResult',
    'GetManagementAgentDataSourcesDataSourceResult',
    'GetManagementAgentDataSourcesFilterResult',
    'GetManagementAgentImagesFilterResult',
    'GetManagementAgentImagesManagementAgentImageResult',
    'GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult',
    'GetManagementAgentInstallKeysFilterResult',
    'GetManagementAgentInstallKeysManagementAgentInstallKeyResult',
    'GetManagementAgentManagementAgentPropertyResult',
    'GetManagementAgentPluginCountItemResult',
    'GetManagementAgentPluginCountItemDimensionResult',
    'GetManagementAgentPluginListResult',
    'GetManagementAgentPluginsFilterResult',
    'GetManagementAgentPluginsManagementAgentPluginResult',
    'GetManagementAgentsFilterResult',
    'GetManagementAgentsManagementAgentResult',
    'GetManagementAgentsManagementAgentDataSourceListResult',
    'GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult',
    'GetManagementAgentsManagementAgentDataSourceSummaryListResult',
    'GetManagementAgentsManagementAgentManagementAgentPropertyResult',
    'GetManagementAgentsManagementAgentPluginListResult',
]

@pulumi.output_type
class ManagementAgentDataSourceList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMetrics":
            suggest = "allow_metrics"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "connectionTimeout":
            suggest = "connection_timeout"
        elif key == "isDaemonSet":
            suggest = "is_daemon_set"
        elif key == "metricDimensions":
            suggest = "metric_dimensions"
        elif key == "proxyUrl":
            suggest = "proxy_url"
        elif key == "readDataLimit":
            suggest = "read_data_limit"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "scheduleMins":
            suggest = "schedule_mins"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentDataSourceList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentDataSourceList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentDataSourceList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_metrics: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 connection_timeout: Optional[builtins.int] = None,
                 is_daemon_set: Optional[builtins.bool] = None,
                 key: Optional[builtins.str] = None,
                 metric_dimensions: Optional[Sequence['outputs.ManagementAgentDataSourceListMetricDimension']] = None,
                 name: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 proxy_url: Optional[builtins.str] = None,
                 read_data_limit: Optional[builtins.int] = None,
                 read_timeout: Optional[builtins.int] = None,
                 resource_group: Optional[builtins.str] = None,
                 schedule_mins: Optional[builtins.int] = None,
                 state: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str allow_metrics: Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param builtins.str compartment_id: Compartment owning this DataSource.
        :param builtins.int connection_timeout: Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param Sequence['ManagementAgentDataSourceListMetricDimensionArgs'] metric_dimensions: The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param builtins.str name: Name of the property
        :param builtins.str namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param builtins.str proxy_url: The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param builtins.int read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param builtins.int read_timeout: Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param builtins.str resource_group: Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param builtins.int schedule_mins: Number in minutes. The scraping occurs at the specified interval.
        :param builtins.str state: The current state of managementAgent
        :param builtins.str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param builtins.str type: The type of the DataSource.
        :param builtins.str url: The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        if allow_metrics is not None:
            pulumi.set(__self__, "allow_metrics", allow_metrics)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if is_daemon_set is not None:
            pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if read_data_limit is not None:
            pulumi.set(__self__, "read_data_limit", read_data_limit)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if schedule_mins is not None:
            pulumi.set(__self__, "schedule_mins", schedule_mins)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> Optional[builtins.str]:
        """
        Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[builtins.int]:
        """
        Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> Optional[builtins.bool]:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[Sequence['outputs.ManagementAgentDataSourceListMetricDimension']]:
        """
        The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[builtins.str]:
        """
        The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> Optional[builtins.int]:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[builtins.int]:
        """
        Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[builtins.str]:
        """
        Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> Optional[builtins.int]:
        """
        Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ManagementAgentDataSourceListMetricDimension(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the property
        :param builtins.str value: Value of the metric dimension
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagementAgentDataSourceMetricDimension(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: (Updatable) Name of the metric dimension
        :param builtins.str value: (Updatable) Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        (Updatable) Name of the metric dimension
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        (Updatable) Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagementAgentDataSourceSummaryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDaemonSet":
            suggest = "is_daemon_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentDataSourceSummaryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentDataSourceSummaryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentDataSourceSummaryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_daemon_set: Optional[builtins.bool] = None,
                 key: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param builtins.str name: Name of the property
        :param builtins.str type: The type of the DataSource.
        """
        if is_daemon_set is not None:
            pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> Optional[builtins.bool]:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagementAgentManagementAgentProperty(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 units: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: Name of the property
        :param builtins.str units: Unit for the property
        :param Sequence[builtins.str] values: Values of the property
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> Optional[builtins.str]:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ManagementAgentPluginList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "pluginDisplayName":
            suggest = "plugin_display_name"
        elif key == "pluginId":
            suggest = "plugin_id"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "pluginStatus":
            suggest = "plugin_status"
        elif key == "pluginStatusMessage":
            suggest = "plugin_status_message"
        elif key == "pluginVersion":
            suggest = "plugin_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentPluginList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentPluginList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentPluginList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[builtins.bool] = None,
                 plugin_display_name: Optional[builtins.str] = None,
                 plugin_id: Optional[builtins.str] = None,
                 plugin_name: Optional[builtins.str] = None,
                 plugin_status: Optional[builtins.str] = None,
                 plugin_status_message: Optional[builtins.str] = None,
                 plugin_version: Optional[builtins.str] = None):
        """
        :param builtins.bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param builtins.str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param builtins.str plugin_id: Plugin Id
        :param builtins.str plugin_name: Management Agent Plugin Name
        :param builtins.str plugin_status: Plugin Status
        :param builtins.str plugin_status_message: Status message of the Plugin
        :param builtins.str plugin_version: Plugin Version
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if plugin_display_name is not None:
            pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if plugin_status is not None:
            pulumi.set(__self__, "plugin_status", plugin_status)
        if plugin_status_message is not None:
            pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> Optional[builtins.str]:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[builtins.str]:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[builtins.str]:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> Optional[builtins.str]:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> Optional[builtins.str]:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[builtins.str]:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


@pulumi.output_type
class GetManagementAgentAvailableHistoriesAvailabilityHistoryResult(dict):
    def __init__(__self__, *,
                 availability_status: builtins.str,
                 management_agent_id: builtins.str,
                 time_availability_status_ended: builtins.str,
                 time_availability_status_started: builtins.str):
        """
        :param builtins.str availability_status: The availability status of managementAgent
        :param builtins.str management_agent_id: Unique Management Agent identifier
        :param builtins.str time_availability_status_ended: The time till which the Management Agent was known to be in the availability status. An RFC3339 formatted datetime string
        :param builtins.str time_availability_status_started: The time at which the Management Agent moved to the availability status. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        pulumi.set(__self__, "time_availability_status_ended", time_availability_status_ended)
        pulumi.set(__self__, "time_availability_status_started", time_availability_status_started)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> builtins.str:
        """
        The availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> builtins.str:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="timeAvailabilityStatusEnded")
    def time_availability_status_ended(self) -> builtins.str:
        """
        The time till which the Management Agent was known to be in the availability status. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_availability_status_ended")

    @property
    @pulumi.getter(name="timeAvailabilityStatusStarted")
    def time_availability_status_started(self) -> builtins.str:
        """
        The time at which the Management Agent moved to the availability status. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_availability_status_started")


@pulumi.output_type
class GetManagementAgentAvailableHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentCountItemResult(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 dimensions: Sequence['outputs.GetManagementAgentCountItemDimensionResult']):
        """
        :param builtins.int count: The number of Management Agents in this group
        :param Sequence['GetManagementAgentCountItemDimensionArgs'] dimensions: The Aggregation of Management Agent Dimensions
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of Management Agents in this group
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetManagementAgentCountItemDimensionResult']:
        """
        The Aggregation of Management Agent Dimensions
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class GetManagementAgentCountItemDimensionResult(dict):
    def __init__(__self__, *,
                 availability_status: builtins.str,
                 has_plugins: builtins.bool,
                 install_type: builtins.str,
                 platform_type: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str availability_status: The availability status of managementAgent
        :param builtins.bool has_plugins: When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
        :param builtins.str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        :param builtins.str platform_type: Platform Type
        :param builtins.str version: Agent image version
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "has_plugins", has_plugins)
        pulumi.set(__self__, "install_type", install_type)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> builtins.str:
        """
        The availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="hasPlugins")
    def has_plugins(self) -> builtins.bool:
        """
        When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
        """
        return pulumi.get(self, "has_plugins")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> builtins.str:
        """
        A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> builtins.str:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Agent image version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentDataSourceListResult(dict):
    def __init__(__self__, *,
                 allow_metrics: builtins.str,
                 compartment_id: builtins.str,
                 connection_timeout: builtins.int,
                 is_daemon_set: builtins.bool,
                 key: builtins.str,
                 metric_dimensions: Sequence['outputs.GetManagementAgentDataSourceListMetricDimensionResult'],
                 name: builtins.str,
                 namespace: builtins.str,
                 proxy_url: builtins.str,
                 read_data_limit: builtins.int,
                 read_timeout: builtins.int,
                 resource_group: builtins.str,
                 schedule_mins: builtins.int,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str allow_metrics: Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param builtins.str compartment_id: Compartment owning this DataSource.
        :param builtins.int connection_timeout: Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param Sequence['GetManagementAgentDataSourceListMetricDimensionArgs'] metric_dimensions: The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param builtins.str name: Name of the property
        :param builtins.str namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param builtins.str proxy_url: The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param builtins.int read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param builtins.int read_timeout: Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param builtins.str resource_group: Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param builtins.int schedule_mins: Number in minutes. The scraping occurs at the specified interval.
        :param builtins.str state: The current state of managementAgent
        :param builtins.str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param builtins.str type: The type of the DataSource.
        :param builtins.str url: The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        pulumi.set(__self__, "allow_metrics", allow_metrics)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "proxy_url", proxy_url)
        pulumi.set(__self__, "read_data_limit", read_data_limit)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "schedule_mins", schedule_mins)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> builtins.str:
        """
        Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> builtins.int:
        """
        Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> builtins.bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Sequence['outputs.GetManagementAgentDataSourceListMetricDimensionResult']:
        """
        The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> builtins.str:
        """
        The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> builtins.int:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> builtins.int:
        """
        Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> builtins.int:
        """
        Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetManagementAgentDataSourceListMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the property
        :param builtins.str value: Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentDataSourceMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Unique name of the DataSource.
        :param builtins.str value: Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentDataSourceSummaryListResult(dict):
    def __init__(__self__, *,
                 is_daemon_set: builtins.bool,
                 key: builtins.str,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param builtins.str name: Name of the property
        :param builtins.str type: The type of the DataSource.
        """
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> builtins.bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagementAgentDataSourcesDataSourceResult(dict):
    def __init__(__self__, *,
                 data_source_key: builtins.str,
                 type: builtins.str,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str data_source_key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param builtins.str type: The type of the DataSource.
        :param builtins.str name: Unique name of the dataSource.
        """
        pulumi.set(__self__, "data_source_key", data_source_key)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataSourceKey")
    def data_source_key(self) -> builtins.str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "data_source_key")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Unique name of the dataSource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetManagementAgentDataSourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Unique name of the dataSource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name of the dataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A filter to return only resources that match the entire platform name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire platform name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentImagesManagementAgentImageResult(dict):
    def __init__(__self__, *,
                 checksum: builtins.str,
                 id: builtins.str,
                 image_object_storage_details: Sequence['outputs.GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult'],
                 object_url: builtins.str,
                 package_architecture_type: builtins.str,
                 package_type: builtins.str,
                 platform_name: builtins.str,
                 platform_type: builtins.str,
                 size: builtins.float,
                 state: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str checksum: Object content SHA256 Hash
        :param builtins.str id: Agent image resource id
        :param Sequence['GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailArgs'] image_object_storage_details: Details of the Objectstorage object
        :param builtins.str object_url: Object storage URL for download
        :param builtins.str package_architecture_type: The installation package target architecture type
        :param builtins.str package_type: The installation package type
        :param builtins.str platform_name: Agent image platform display name
        :param builtins.str platform_type: Agent image platform type
        :param builtins.float size: Agent image size in bytes
        :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
        :param builtins.str version: Agent image version
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_object_storage_details", image_object_storage_details)
        pulumi.set(__self__, "object_url", object_url)
        pulumi.set(__self__, "package_architecture_type", package_architecture_type)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "platform_name", platform_name)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def checksum(self) -> builtins.str:
        """
        Object content SHA256 Hash
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Agent image resource id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageObjectStorageDetails")
    def image_object_storage_details(self) -> Sequence['outputs.GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult']:
        """
        Details of the Objectstorage object
        """
        return pulumi.get(self, "image_object_storage_details")

    @property
    @pulumi.getter(name="objectUrl")
    def object_url(self) -> builtins.str:
        """
        Object storage URL for download
        """
        return pulumi.get(self, "object_url")

    @property
    @pulumi.getter(name="packageArchitectureType")
    def package_architecture_type(self) -> builtins.str:
        """
        The installation package target architecture type
        """
        return pulumi.get(self, "package_architecture_type")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> builtins.str:
        """
        The installation package type
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> builtins.str:
        """
        Agent image platform display name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> builtins.str:
        """
        Agent image platform type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter
    def size(self) -> builtins.float:
        """
        Agent image size in bytes
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Agent image version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 checksum: builtins.str,
                 object: builtins.str,
                 object_bucket: builtins.str,
                 object_namespace: builtins.str,
                 object_url: builtins.str):
        """
        :param builtins.str checksum: Object content SHA256 Hash
        :param builtins.str object: Objectstorage object name reference providing the original location of this object
        :param builtins.str object_bucket: Objectstorage bucket reference providing the original location of this object
        :param builtins.str object_namespace: Objectstorage namespace reference providing the original location of this object
        :param builtins.str object_url: Object storage URL for download
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "object_bucket", object_bucket)
        pulumi.set(__self__, "object_namespace", object_namespace)
        pulumi.set(__self__, "object_url", object_url)

    @property
    @pulumi.getter
    def checksum(self) -> builtins.str:
        """
        Object content SHA256 Hash
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        Objectstorage object name reference providing the original location of this object
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectBucket")
    def object_bucket(self) -> builtins.str:
        """
        Objectstorage bucket reference providing the original location of this object
        """
        return pulumi.get(self, "object_bucket")

    @property
    @pulumi.getter(name="objectNamespace")
    def object_namespace(self) -> builtins.str:
        """
        Objectstorage namespace reference providing the original location of this object
        """
        return pulumi.get(self, "object_namespace")

    @property
    @pulumi.getter(name="objectUrl")
    def object_url(self) -> builtins.str:
        """
        Object storage URL for download
        """
        return pulumi.get(self, "object_url")


@pulumi.output_type
class GetManagementAgentInstallKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentInstallKeysManagementAgentInstallKeyResult(dict):
    def __init__(__self__, *,
                 allowed_key_install_count: builtins.int,
                 compartment_id: builtins.str,
                 created_by_principal_id: builtins.str,
                 current_key_install_count: builtins.int,
                 display_name: builtins.str,
                 id: builtins.str,
                 is_unlimited: builtins.bool,
                 key: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_expires: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.int allowed_key_install_count: Total number of install for this keys
        :param builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param builtins.str created_by_principal_id: Principal id of user who created the Agent Install key
        :param builtins.int current_key_install_count: Total number of install for this keys
        :param builtins.str display_name: The display name for which the Key needs to be listed.
        :param builtins.str id: Agent install Key identifier
        :param builtins.bool is_unlimited: If set to true, the install key has no expiration date or usage limit. Properties allowedKeyInstallCount and timeExpires are ignored if set to true. Defaults to false.
        :param builtins.str key: Management Agent Install Key
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
        :param builtins.str time_created: The time when Management Agent install Key was created. An RFC3339 formatted date time string
        :param builtins.str time_expires: date after which key would expire after creation
        :param builtins.str time_updated: The time when Management Agent install Key was updated. An RFC3339 formatted date time string
        """
        pulumi.set(__self__, "allowed_key_install_count", allowed_key_install_count)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by_principal_id", created_by_principal_id)
        pulumi.set(__self__, "current_key_install_count", current_key_install_count)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_expires", time_expires)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="allowedKeyInstallCount")
    def allowed_key_install_count(self) -> builtins.int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "allowed_key_install_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdByPrincipalId")
    def created_by_principal_id(self) -> builtins.str:
        """
        Principal id of user who created the Agent Install key
        """
        return pulumi.get(self, "created_by_principal_id")

    @property
    @pulumi.getter(name="currentKeyInstallCount")
    def current_key_install_count(self) -> builtins.int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "current_key_install_count")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name for which the Key needs to be listed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Agent install Key identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> builtins.bool:
        """
        If set to true, the install key has no expiration date or usage limit. Properties allowedKeyInstallCount and timeExpires are ignored if set to true. Defaults to false.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Management Agent Install Key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time when Management Agent install Key was created. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> builtins.str:
        """
        date after which key would expire after creation
        """
        return pulumi.get(self, "time_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time when Management Agent install Key was updated. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetManagementAgentManagementAgentPropertyResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 units: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the property
        :param builtins.str units: Unit for the property
        :param Sequence[builtins.str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "units", units)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> builtins.str:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetManagementAgentPluginCountItemResult(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 dimensions: Sequence['outputs.GetManagementAgentPluginCountItemDimensionResult']):
        """
        :param builtins.int count: The number of Management Agent Plugins in this group
        :param Sequence['GetManagementAgentPluginCountItemDimensionArgs'] dimensions: The Aggregation of Management Agent Plugin Dimensions
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of Management Agent Plugins in this group
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetManagementAgentPluginCountItemDimensionResult']:
        """
        The Aggregation of Management Agent Plugin Dimensions
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class GetManagementAgentPluginCountItemDimensionResult(dict):
    def __init__(__self__, *,
                 plugin_display_name: builtins.str,
                 plugin_name: builtins.str):
        """
        :param builtins.str plugin_display_name: Management Agent Plugin Display Name
        :param builtins.str plugin_name: Management Agent Plugin Name
        """
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_name", plugin_name)

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> builtins.str:
        """
        Management Agent Plugin Display Name
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> builtins.str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")


@pulumi.output_type
class GetManagementAgentPluginListResult(dict):
    def __init__(__self__, *,
                 is_enabled: builtins.bool,
                 plugin_display_name: builtins.str,
                 plugin_id: builtins.str,
                 plugin_name: builtins.str,
                 plugin_status: builtins.str,
                 plugin_status_message: builtins.str,
                 plugin_version: builtins.str):
        """
        :param builtins.bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param builtins.str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param builtins.str plugin_id: Plugin Id
        :param builtins.str plugin_name: Management Agent Plugin Name
        :param builtins.str plugin_status: Plugin Status
        :param builtins.str plugin_status_message: Status message of the Plugin
        :param builtins.str plugin_version: Plugin Version
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_status", plugin_status)
        pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> builtins.str:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> builtins.str:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> builtins.str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> builtins.str:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> builtins.str:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> builtins.str:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


@pulumi.output_type
class GetManagementAgentPluginsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Management Agent Plugin Name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentPluginsManagementAgentPluginResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 is_console_deployable: builtins.bool,
                 name: builtins.str,
                 state: builtins.str,
                 supported_platform_types: Sequence[builtins.str],
                 version: builtins.int):
        """
        :param builtins.str description: Management Agent Plugin description
        :param builtins.str display_name: Filter to return only Management Agent Plugins having the particular display name.
        :param builtins.str id: Management Agent Plugin Id
        :param builtins.bool is_console_deployable: A flag to indicate whether a given plugin can be deployed from Agent Console UI or not.
        :param builtins.str name: Management Agent Plugin Name
        :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
        :param Sequence[builtins.str] supported_platform_types: Supported Platform Types
        :param builtins.int version: Management Agent Plugin Version
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_console_deployable", is_console_deployable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "supported_platform_types", supported_platform_types)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Management Agent Plugin description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Filter to return only Management Agent Plugins having the particular display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Management Agent Plugin Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isConsoleDeployable")
    def is_console_deployable(self) -> builtins.bool:
        """
        A flag to indicate whether a given plugin can be deployed from Agent Console UI or not.
        """
        return pulumi.get(self, "is_console_deployable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedPlatformTypes")
    def supported_platform_types(self) -> Sequence[builtins.str]:
        """
        Supported Platform Types
        """
        return pulumi.get(self, "supported_platform_types")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        Management Agent Plugin Version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the property
        :param Sequence[builtins.str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentsManagementAgentResult(dict):
    def __init__(__self__, *,
                 availability_status: builtins.str,
                 compartment_id: builtins.str,
                 data_source_lists: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListResult'],
                 data_source_summary_lists: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceSummaryListResult'],
                 defined_tags: Mapping[str, builtins.str],
                 deploy_plugins_ids: Sequence[builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 host: builtins.str,
                 host_id: builtins.str,
                 id: builtins.str,
                 install_key_id: builtins.str,
                 install_path: builtins.str,
                 install_type: builtins.str,
                 is_agent_auto_upgradable: builtins.bool,
                 is_customer_deployed: builtins.bool,
                 lifecycle_details: builtins.str,
                 managed_agent_id: builtins.str,
                 management_agent_properties: Sequence['outputs.GetManagementAgentsManagementAgentManagementAgentPropertyResult'],
                 platform_name: builtins.str,
                 platform_type: builtins.str,
                 platform_version: builtins.str,
                 plugin_lists: Sequence['outputs.GetManagementAgentsManagementAgentPluginListResult'],
                 resource_artifact_version: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_last_heartbeat: builtins.str,
                 time_updated: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str availability_status: Filter to return only Management Agents in the particular availability status.
        :param builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param Sequence['GetManagementAgentsManagementAgentDataSourceSummaryListArgs'] data_source_summary_lists: list of dataSources associated with the agent
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: Filter to return only Management Agents having the particular display name.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str host: Management Agent host machine name
        :param builtins.str host_id: Filter to return only Management Agents having the particular agent host id.
        :param builtins.str id: agent identifier
        :param builtins.str install_key_id: agent install key identifier
        :param builtins.str install_path: Path where Management Agent is installed
        :param builtins.str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        :param builtins.bool is_agent_auto_upgradable: true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        :param builtins.bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetManagementAgentsManagementAgentManagementAgentPropertyArgs'] management_agent_properties: Additional properties for this Management Agent
        :param builtins.str platform_name: Platform Name
        :param builtins.str platform_type: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
        :param builtins.str platform_version: Platform Version
        :param Sequence['GetManagementAgentsManagementAgentPluginListArgs'] plugin_lists: list of managementAgentPlugins associated with the agent
        :param builtins.str resource_artifact_version: Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
        :param builtins.str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param builtins.str time_last_heartbeat: The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param builtins.str version: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_source_lists", data_source_lists)
        pulumi.set(__self__, "data_source_summary_lists", data_source_summary_lists)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "deploy_plugins_ids", deploy_plugins_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "install_key_id", install_key_id)
        pulumi.set(__self__, "install_path", install_path)
        pulumi.set(__self__, "install_type", install_type)
        pulumi.set(__self__, "is_agent_auto_upgradable", is_agent_auto_upgradable)
        pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "managed_agent_id", managed_agent_id)
        pulumi.set(__self__, "management_agent_properties", management_agent_properties)
        pulumi.set(__self__, "platform_name", platform_name)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "platform_version", platform_version)
        pulumi.set(__self__, "plugin_lists", plugin_lists)
        pulumi.set(__self__, "resource_artifact_version", resource_artifact_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_heartbeat", time_last_heartbeat)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular availability status.
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceLists")
    def data_source_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListResult']:
        return pulumi.get(self, "data_source_lists")

    @property
    @pulumi.getter(name="dataSourceSummaryLists")
    def data_source_summary_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceSummaryListResult']:
        """
        list of dataSources associated with the agent
        """
        return pulumi.get(self, "data_source_summary_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "deploy_plugins_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Filter to return only Management Agents having the particular display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Management Agent host machine name
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> builtins.str:
        """
        Filter to return only Management Agents having the particular agent host id.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        agent identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installKeyId")
    def install_key_id(self) -> builtins.str:
        """
        agent install key identifier
        """
        return pulumi.get(self, "install_key_id")

    @property
    @pulumi.getter(name="installPath")
    def install_path(self) -> builtins.str:
        """
        Path where Management Agent is installed
        """
        return pulumi.get(self, "install_path")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> builtins.str:
        """
        A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="isAgentAutoUpgradable")
    def is_agent_auto_upgradable(self) -> builtins.bool:
        """
        true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        """
        return pulumi.get(self, "is_agent_auto_upgradable")

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> builtins.bool:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> builtins.str:
        return pulumi.get(self, "managed_agent_id")

    @property
    @pulumi.getter(name="managementAgentProperties")
    def management_agent_properties(self) -> Sequence['outputs.GetManagementAgentsManagementAgentManagementAgentPropertyResult']:
        """
        Additional properties for this Management Agent
        """
        return pulumi.get(self, "management_agent_properties")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> builtins.str:
        """
        Platform Name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> builtins.str:
        """
        Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> builtins.str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentPluginListResult']:
        """
        list of managementAgentPlugins associated with the agent
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter(name="resourceArtifactVersion")
    def resource_artifact_version(self) -> builtins.str:
        """
        Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        """
        return pulumi.get(self, "resource_artifact_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastHeartbeat")
    def time_last_heartbeat(self) -> builtins.str:
        """
        The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_heartbeat")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceListResult(dict):
    def __init__(__self__, *,
                 allow_metrics: builtins.str,
                 compartment_id: builtins.str,
                 connection_timeout: builtins.int,
                 is_daemon_set: builtins.bool,
                 key: builtins.str,
                 metric_dimensions: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult'],
                 name: builtins.str,
                 namespace: builtins.str,
                 proxy_url: builtins.str,
                 read_data_limit: builtins.int,
                 read_timeout: builtins.int,
                 resource_group: builtins.str,
                 schedule_mins: builtins.int,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param builtins.str name: Name of the property
        :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
        :param builtins.str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param builtins.str type: The type of the DataSource.
        """
        pulumi.set(__self__, "allow_metrics", allow_metrics)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "proxy_url", proxy_url)
        pulumi.set(__self__, "read_data_limit", read_data_limit)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "schedule_mins", schedule_mins)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> builtins.str:
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> builtins.int:
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> builtins.bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult']:
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> builtins.str:
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> builtins.int:
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> builtins.int:
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> builtins.int:
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        return pulumi.get(self, "url")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceSummaryListResult(dict):
    def __init__(__self__, *,
                 is_daemon_set: builtins.bool,
                 key: builtins.str,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param builtins.str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param builtins.str name: Name of the property
        :param builtins.str type: The type of the DataSource.
        """
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> builtins.bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagementAgentsManagementAgentManagementAgentPropertyResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 units: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the property
        :param builtins.str units: Unit for the property
        :param Sequence[builtins.str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "units", units)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> builtins.str:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetManagementAgentsManagementAgentPluginListResult(dict):
    def __init__(__self__, *,
                 is_enabled: builtins.bool,
                 plugin_display_name: builtins.str,
                 plugin_id: builtins.str,
                 plugin_name: builtins.str,
                 plugin_status: builtins.str,
                 plugin_status_message: builtins.str,
                 plugin_version: builtins.str):
        """
        :param builtins.bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param builtins.str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param builtins.str plugin_id: Plugin Id
        :param builtins.str plugin_name: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
        :param builtins.str plugin_status: Plugin Status
        :param builtins.str plugin_status_message: Status message of the Plugin
        :param builtins.str plugin_version: Plugin Version
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_status", plugin_status)
        pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> builtins.str:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> builtins.str:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> builtins.str:
        """
        Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> builtins.str:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> builtins.str:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> builtins.str:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


