# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetListingTaxesResult',
    'AwaitableGetListingTaxesResult',
    'get_listing_taxes',
    'get_listing_taxes_output',
]

@pulumi.output_type
class GetListingTaxesResult:
    """
    A collection of values returned by getListingTaxes.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, listing_id=None, taxes=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if taxes and not isinstance(taxes, list):
            raise TypeError("Expected argument 'taxes' to be a list")
        pulumi.set(__self__, "taxes", taxes)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetListingTaxesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> builtins.str:
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter
    def taxes(self) -> Sequence['outputs.GetListingTaxesTaxResult']:
        """
        The list of taxes.
        """
        return pulumi.get(self, "taxes")


class AwaitableGetListingTaxesResult(GetListingTaxesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListingTaxesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            listing_id=self.listing_id,
            taxes=self.taxes)


def get_listing_taxes(compartment_id: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetListingTaxesFilterArgs', 'GetListingTaxesFilterArgsDict']]] = None,
                      listing_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListingTaxesResult:
    """
    This data source provides the list of Listing Taxes in Oracle Cloud Infrastructure Marketplace service.

    Returns list of all tax implications that current tenant may be liable to once they launch the listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing_taxes = oci.Marketplace.get_listing_taxes(listing_id=test_listing["id"],
        compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    :param builtins.str listing_id: The unique identifier for the listing.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['listingId'] = listing_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getListingTaxes:getListingTaxes', __args__, opts=opts, typ=GetListingTaxesResult).value

    return AwaitableGetListingTaxesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        taxes=pulumi.get(__ret__, 'taxes'))
def get_listing_taxes_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetListingTaxesFilterArgs', 'GetListingTaxesFilterArgsDict']]]]] = None,
                             listing_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListingTaxesResult]:
    """
    This data source provides the list of Listing Taxes in Oracle Cloud Infrastructure Marketplace service.

    Returns list of all tax implications that current tenant may be liable to once they launch the listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing_taxes = oci.Marketplace.get_listing_taxes(listing_id=test_listing["id"],
        compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    :param builtins.str listing_id: The unique identifier for the listing.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['listingId'] = listing_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Marketplace/getListingTaxes:getListingTaxes', __args__, opts=opts, typ=GetListingTaxesResult)
    return __ret__.apply(lambda __response__: GetListingTaxesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        listing_id=pulumi.get(__response__, 'listing_id'),
        taxes=pulumi.get(__response__, 'taxes')))
