# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsageStatementEmailRecipientsGroupsResult',
    'AwaitableGetUsageStatementEmailRecipientsGroupsResult',
    'get_usage_statement_email_recipients_groups',
    'get_usage_statement_email_recipients_groups_output',
]

@pulumi.output_type
class GetUsageStatementEmailRecipientsGroupsResult:
    """
    A collection of values returned by getUsageStatementEmailRecipientsGroups.
    """
    def __init__(__self__, compartment_id=None, email_recipients_group_collections=None, filters=None, id=None, subscription_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if email_recipients_group_collections and not isinstance(email_recipients_group_collections, list):
            raise TypeError("Expected argument 'email_recipients_group_collections' to be a list")
        pulumi.set(__self__, "email_recipients_group_collections", email_recipients_group_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The customer tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="emailRecipientsGroupCollections")
    def email_recipients_group_collections(self) -> Sequence['outputs.GetUsageStatementEmailRecipientsGroupsEmailRecipientsGroupCollectionResult']:
        """
        The list of email_recipients_group_collection.
        """
        return pulumi.get(self, "email_recipients_group_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUsageStatementEmailRecipientsGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return pulumi.get(self, "subscription_id")


class AwaitableGetUsageStatementEmailRecipientsGroupsResult(GetUsageStatementEmailRecipientsGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsageStatementEmailRecipientsGroupsResult(
            compartment_id=self.compartment_id,
            email_recipients_group_collections=self.email_recipients_group_collections,
            filters=self.filters,
            id=self.id,
            subscription_id=self.subscription_id)


def get_usage_statement_email_recipients_groups(compartment_id: Optional[builtins.str] = None,
                                                filters: Optional[Sequence[Union['GetUsageStatementEmailRecipientsGroupsFilterArgs', 'GetUsageStatementEmailRecipientsGroupsFilterArgsDict']]] = None,
                                                subscription_id: Optional[builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsageStatementEmailRecipientsGroupsResult:
    """
    This data source provides the list of Usage Statement Email Recipients Groups in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved usage statement email recipients group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_statement_email_recipients_groups = oci.MeteringComputation.get_usage_statement_email_recipients_groups(compartment_id=compartment_id,
        subscription_id=test_subscription["id"])
    ```


    :param builtins.str compartment_id: The compartment ID in which to list resources.
    :param builtins.str subscription_id: The usage statement subscription unique OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getUsageStatementEmailRecipientsGroups:getUsageStatementEmailRecipientsGroups', __args__, opts=opts, typ=GetUsageStatementEmailRecipientsGroupsResult).value

    return AwaitableGetUsageStatementEmailRecipientsGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        email_recipients_group_collections=pulumi.get(__ret__, 'email_recipients_group_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_usage_statement_email_recipients_groups_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUsageStatementEmailRecipientsGroupsFilterArgs', 'GetUsageStatementEmailRecipientsGroupsFilterArgsDict']]]]] = None,
                                                       subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsageStatementEmailRecipientsGroupsResult]:
    """
    This data source provides the list of Usage Statement Email Recipients Groups in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved usage statement email recipients group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_statement_email_recipients_groups = oci.MeteringComputation.get_usage_statement_email_recipients_groups(compartment_id=compartment_id,
        subscription_id=test_subscription["id"])
    ```


    :param builtins.str compartment_id: The compartment ID in which to list resources.
    :param builtins.str subscription_id: The usage statement subscription unique OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MeteringComputation/getUsageStatementEmailRecipientsGroups:getUsageStatementEmailRecipientsGroups', __args__, opts=opts, typ=GetUsageStatementEmailRecipientsGroupsResult)
    return __ret__.apply(lambda __response__: GetUsageStatementEmailRecipientsGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        email_recipients_group_collections=pulumi.get(__response__, 'email_recipients_group_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
