# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlarmSuppressionsResult',
    'AwaitableGetAlarmSuppressionsResult',
    'get_alarm_suppressions',
    'get_alarm_suppressions_output',
]

@pulumi.output_type
class GetAlarmSuppressionsResult:
    """
    A collection of values returned by getAlarmSuppressions.
    """
    def __init__(__self__, alarm_id=None, alarm_suppression_collections=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, is_all_suppressions=None, level=None, state=None, target_type=None):
        if alarm_id and not isinstance(alarm_id, str):
            raise TypeError("Expected argument 'alarm_id' to be a str")
        pulumi.set(__self__, "alarm_id", alarm_id)
        if alarm_suppression_collections and not isinstance(alarm_suppression_collections, list):
            raise TypeError("Expected argument 'alarm_suppression_collections' to be a list")
        pulumi.set(__self__, "alarm_suppression_collections", alarm_suppression_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_all_suppressions and not isinstance(is_all_suppressions, bool):
            raise TypeError("Expected argument 'is_all_suppressions' to be a bool")
        pulumi.set(__self__, "is_all_suppressions", is_all_suppressions)
        if level and not isinstance(level, str):
            raise TypeError("Expected argument 'level' to be a str")
        pulumi.set(__self__, "level", level)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="alarmSuppressionCollections")
    def alarm_suppression_collections(self) -> Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionResult']:
        """
        The list of alarm_suppression_collection.
        """
        return pulumi.get(self, "alarm_suppression_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        """
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAlarmSuppressionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAllSuppressions")
    def is_all_suppressions(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_all_suppressions")

    @property
    @pulumi.getter
    def level(self) -> Optional[builtins.str]:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[builtins.str]:
        """
        The type of the alarm suppression target.
        """
        return pulumi.get(self, "target_type")


class AwaitableGetAlarmSuppressionsResult(GetAlarmSuppressionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmSuppressionsResult(
            alarm_id=self.alarm_id,
            alarm_suppression_collections=self.alarm_suppression_collections,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_all_suppressions=self.is_all_suppressions,
            level=self.level,
            state=self.state,
            target_type=self.target_type)


def get_alarm_suppressions(alarm_id: Optional[builtins.str] = None,
                           compartment_id: Optional[builtins.str] = None,
                           compartment_id_in_subtree: Optional[builtins.bool] = None,
                           display_name: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetAlarmSuppressionsFilterArgs', 'GetAlarmSuppressionsFilterArgsDict']]] = None,
                           is_all_suppressions: Optional[builtins.bool] = None,
                           level: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           target_type: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmSuppressionsResult:
    """
    This data source provides the list of Alarm Suppressions in Oracle Cloud Infrastructure Monitoring service.

    Lists alarm suppressions for the specified alarm. For more information, see
    [Listing Alarm Suppressions](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/list-alarm-suppression.htm).

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppressions = oci.Monitoring.get_alarm_suppressions(alarm_id=test_alarm["id"],
        compartment_id=compartment_id,
        compartment_id_in_subtree=alarm_suppression_compartment_id_in_subtree,
        display_name=alarm_suppression_display_name,
        is_all_suppressions=alarm_suppression_is_all_suppressions,
        level=alarm_suppression_level,
        state=alarm_suppression_state,
        target_type=alarm_suppression_target_type)
    ```


    :param builtins.str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.
           
           If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.
           
           Example: `ocid1.compartment.oc1..exampleuniqueID`
    :param builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list an alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
    :param builtins.bool is_all_suppressions: Setting this parameter to true requires the query to specify the alarm (`alarmId`).
           
           When true, lists all alarm suppressions that affect the specified alarm, including suppressions that target the corresponding compartment or tenancy. When false, lists only the alarm suppressions that target the specified alarm.
           
           Default is false.
    :param builtins.str level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
    :param builtins.str target_type: The target type to use when listing alarm suppressions.     `ALARM` lists all suppression records for the specified alarm. `COMPARTMENT` lists all suppression records for the specified compartment or tenancy.
    """
    __args__ = dict()
    __args__['alarmId'] = alarm_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isAllSuppressions'] = is_all_suppressions
    __args__['level'] = level
    __args__['state'] = state
    __args__['targetType'] = target_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Monitoring/getAlarmSuppressions:getAlarmSuppressions', __args__, opts=opts, typ=GetAlarmSuppressionsResult).value

    return AwaitableGetAlarmSuppressionsResult(
        alarm_id=pulumi.get(__ret__, 'alarm_id'),
        alarm_suppression_collections=pulumi.get(__ret__, 'alarm_suppression_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_all_suppressions=pulumi.get(__ret__, 'is_all_suppressions'),
        level=pulumi.get(__ret__, 'level'),
        state=pulumi.get(__ret__, 'state'),
        target_type=pulumi.get(__ret__, 'target_type'))
def get_alarm_suppressions_output(alarm_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                  display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAlarmSuppressionsFilterArgs', 'GetAlarmSuppressionsFilterArgsDict']]]]] = None,
                                  is_all_suppressions: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                  level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  target_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlarmSuppressionsResult]:
    """
    This data source provides the list of Alarm Suppressions in Oracle Cloud Infrastructure Monitoring service.

    Lists alarm suppressions for the specified alarm. For more information, see
    [Listing Alarm Suppressions](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/list-alarm-suppression.htm).

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppressions = oci.Monitoring.get_alarm_suppressions(alarm_id=test_alarm["id"],
        compartment_id=compartment_id,
        compartment_id_in_subtree=alarm_suppression_compartment_id_in_subtree,
        display_name=alarm_suppression_display_name,
        is_all_suppressions=alarm_suppression_is_all_suppressions,
        level=alarm_suppression_level,
        state=alarm_suppression_state,
        target_type=alarm_suppression_target_type)
    ```


    :param builtins.str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.
           
           If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.
           
           Example: `ocid1.compartment.oc1..exampleuniqueID`
    :param builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list an alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
    :param builtins.bool is_all_suppressions: Setting this parameter to true requires the query to specify the alarm (`alarmId`).
           
           When true, lists all alarm suppressions that affect the specified alarm, including suppressions that target the corresponding compartment or tenancy. When false, lists only the alarm suppressions that target the specified alarm.
           
           Default is false.
    :param builtins.str level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
    :param builtins.str target_type: The target type to use when listing alarm suppressions.     `ALARM` lists all suppression records for the specified alarm. `COMPARTMENT` lists all suppression records for the specified compartment or tenancy.
    """
    __args__ = dict()
    __args__['alarmId'] = alarm_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isAllSuppressions'] = is_all_suppressions
    __args__['level'] = level
    __args__['state'] = state
    __args__['targetType'] = target_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Monitoring/getAlarmSuppressions:getAlarmSuppressions', __args__, opts=opts, typ=GetAlarmSuppressionsResult)
    return __ret__.apply(lambda __response__: GetAlarmSuppressionsResult(
        alarm_id=pulumi.get(__response__, 'alarm_id'),
        alarm_suppression_collections=pulumi.get(__response__, 'alarm_suppression_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_all_suppressions=pulumi.get(__response__, 'is_all_suppressions'),
        level=pulumi.get(__response__, 'level'),
        state=pulumi.get(__response__, 'state'),
        target_type=pulumi.get(__response__, 'target_type')))
