# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'NetworkFirewallNatConfigurationArgs',
    'NetworkFirewallNatConfigurationArgsDict',
    'NetworkFirewallPolicyDecryptionRuleConditionArgs',
    'NetworkFirewallPolicyDecryptionRuleConditionArgsDict',
    'NetworkFirewallPolicyDecryptionRulePositionArgs',
    'NetworkFirewallPolicyDecryptionRulePositionArgsDict',
    'NetworkFirewallPolicyNatRuleConditionArgs',
    'NetworkFirewallPolicyNatRuleConditionArgsDict',
    'NetworkFirewallPolicyNatRulePositionArgs',
    'NetworkFirewallPolicyNatRulePositionArgsDict',
    'NetworkFirewallPolicySecurityRuleConditionArgs',
    'NetworkFirewallPolicySecurityRuleConditionArgsDict',
    'NetworkFirewallPolicySecurityRulePositionArgs',
    'NetworkFirewallPolicySecurityRulePositionArgsDict',
    'NetworkFirewallPolicyServicePortRangeArgs',
    'NetworkFirewallPolicyServicePortRangeArgsDict',
    'NetworkFirewallPolicyTunnelInspectionRuleConditionArgs',
    'NetworkFirewallPolicyTunnelInspectionRuleConditionArgsDict',
    'NetworkFirewallPolicyTunnelInspectionRulePositionArgs',
    'NetworkFirewallPolicyTunnelInspectionRulePositionArgsDict',
    'NetworkFirewallPolicyTunnelInspectionRuleProfileArgs',
    'NetworkFirewallPolicyTunnelInspectionRuleProfileArgsDict',
    'NetworkFirewallPolicyUrlListUrlArgs',
    'NetworkFirewallPolicyUrlListUrlArgsDict',
    'GetNetworkFirewallPoliciesFilterArgs',
    'GetNetworkFirewallPoliciesFilterArgsDict',
    'GetNetworkFirewallPolicyAddressListsFilterArgs',
    'GetNetworkFirewallPolicyAddressListsFilterArgsDict',
    'GetNetworkFirewallPolicyApplicationGroupsFilterArgs',
    'GetNetworkFirewallPolicyApplicationGroupsFilterArgsDict',
    'GetNetworkFirewallPolicyApplicationsFilterArgs',
    'GetNetworkFirewallPolicyApplicationsFilterArgsDict',
    'GetNetworkFirewallPolicyDecryptionProfilesFilterArgs',
    'GetNetworkFirewallPolicyDecryptionProfilesFilterArgsDict',
    'GetNetworkFirewallPolicyDecryptionRulesFilterArgs',
    'GetNetworkFirewallPolicyDecryptionRulesFilterArgsDict',
    'GetNetworkFirewallPolicyNatRulesFilterArgs',
    'GetNetworkFirewallPolicyNatRulesFilterArgsDict',
    'GetNetworkFirewallPolicySecurityRulesFilterArgs',
    'GetNetworkFirewallPolicySecurityRulesFilterArgsDict',
    'GetNetworkFirewallPolicyServiceListsFilterArgs',
    'GetNetworkFirewallPolicyServiceListsFilterArgsDict',
    'GetNetworkFirewallPolicyServicesFilterArgs',
    'GetNetworkFirewallPolicyServicesFilterArgsDict',
    'GetNetworkFirewallPolicyTunnelInspectionRulesFilterArgs',
    'GetNetworkFirewallPolicyTunnelInspectionRulesFilterArgsDict',
    'GetNetworkFirewallPolicyUrlListsFilterArgs',
    'GetNetworkFirewallPolicyUrlListsFilterArgsDict',
    'GetNetworkFirewallsFilterArgs',
    'GetNetworkFirewallsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class NetworkFirewallNatConfigurationArgsDict(TypedDict):
        must_enable_private_nat: pulumi.Input[builtins.bool]
        """
        (Updatable) To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall. The value of this field can not be false to release the NAT IPs given that the attached network firewall policy does not contains any NAT rules. The value of this field should be set to true if the network firewall policy being applied contains NAT rules.
        """
        nat_ip_address_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An array of NAT IP addresses that are associated with the Network Firewall. These IPs are reserved for NAT and shouldn't be used for any other purpose in the subnet.
        """
elif False:
    NetworkFirewallNatConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallNatConfigurationArgs:
    def __init__(__self__, *,
                 must_enable_private_nat: pulumi.Input[builtins.bool],
                 nat_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.bool] must_enable_private_nat: (Updatable) To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall. The value of this field can not be false to release the NAT IPs given that the attached network firewall policy does not contains any NAT rules. The value of this field should be set to true if the network firewall policy being applied contains NAT rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nat_ip_address_lists: An array of NAT IP addresses that are associated with the Network Firewall. These IPs are reserved for NAT and shouldn't be used for any other purpose in the subnet.
        """
        pulumi.set(__self__, "must_enable_private_nat", must_enable_private_nat)
        if nat_ip_address_lists is not None:
            pulumi.set(__self__, "nat_ip_address_lists", nat_ip_address_lists)

    @property
    @pulumi.getter(name="mustEnablePrivateNat")
    def must_enable_private_nat(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall. The value of this field can not be false to release the NAT IPs given that the attached network firewall policy does not contains any NAT rules. The value of this field should be set to true if the network firewall policy being applied contains NAT rules.
        """
        return pulumi.get(self, "must_enable_private_nat")

    @must_enable_private_nat.setter
    def must_enable_private_nat(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "must_enable_private_nat", value)

    @property
    @pulumi.getter(name="natIpAddressLists")
    def nat_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of NAT IP addresses that are associated with the Network Firewall. These IPs are reserved for NAT and shouldn't be used for any other purpose in the subnet.
        """
        return pulumi.get(self, "nat_ip_address_lists")

    @nat_ip_address_lists.setter
    def nat_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nat_ip_address_lists", value)


if not MYPY:
    class NetworkFirewallPolicyDecryptionRuleConditionArgsDict(TypedDict):
        destination_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        source_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
elif False:
    NetworkFirewallPolicyDecryptionRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyDecryptionRuleConditionArgs:
    def __init__(__self__, *,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_addresses: (Updatable) An array of address list names to be evaluated against the traffic destination address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_addresses: (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)


if not MYPY:
    class NetworkFirewallPolicyDecryptionRulePositionArgsDict(TypedDict):
        after_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        before_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    NetworkFirewallPolicyDecryptionRulePositionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyDecryptionRulePositionArgs:
    def __init__(__self__, *,
                 after_rule: Optional[pulumi.Input[builtins.str]] = None,
                 before_rule: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param pulumi.Input[builtins.str] before_rule: (Updatable) Identifier for rule before which this rule lies.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if after_rule is not None:
            pulumi.set(__self__, "after_rule", after_rule)
        if before_rule is not None:
            pulumi.set(__self__, "before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @after_rule.setter
    def after_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "after_rule", value)

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "before_rule")

    @before_rule.setter
    def before_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "before_rule", value)


if not MYPY:
    class NetworkFirewallPolicyNatRuleConditionArgsDict(TypedDict):
        destination_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        """
        service: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A Service name to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        source_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
elif False:
    NetworkFirewallPolicyNatRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyNatRuleConditionArgs:
    def __init__(__self__, *,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_addresses: (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        :param pulumi.Input[builtins.str] service: (Updatable) A Service name to be evaluated against the traffic protocol and protocol-specific parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_addresses: (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A Service name to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)


if not MYPY:
    class NetworkFirewallPolicyNatRulePositionArgsDict(TypedDict):
        after_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        before_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule before which this rule lies.
        """
elif False:
    NetworkFirewallPolicyNatRulePositionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyNatRulePositionArgs:
    def __init__(__self__, *,
                 after_rule: Optional[pulumi.Input[builtins.str]] = None,
                 before_rule: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param pulumi.Input[builtins.str] before_rule: (Updatable) Identifier for rule before which this rule lies.
        """
        if after_rule is not None:
            pulumi.set(__self__, "after_rule", after_rule)
        if before_rule is not None:
            pulumi.set(__self__, "before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @after_rule.setter
    def after_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "after_rule", value)

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")

    @before_rule.setter
    def before_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "before_rule", value)


if not MYPY:
    class NetworkFirewallPolicySecurityRuleConditionArgsDict(TypedDict):
        applications: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of application group names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        destination_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        services: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        source_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        urls: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of URL list names to be evaluated against the HTTP(S) request target.
        """
elif False:
    NetworkFirewallPolicySecurityRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicySecurityRuleConditionArgs:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] applications: (Updatable) An array of application group names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_addresses: (Updatable) An array of address list names to be evaluated against the traffic destination address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: (Updatable) An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_addresses: (Updatable) An array of address list names to be evaluated against the traffic source address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: (Updatable) An array of URL list names to be evaluated against the HTTP(S) request target.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of application group names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of URL list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "urls", value)


if not MYPY:
    class NetworkFirewallPolicySecurityRulePositionArgsDict(TypedDict):
        after_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        before_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    NetworkFirewallPolicySecurityRulePositionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicySecurityRulePositionArgs:
    def __init__(__self__, *,
                 after_rule: Optional[pulumi.Input[builtins.str]] = None,
                 before_rule: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param pulumi.Input[builtins.str] before_rule: (Updatable) Identifier for rule before which this rule lies.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if after_rule is not None:
            pulumi.set(__self__, "after_rule", after_rule)
        if before_rule is not None:
            pulumi.set(__self__, "before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @after_rule.setter
    def after_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "after_rule", value)

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule before which this rule lies.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "before_rule")

    @before_rule.setter
    def before_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "before_rule", value)


if not MYPY:
    class NetworkFirewallPolicyServicePortRangeArgsDict(TypedDict):
        minimum_port: pulumi.Input[builtins.int]
        """
        (Updatable) The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        maximum_port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
elif False:
    NetworkFirewallPolicyServicePortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyServicePortRangeArgs:
    def __init__(__self__, *,
                 minimum_port: pulumi.Input[builtins.int],
                 maximum_port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] minimum_port: (Updatable) The minimum port in the range (inclusive), or the sole port of a single-port range.
        :param pulumi.Input[builtins.int] maximum_port: (Updatable) The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        pulumi.set(__self__, "minimum_port", minimum_port)
        if maximum_port is not None:
            pulumi.set(__self__, "maximum_port", maximum_port)

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The minimum port in the range (inclusive), or the sole port of a single-port range.
        """
        return pulumi.get(self, "minimum_port")

    @minimum_port.setter
    def minimum_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minimum_port", value)

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum port in the range (inclusive), which may be absent for a single-port range.
        """
        return pulumi.get(self, "maximum_port")

    @maximum_port.setter
    def maximum_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_port", value)


if not MYPY:
    class NetworkFirewallPolicyTunnelInspectionRuleConditionArgsDict(TypedDict):
        destination_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        source_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
elif False:
    NetworkFirewallPolicyTunnelInspectionRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyTunnelInspectionRuleConditionArgs:
    def __init__(__self__, *,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_addresses: (Updatable) An array of address list names to be evaluated against the traffic destination address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_addresses: (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)


if not MYPY:
    class NetworkFirewallPolicyTunnelInspectionRulePositionArgsDict(TypedDict):
        after_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        before_rule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Identifier for rule before which this rule lies.
        """
elif False:
    NetworkFirewallPolicyTunnelInspectionRulePositionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyTunnelInspectionRulePositionArgs:
    def __init__(__self__, *,
                 after_rule: Optional[pulumi.Input[builtins.str]] = None,
                 before_rule: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] after_rule: (Updatable) Identifier for rule after which this rule lies.
        :param pulumi.Input[builtins.str] before_rule: (Updatable) Identifier for rule before which this rule lies.
        """
        if after_rule is not None:
            pulumi.set(__self__, "after_rule", after_rule)
        if before_rule is not None:
            pulumi.set(__self__, "before_rule", before_rule)

    @property
    @pulumi.getter(name="afterRule")
    def after_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule after which this rule lies.
        """
        return pulumi.get(self, "after_rule")

    @after_rule.setter
    def after_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "after_rule", value)

    @property
    @pulumi.getter(name="beforeRule")
    def before_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for rule before which this rule lies.
        """
        return pulumi.get(self, "before_rule")

    @before_rule.setter
    def before_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "before_rule", value)


if not MYPY:
    class NetworkFirewallPolicyTunnelInspectionRuleProfileArgsDict(TypedDict):
        must_return_traffic_to_source: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Return scanned VXLAN tunnel traffic to source.
        """
elif False:
    NetworkFirewallPolicyTunnelInspectionRuleProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyTunnelInspectionRuleProfileArgs:
    def __init__(__self__, *,
                 must_return_traffic_to_source: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] must_return_traffic_to_source: (Updatable) Return scanned VXLAN tunnel traffic to source.
        """
        if must_return_traffic_to_source is not None:
            pulumi.set(__self__, "must_return_traffic_to_source", must_return_traffic_to_source)

    @property
    @pulumi.getter(name="mustReturnTrafficToSource")
    def must_return_traffic_to_source(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Return scanned VXLAN tunnel traffic to source.
        """
        return pulumi.get(self, "must_return_traffic_to_source")

    @must_return_traffic_to_source.setter
    def must_return_traffic_to_source(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "must_return_traffic_to_source", value)


if not MYPY:
    class NetworkFirewallPolicyUrlListUrlArgsDict(TypedDict):
        pattern: pulumi.Input[builtins.str]
        """
        (Updatable) A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        """
        type: pulumi.Input[builtins.str]
        """
        (Updatable) The type of pattern.
        * SIMPLE - The only accepted value is `SIMPLE`. A simple pattern with optional subdomain and/or path suffix wildcards.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    NetworkFirewallPolicyUrlListUrlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkFirewallPolicyUrlListUrlArgs:
    def __init__(__self__, *,
                 pattern: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] pattern: (Updatable) A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        :param pulumi.Input[builtins.str] type: (Updatable) The type of pattern.
               * SIMPLE - The only accepted value is `SIMPLE`. A simple pattern with optional subdomain and/or path suffix wildcards.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A string consisting of a concatenation of optional host component and optional path component. The host component may start with `*.` to match the case-insensitive domain and all its subdomains. The path component must start with a `/`, and may end with `*` to match all paths of which it is a case-sensitive prefix. A missing host component matches all request domains, and a missing path component matches all request paths. An empty value matches all requests.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of pattern.
        * SIMPLE - The only accepted value is `SIMPLE`. A simple pattern with optional subdomain and/or path suffix wildcards.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class GetNetworkFirewallPoliciesFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPoliciesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyAddressListsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyAddressListsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyAddressListsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Unique name to identify the group of addresses to be used in the policy rules.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyApplicationGroupsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the application Group.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyApplicationGroupsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyApplicationGroupsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the application Group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the application Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyApplicationsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the application.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyApplicationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyApplicationsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the application.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyDecryptionProfilesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Unique Name of the decryption profile.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyDecryptionProfilesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyDecryptionProfilesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Unique Name of the decryption profile.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyDecryptionRulesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name for the decryption rule, must be unique within the policy.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyDecryptionRulesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyDecryptionRulesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name for the decryption rule, must be unique within the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyNatRulesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name for the NAT rule, must be unique within the policy.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyNatRulesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyNatRulesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name for the NAT rule, must be unique within the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the NAT rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicySecurityRulesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name for the Security rule, must be unique within the policy.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicySecurityRulesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicySecurityRulesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name for the Security rule, must be unique within the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyServiceListsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the service Group.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyServiceListsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyServiceListsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the service Group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the service Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyServicesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the service.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyServicesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyServicesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the service.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyTunnelInspectionRulesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name for the Tunnel Inspection Rule, must be unique within the policy.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyTunnelInspectionRulesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyTunnelInspectionRulesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name for the Tunnel Inspection Rule, must be unique within the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name for the Tunnel Inspection Rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallPolicyUrlListsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Unique name identifier for the URL list.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallPolicyUrlListsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallPolicyUrlListsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Unique name identifier for the URL list.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name identifier for the URL list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkFirewallsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkFirewallsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkFirewallsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


