# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyNatRuleArgs', 'NetworkFirewallPolicyNatRule']

@pulumi.input_type
class NetworkFirewallPolicyNatRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 condition: pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs'],
                 network_firewall_policy_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 position: Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyNatRule resource.
        :param pulumi.Input[builtins.str] action: (Updatable) action:
               * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        :param pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs'] condition: (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] type: (Updatable) NAT type:
               * NATV4 - NATV4 type NAT.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] description: (Updatable) Description of a NAT rule. This field can be used to add additional info.
        :param pulumi.Input[builtins.str] name: Name for the NAT rule, must be unique within the policy.
        :param pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs'] position: (Updatable) An object which defines the position of the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) action:
        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs']:
        """
        (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) NAT type:
        * NATV4 - NATV4 type NAT.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description of a NAT rule. This field can be used to add additional info.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for the NAT rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']]:
        """
        (Updatable) An object which defines the position of the rule.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']]):
        pulumi.set(self, "position", value)


@pulumi.input_type
class _NetworkFirewallPolicyNatRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 position: Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']] = None,
                 priority_order: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyNatRule resources.
        :param pulumi.Input[builtins.str] action: (Updatable) action:
               * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        :param pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs'] condition: (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of a NAT rule. This field can be used to add additional info.
        :param pulumi.Input[builtins.str] name: Name for the NAT rule, must be unique within the policy.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption profile belongs to.
        :param pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs'] position: (Updatable) An object which defines the position of the rule.
        :param pulumi.Input[builtins.str] priority_order: The priority order in which this rule should be evaluated
        :param pulumi.Input[builtins.str] type: (Updatable) NAT type:
               * NATV4 - NATV4 type NAT.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) action:
        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs']]:
        """
        (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['NetworkFirewallPolicyNatRuleConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description of a NAT rule. This field can be used to add additional info.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for the NAT rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']]:
        """
        (Updatable) An object which defines the position of the rule.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['NetworkFirewallPolicyNatRulePositionArgs']]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The priority order in which this rule should be evaluated
        """
        return pulumi.get(self, "priority_order")

    @priority_order.setter
    def priority_order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority_order", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) NAT type:
        * NATV4 - NATV4 type NAT.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:NetworkFirewall/networkFirewallPolicyNatRule:NetworkFirewallPolicyNatRule")
class NetworkFirewallPolicyNatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRuleConditionArgs', 'NetworkFirewallPolicyNatRuleConditionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 position: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRulePositionArgs', 'NetworkFirewallPolicyNatRulePositionArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Nat Rule resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new NAT Rule for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_nat_rule = oci.network_firewall.NetworkFirewallPolicyNatRule("test_network_firewall_policy_nat_rule",
            action=network_firewall_policy_nat_rule_action,
            condition={
                "destination_addresses": network_firewall_policy_nat_rule_condition_destination_address,
                "service": network_firewall_policy_nat_rule_condition_service,
                "source_addresses": network_firewall_policy_nat_rule_condition_source_address,
            },
            name=network_firewall_policy_nat_rule_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_nat_rule_type,
            description=network_firewall_policy_nat_rule_description,
            position={
                "after_rule": network_firewall_policy_nat_rule_position_after_rule,
                "before_rule": network_firewall_policy_nat_rule_position_before_rule,
            })
        ```

        ## Import

        NetworkFirewallPolicyNatRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyNatRule:NetworkFirewallPolicyNatRule test_network_firewall_policy_nat_rule "networkFirewallPolicies/{networkFirewallPolicyId}/natRules/{natRuleName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: (Updatable) action:
               * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        :param pulumi.Input[Union['NetworkFirewallPolicyNatRuleConditionArgs', 'NetworkFirewallPolicyNatRuleConditionArgsDict']] condition: (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of a NAT rule. This field can be used to add additional info.
        :param pulumi.Input[builtins.str] name: Name for the NAT rule, must be unique within the policy.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Union['NetworkFirewallPolicyNatRulePositionArgs', 'NetworkFirewallPolicyNatRulePositionArgsDict']] position: (Updatable) An object which defines the position of the rule.
        :param pulumi.Input[builtins.str] type: (Updatable) NAT type:
               * NATV4 - NATV4 type NAT.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyNatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Nat Rule resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new NAT Rule for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_nat_rule = oci.network_firewall.NetworkFirewallPolicyNatRule("test_network_firewall_policy_nat_rule",
            action=network_firewall_policy_nat_rule_action,
            condition={
                "destination_addresses": network_firewall_policy_nat_rule_condition_destination_address,
                "service": network_firewall_policy_nat_rule_condition_service,
                "source_addresses": network_firewall_policy_nat_rule_condition_source_address,
            },
            name=network_firewall_policy_nat_rule_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_nat_rule_type,
            description=network_firewall_policy_nat_rule_description,
            position={
                "after_rule": network_firewall_policy_nat_rule_position_after_rule,
                "before_rule": network_firewall_policy_nat_rule_position_before_rule,
            })
        ```

        ## Import

        NetworkFirewallPolicyNatRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyNatRule:NetworkFirewallPolicyNatRule test_network_firewall_policy_nat_rule "networkFirewallPolicies/{networkFirewallPolicyId}/natRules/{natRuleName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyNatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyNatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRuleConditionArgs', 'NetworkFirewallPolicyNatRuleConditionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 position: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRulePositionArgs', 'NetworkFirewallPolicyNatRulePositionArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyNatRuleArgs.__new__(NetworkFirewallPolicyNatRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            __props__.__dict__["position"] = position
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["parent_resource_id"] = None
            __props__.__dict__["priority_order"] = None
        super(NetworkFirewallPolicyNatRule, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyNatRule:NetworkFirewallPolicyNatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRuleConditionArgs', 'NetworkFirewallPolicyNatRuleConditionArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            position: Optional[pulumi.Input[Union['NetworkFirewallPolicyNatRulePositionArgs', 'NetworkFirewallPolicyNatRulePositionArgsDict']]] = None,
            priority_order: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkFirewallPolicyNatRule':
        """
        Get an existing NetworkFirewallPolicyNatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: (Updatable) action:
               * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        :param pulumi.Input[Union['NetworkFirewallPolicyNatRuleConditionArgs', 'NetworkFirewallPolicyNatRuleConditionArgsDict']] condition: (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of a NAT rule. This field can be used to add additional info.
        :param pulumi.Input[builtins.str] name: Name for the NAT rule, must be unique within the policy.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption profile belongs to.
        :param pulumi.Input[Union['NetworkFirewallPolicyNatRulePositionArgs', 'NetworkFirewallPolicyNatRulePositionArgsDict']] position: (Updatable) An object which defines the position of the rule.
        :param pulumi.Input[builtins.str] priority_order: The priority order in which this rule should be evaluated
        :param pulumi.Input[builtins.str] type: (Updatable) NAT type:
               * NATV4 - NATV4 type NAT.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyNatRuleState.__new__(_NetworkFirewallPolicyNatRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["condition"] = condition
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["position"] = position
        __props__.__dict__["priority_order"] = priority_order
        __props__.__dict__["type"] = type
        return NetworkFirewallPolicyNatRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) action:
        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output['outputs.NetworkFirewallPolicyNatRuleCondition']:
        """
        (Updatable) Match criteria used in NAT Rule used on the firewall policy.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Description of a NAT rule. This field can be used to add additional info.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for the NAT rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def position(self) -> pulumi.Output['outputs.NetworkFirewallPolicyNatRulePosition']:
        """
        (Updatable) An object which defines the position of the rule.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> pulumi.Output[builtins.str]:
        """
        The priority order in which this rule should be evaluated
        """
        return pulumi.get(self, "priority_order")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) NAT type:
        * NATV4 - NATV4 type NAT.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

