# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbmulticloudOracleDbAzureKeysResult',
    'AwaitableGetDbmulticloudOracleDbAzureKeysResult',
    'get_dbmulticloud_oracle_db_azure_keys',
    'get_dbmulticloud_oracle_db_azure_keys_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureKeysResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureKeys.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oracle_db_azure_key_id=None, oracle_db_azure_key_summary_collections=None, oracle_db_azure_vault_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oracle_db_azure_key_id and not isinstance(oracle_db_azure_key_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_key_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_key_id", oracle_db_azure_key_id)
        if oracle_db_azure_key_summary_collections and not isinstance(oracle_db_azure_key_summary_collections, list):
            raise TypeError("Expected argument 'oracle_db_azure_key_summary_collections' to be a list")
        pulumi.set(__self__, "oracle_db_azure_key_summary_collections", oracle_db_azure_key_summary_collections)
        if oracle_db_azure_vault_id and not isinstance(oracle_db_azure_vault_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_vault_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_vault_id", oracle_db_azure_vault_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Vault Key Resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Display name of Oracle DB Azure Vault Key.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbmulticloudOracleDbAzureKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="oracleDbAzureKeyId")
    def oracle_db_azure_key_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "oracle_db_azure_key_id")

    @property
    @pulumi.getter(name="oracleDbAzureKeySummaryCollections")
    def oracle_db_azure_key_summary_collections(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureKeysOracleDbAzureKeySummaryCollectionResult']:
        """
        The list of oracle_db_azure_key_summary_collection.
        """
        return pulumi.get(self, "oracle_db_azure_key_summary_collections")

    @property
    @pulumi.getter(name="oracleDbAzureVaultId")
    def oracle_db_azure_vault_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Azure Vault Resource.
        """
        return pulumi.get(self, "oracle_db_azure_vault_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the Oracle DB Azure Vault Key Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbmulticloudOracleDbAzureKeysResult(GetDbmulticloudOracleDbAzureKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureKeysResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oracle_db_azure_key_id=self.oracle_db_azure_key_id,
            oracle_db_azure_key_summary_collections=self.oracle_db_azure_key_summary_collections,
            oracle_db_azure_vault_id=self.oracle_db_azure_vault_id,
            state=self.state)


def get_dbmulticloud_oracle_db_azure_keys(compartment_id: Optional[builtins.str] = None,
                                          display_name: Optional[builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetDbmulticloudOracleDbAzureKeysFilterArgs', 'GetDbmulticloudOracleDbAzureKeysFilterArgsDict']]] = None,
                                          oracle_db_azure_key_id: Optional[builtins.str] = None,
                                          oracle_db_azure_vault_id: Optional[builtins.str] = None,
                                          state: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureKeysResult:
    """
    This data source provides the list of Oracle Db Azure Keys in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Keys based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_keys = oci.oci.get_dbmulticloud_oracle_db_azure_keys(compartment_id=compartment_id,
        display_name=oracle_db_azure_key_display_name,
        oracle_db_azure_key_id=test_oracle_db_azure_key["id"],
        oracle_db_azure_vault_id=test_oracle_db_azure_vault["id"],
        state=oracle_db_azure_key_state)
    ```


    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return Azure Vault Keys.
    :param builtins.str oracle_db_azure_key_id: A filter to return Oracle DB Azure Vault Key Resources.
    :param builtins.str oracle_db_azure_vault_id: A filter to return Oracle DB Azure Vault Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureKeyId'] = oracle_db_azure_key_id
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureKeys:getDbmulticloudOracleDbAzureKeys', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureKeysResult).value

    return AwaitableGetDbmulticloudOracleDbAzureKeysResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oracle_db_azure_key_id=pulumi.get(__ret__, 'oracle_db_azure_key_id'),
        oracle_db_azure_key_summary_collections=pulumi.get(__ret__, 'oracle_db_azure_key_summary_collections'),
        oracle_db_azure_vault_id=pulumi.get(__ret__, 'oracle_db_azure_vault_id'),
        state=pulumi.get(__ret__, 'state'))
def get_dbmulticloud_oracle_db_azure_keys_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbmulticloudOracleDbAzureKeysFilterArgs', 'GetDbmulticloudOracleDbAzureKeysFilterArgsDict']]]]] = None,
                                                 oracle_db_azure_key_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 oracle_db_azure_vault_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureKeysResult]:
    """
    This data source provides the list of Oracle Db Azure Keys in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Keys based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_keys = oci.oci.get_dbmulticloud_oracle_db_azure_keys(compartment_id=compartment_id,
        display_name=oracle_db_azure_key_display_name,
        oracle_db_azure_key_id=test_oracle_db_azure_key["id"],
        oracle_db_azure_vault_id=test_oracle_db_azure_vault["id"],
        state=oracle_db_azure_key_state)
    ```


    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return Azure Vault Keys.
    :param builtins.str oracle_db_azure_key_id: A filter to return Oracle DB Azure Vault Key Resources.
    :param builtins.str oracle_db_azure_vault_id: A filter to return Oracle DB Azure Vault Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureKeyId'] = oracle_db_azure_key_id
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureKeys:getDbmulticloudOracleDbAzureKeys', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureKeysResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureKeysResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oracle_db_azure_key_id=pulumi.get(__response__, 'oracle_db_azure_key_id'),
        oracle_db_azure_key_summary_collections=pulumi.get(__response__, 'oracle_db_azure_key_summary_collections'),
        oracle_db_azure_vault_id=pulumi.get(__response__, 'oracle_db_azure_vault_id'),
        state=pulumi.get(__response__, 'state')))
