# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDbmulticloudOracleDbAzureVaultResult',
    'AwaitableGetDbmulticloudOracleDbAzureVaultResult',
    'get_dbmulticloud_oracle_db_azure_vault',
    'get_dbmulticloud_oracle_db_azure_vault_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureVaultResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureVault.
    """
    def __init__(__self__, azure_vault_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, last_modification=None, lifecycle_state_details=None, location=None, oracle_db_azure_resource_group=None, oracle_db_azure_vault_id=None, oracle_db_connector_id=None, properties=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if azure_vault_id and not isinstance(azure_vault_id, str):
            raise TypeError("Expected argument 'azure_vault_id' to be a str")
        pulumi.set(__self__, "azure_vault_id", azure_vault_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modification and not isinstance(last_modification, str):
            raise TypeError("Expected argument 'last_modification' to be a str")
        pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if oracle_db_azure_resource_group and not isinstance(oracle_db_azure_resource_group, str):
            raise TypeError("Expected argument 'oracle_db_azure_resource_group' to be a str")
        pulumi.set(__self__, "oracle_db_azure_resource_group", oracle_db_azure_resource_group)
        if oracle_db_azure_vault_id and not isinstance(oracle_db_azure_vault_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_vault_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_vault_id", oracle_db_azure_vault_id)
        if oracle_db_connector_id and not isinstance(oracle_db_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_connector_id", oracle_db_connector_id)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="azureVaultId")
    def azure_vault_id(self) -> builtins.str:
        """
        Azure Vault Id.
        """
        return pulumi.get(self, "azure_vault_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The Compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that has this DB Azure Vault Resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name of DB Azure Vault.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> builtins.str:
        """
        Description of the latest modification of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "last_modification")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Vault Resource Location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="oracleDbAzureResourceGroup")
    def oracle_db_azure_resource_group(self) -> builtins.str:
        """
        Display name of Azure Resource Group.
        """
        return pulumi.get(self, "oracle_db_azure_resource_group")

    @property
    @pulumi.getter(name="oracleDbAzureVaultId")
    def oracle_db_azure_vault_id(self) -> builtins.str:
        return pulumi.get(self, "oracle_db_azure_vault_id")

    @property
    @pulumi.getter(name="oracleDbConnectorId")
    def oracle_db_connector_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        """
        return pulumi.get(self, "oracle_db_connector_id")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, builtins.str]:
        """
        Resource's properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Time when the DB Azure Vault was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Time when the DB Azure Vault was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Vault Resource Type.
        """
        return pulumi.get(self, "type")


class AwaitableGetDbmulticloudOracleDbAzureVaultResult(GetDbmulticloudOracleDbAzureVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureVaultResult(
            azure_vault_id=self.azure_vault_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            last_modification=self.last_modification,
            lifecycle_state_details=self.lifecycle_state_details,
            location=self.location,
            oracle_db_azure_resource_group=self.oracle_db_azure_resource_group,
            oracle_db_azure_vault_id=self.oracle_db_azure_vault_id,
            oracle_db_connector_id=self.oracle_db_connector_id,
            properties=self.properties,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_dbmulticloud_oracle_db_azure_vault(oracle_db_azure_vault_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureVaultResult:
    """
    This data source provides details about a specific Oracle Db Azure Vault resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Get Oracle DB Azure Vault Details form a particular Container Resource ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_vault = oci.oci.get_dbmulticloud_oracle_db_azure_vault(oracle_db_azure_vault_id=test_oracle_db_azure_vault_oci_dbmulticloud_oracle_db_azure_vault["id"])
    ```


    :param builtins.str oracle_db_azure_vault_id: The ID of the Oracle DB Azure Vault Resource.
    """
    __args__ = dict()
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureVault:getDbmulticloudOracleDbAzureVault', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureVaultResult).value

    return AwaitableGetDbmulticloudOracleDbAzureVaultResult(
        azure_vault_id=pulumi.get(__ret__, 'azure_vault_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        last_modification=pulumi.get(__ret__, 'last_modification'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        location=pulumi.get(__ret__, 'location'),
        oracle_db_azure_resource_group=pulumi.get(__ret__, 'oracle_db_azure_resource_group'),
        oracle_db_azure_vault_id=pulumi.get(__ret__, 'oracle_db_azure_vault_id'),
        oracle_db_connector_id=pulumi.get(__ret__, 'oracle_db_connector_id'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_dbmulticloud_oracle_db_azure_vault_output(oracle_db_azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureVaultResult]:
    """
    This data source provides details about a specific Oracle Db Azure Vault resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Get Oracle DB Azure Vault Details form a particular Container Resource ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_vault = oci.oci.get_dbmulticloud_oracle_db_azure_vault(oracle_db_azure_vault_id=test_oracle_db_azure_vault_oci_dbmulticloud_oracle_db_azure_vault["id"])
    ```


    :param builtins.str oracle_db_azure_vault_id: The ID of the Oracle DB Azure Vault Resource.
    """
    __args__ = dict()
    __args__['oracleDbAzureVaultId'] = oracle_db_azure_vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureVault:getDbmulticloudOracleDbAzureVault', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureVaultResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureVaultResult(
        azure_vault_id=pulumi.get(__response__, 'azure_vault_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        last_modification=pulumi.get(__response__, 'last_modification'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        location=pulumi.get(__response__, 'location'),
        oracle_db_azure_resource_group=pulumi.get(__response__, 'oracle_db_azure_resource_group'),
        oracle_db_azure_vault_id=pulumi.get(__response__, 'oracle_db_azure_vault_id'),
        oracle_db_connector_id=pulumi.get(__response__, 'oracle_db_connector_id'),
        properties=pulumi.get(__response__, 'properties'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
