# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsManagedInstancesResult',
    'AwaitableGetWlmsManagedInstancesResult',
    'get_wlms_managed_instances',
    'get_wlms_managed_instances_output',
]

@pulumi.output_type
class GetWlmsManagedInstancesResult:
    """
    A collection of values returned by getWlmsManagedInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, managed_instance_collections=None, plugin_status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_collections and not isinstance(managed_instance_collections, list):
            raise TypeError("Expected argument 'managed_instance_collections' to be a list")
        pulumi.set(__self__, "managed_instance_collections", managed_instance_collections)
        if plugin_status and not isinstance(plugin_status, str):
            raise TypeError("Expected argument 'plugin_status' to be a str")
        pulumi.set(__self__, "plugin_status", plugin_status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name that does not have to be unique and is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsManagedInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceCollections")
    def managed_instance_collections(self) -> Sequence['outputs.GetWlmsManagedInstancesManagedInstanceCollectionResult']:
        """
        The list of managed_instance_collection.
        """
        return pulumi.get(self, "managed_instance_collections")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> Optional[builtins.str]:
        """
        The plugin status of the managed instance.
        """
        return pulumi.get(self, "plugin_status")


class AwaitableGetWlmsManagedInstancesResult(GetWlmsManagedInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsManagedInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            managed_instance_collections=self.managed_instance_collections,
            plugin_status=self.plugin_status)


def get_wlms_managed_instances(compartment_id: Optional[builtins.str] = None,
                               display_name: Optional[builtins.str] = None,
                               filters: Optional[Sequence[Union['GetWlmsManagedInstancesFilterArgs', 'GetWlmsManagedInstancesFilterArgsDict']]] = None,
                               id: Optional[builtins.str] = None,
                               plugin_status: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsManagedInstancesResult:
    """
    This data source provides the list of Managed Instances in Oracle Cloud Infrastructure Wlms service.

    Lists managed instances that match the specified compartment or managed instance OCID. Filter the list against a variety of criteria including but not limited to its name, status and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instances = oci.oci.get_wlms_managed_instances(compartment_id=compartment_id,
        display_name=managed_instance_display_name,
        id=managed_instance_id,
        plugin_status=managed_instance_plugin_status)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns  only resources contained within the specified compartment.
    :param builtins.str display_name: The display name.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str plugin_status: The plugin status of the managed instance.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['pluginStatus'] = plugin_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsManagedInstances:getWlmsManagedInstances', __args__, opts=opts, typ=GetWlmsManagedInstancesResult).value

    return AwaitableGetWlmsManagedInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_collections=pulumi.get(__ret__, 'managed_instance_collections'),
        plugin_status=pulumi.get(__ret__, 'plugin_status'))
def get_wlms_managed_instances_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsManagedInstancesFilterArgs', 'GetWlmsManagedInstancesFilterArgsDict']]]]] = None,
                                      id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      plugin_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsManagedInstancesResult]:
    """
    This data source provides the list of Managed Instances in Oracle Cloud Infrastructure Wlms service.

    Lists managed instances that match the specified compartment or managed instance OCID. Filter the list against a variety of criteria including but not limited to its name, status and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instances = oci.oci.get_wlms_managed_instances(compartment_id=compartment_id,
        display_name=managed_instance_display_name,
        id=managed_instance_id,
        plugin_status=managed_instance_plugin_status)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns  only resources contained within the specified compartment.
    :param builtins.str display_name: The display name.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str plugin_status: The plugin status of the managed instance.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['pluginStatus'] = plugin_status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsManagedInstances:getWlmsManagedInstances', __args__, opts=opts, typ=GetWlmsManagedInstancesResult)
    return __ret__.apply(lambda __response__: GetWlmsManagedInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_collections=pulumi.get(__response__, 'managed_instance_collections'),
        plugin_status=pulumi.get(__response__, 'plugin_status')))
