# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWlmsWlsDomainResult',
    'AwaitableGetWlmsWlsDomainResult',
    'get_wlms_wls_domain',
    'get_wlms_wls_domain_output',
]

@pulumi.output_type
class GetWlmsWlsDomainResult:
    """
    A collection of values returned by getWlmsWlsDomain.
    """
    def __init__(__self__, compartment_id=None, configurations=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_accepted_terms_and_conditions=None, lifecycle_details=None, middleware_type=None, patch_readiness_status=None, state=None, system_tags=None, time_created=None, time_updated=None, weblogic_version=None, wls_domain_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_accepted_terms_and_conditions and not isinstance(is_accepted_terms_and_conditions, bool):
            raise TypeError("Expected argument 'is_accepted_terms_and_conditions' to be a bool")
        pulumi.set(__self__, "is_accepted_terms_and_conditions", is_accepted_terms_and_conditions)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if middleware_type and not isinstance(middleware_type, str):
            raise TypeError("Expected argument 'middleware_type' to be a str")
        pulumi.set(__self__, "middleware_type", middleware_type)
        if patch_readiness_status and not isinstance(patch_readiness_status, str):
            raise TypeError("Expected argument 'patch_readiness_status' to be a str")
        pulumi.set(__self__, "patch_readiness_status", patch_readiness_status)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if weblogic_version and not isinstance(weblogic_version, str):
            raise TypeError("Expected argument 'weblogic_version' to be a str")
        pulumi.set(__self__, "weblogic_version", weblogic_version)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetWlmsWlsDomainConfigurationResult']:
        """
        The WebLogic domain configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name that does not have to be unique and is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAcceptedTermsAndConditions")
    def is_accepted_terms_and_conditions(self) -> builtins.bool:
        """
        Whether or not the terms of use agreement has been accepted for the WebLogic domain.
        """
        return pulumi.get(self, "is_accepted_terms_and_conditions")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message that describes the current state of the WebLogic domain in more detail. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="middlewareType")
    def middleware_type(self) -> builtins.str:
        """
        The middleware type on the administration server of the WebLogic domain.
        """
        return pulumi.get(self, "middleware_type")

    @property
    @pulumi.getter(name="patchReadinessStatus")
    def patch_readiness_status(self) -> builtins.str:
        """
        The patch readiness status of the WebLogic domain.
        """
        return pulumi.get(self, "patch_readiness_status")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the WebLogic service domain.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the WebLogic domain was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the WebLogic domain was updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="weblogicVersion")
    def weblogic_version(self) -> builtins.str:
        """
        The version of the WebLogic domain.
        """
        return pulumi.get(self, "weblogic_version")

    @property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> builtins.str:
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsWlsDomainResult(GetWlmsWlsDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainResult(
            compartment_id=self.compartment_id,
            configurations=self.configurations,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_accepted_terms_and_conditions=self.is_accepted_terms_and_conditions,
            lifecycle_details=self.lifecycle_details,
            middleware_type=self.middleware_type,
            patch_readiness_status=self.patch_readiness_status,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            weblogic_version=self.weblogic_version,
            wls_domain_id=self.wls_domain_id)


def get_wlms_wls_domain(wls_domain_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainResult:
    """
    This data source provides details about a specific Wls Domain resource in Oracle Cloud Infrastructure Wlms service.

    Gets a specific WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain = oci.oci.get_wlms_wls_domain(wls_domain_id=test_wls_domain_oci_wlms_wls_domain["id"])
    ```


    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomain:getWlmsWlsDomain', __args__, opts=opts, typ=GetWlmsWlsDomainResult).value

    return AwaitableGetWlmsWlsDomainResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_accepted_terms_and_conditions=pulumi.get(__ret__, 'is_accepted_terms_and_conditions'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        middleware_type=pulumi.get(__ret__, 'middleware_type'),
        patch_readiness_status=pulumi.get(__ret__, 'patch_readiness_status'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        weblogic_version=pulumi.get(__ret__, 'weblogic_version'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_wls_domain_output(wls_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainResult]:
    """
    This data source provides details about a specific Wls Domain resource in Oracle Cloud Infrastructure Wlms service.

    Gets a specific WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain = oci.oci.get_wlms_wls_domain(wls_domain_id=test_wls_domain_oci_wlms_wls_domain["id"])
    ```


    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomain:getWlmsWlsDomain', __args__, opts=opts, typ=GetWlmsWlsDomainResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configurations=pulumi.get(__response__, 'configurations'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_accepted_terms_and_conditions=pulumi.get(__response__, 'is_accepted_terms_and_conditions'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        middleware_type=pulumi.get(__response__, 'middleware_type'),
        patch_readiness_status=pulumi.get(__response__, 'patch_readiness_status'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        weblogic_version=pulumi.get(__response__, 'weblogic_version'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
