# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWlmsWlsDomainServerResult',
    'AwaitableGetWlmsWlsDomainServerResult',
    'get_wlms_wls_domain_server',
    'get_wlms_wls_domain_server_output',
]

@pulumi.output_type
class GetWlmsWlsDomainServerResult:
    """
    A collection of values returned by getWlmsWlsDomainServer.
    """
    def __init__(__self__, host_name=None, id=None, is_admin=None, jdk_path=None, jdk_version=None, latest_patches_status=None, managed_instance_id=None, middleware_path=None, middleware_type=None, name=None, patch_readiness_status=None, restart_order=None, server_id=None, status=None, time_created=None, time_updated=None, weblogic_version=None, wls_domain_id=None, wls_domain_name=None, wls_domain_path=None):
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_admin and not isinstance(is_admin, bool):
            raise TypeError("Expected argument 'is_admin' to be a bool")
        pulumi.set(__self__, "is_admin", is_admin)
        if jdk_path and not isinstance(jdk_path, str):
            raise TypeError("Expected argument 'jdk_path' to be a str")
        pulumi.set(__self__, "jdk_path", jdk_path)
        if jdk_version and not isinstance(jdk_version, str):
            raise TypeError("Expected argument 'jdk_version' to be a str")
        pulumi.set(__self__, "jdk_version", jdk_version)
        if latest_patches_status and not isinstance(latest_patches_status, str):
            raise TypeError("Expected argument 'latest_patches_status' to be a str")
        pulumi.set(__self__, "latest_patches_status", latest_patches_status)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if middleware_path and not isinstance(middleware_path, str):
            raise TypeError("Expected argument 'middleware_path' to be a str")
        pulumi.set(__self__, "middleware_path", middleware_path)
        if middleware_type and not isinstance(middleware_type, str):
            raise TypeError("Expected argument 'middleware_type' to be a str")
        pulumi.set(__self__, "middleware_type", middleware_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if patch_readiness_status and not isinstance(patch_readiness_status, str):
            raise TypeError("Expected argument 'patch_readiness_status' to be a str")
        pulumi.set(__self__, "patch_readiness_status", patch_readiness_status)
        if restart_order and not isinstance(restart_order, int):
            raise TypeError("Expected argument 'restart_order' to be a int")
        pulumi.set(__self__, "restart_order", restart_order)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if weblogic_version and not isinstance(weblogic_version, str):
            raise TypeError("Expected argument 'weblogic_version' to be a str")
        pulumi.set(__self__, "weblogic_version", weblogic_version)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)
        if wls_domain_name and not isinstance(wls_domain_name, str):
            raise TypeError("Expected argument 'wls_domain_name' to be a str")
        pulumi.set(__self__, "wls_domain_name", wls_domain_name)
        if wls_domain_path and not isinstance(wls_domain_path, str):
            raise TypeError("Expected argument 'wls_domain_path' to be a str")
        pulumi.set(__self__, "wls_domain_path", wls_domain_path)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The name of the server.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> builtins.bool:
        """
        Whether or not the server is an admin node.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter(name="jdkPath")
    def jdk_path(self) -> builtins.str:
        """
        The JDK path on the server.
        """
        return pulumi.get(self, "jdk_path")

    @property
    @pulumi.getter(name="jdkVersion")
    def jdk_version(self) -> builtins.str:
        """
        The JDK version on the server.
        """
        return pulumi.get(self, "jdk_version")

    @property
    @pulumi.getter(name="latestPatchesStatus")
    def latest_patches_status(self) -> builtins.str:
        """
        Whether or not the server has installed the latest patches.
        """
        return pulumi.get(self, "latest_patches_status")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> builtins.str:
        """
        The managed instance ID of the server.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="middlewarePath")
    def middleware_path(self) -> builtins.str:
        """
        The middleware path on the server.
        """
        return pulumi.get(self, "middleware_path")

    @property
    @pulumi.getter(name="middlewareType")
    def middleware_type(self) -> builtins.str:
        """
        The middleware type on the server.
        """
        return pulumi.get(self, "middleware_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patchReadinessStatus")
    def patch_readiness_status(self) -> builtins.str:
        """
        The patch readiness status of the server.
        """
        return pulumi.get(self, "patch_readiness_status")

    @property
    @pulumi.getter(name="restartOrder")
    def restart_order(self) -> builtins.int:
        """
        The restart order assigned to the server.
        """
        return pulumi.get(self, "restart_order")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> builtins.str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the server was first reported (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the server was last reported (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="weblogicVersion")
    def weblogic_version(self) -> builtins.str:
        """
        The version of the WebLogic domain of the server
        """
        return pulumi.get(self, "weblogic_version")

    @property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> builtins.str:
        """
        The ID of the WebLogic domain to which the server belongs.
        """
        return pulumi.get(self, "wls_domain_id")

    @property
    @pulumi.getter(name="wlsDomainName")
    def wls_domain_name(self) -> builtins.str:
        """
        The name of the WebLogic domain to which the server belongs.
        """
        return pulumi.get(self, "wls_domain_name")

    @property
    @pulumi.getter(name="wlsDomainPath")
    def wls_domain_path(self) -> builtins.str:
        """
        The path of the WebLogic domain to which the server belongs.
        """
        return pulumi.get(self, "wls_domain_path")


class AwaitableGetWlmsWlsDomainServerResult(GetWlmsWlsDomainServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainServerResult(
            host_name=self.host_name,
            id=self.id,
            is_admin=self.is_admin,
            jdk_path=self.jdk_path,
            jdk_version=self.jdk_version,
            latest_patches_status=self.latest_patches_status,
            managed_instance_id=self.managed_instance_id,
            middleware_path=self.middleware_path,
            middleware_type=self.middleware_type,
            name=self.name,
            patch_readiness_status=self.patch_readiness_status,
            restart_order=self.restart_order,
            server_id=self.server_id,
            status=self.status,
            time_created=self.time_created,
            time_updated=self.time_updated,
            weblogic_version=self.weblogic_version,
            wls_domain_id=self.wls_domain_id,
            wls_domain_name=self.wls_domain_name,
            wls_domain_path=self.wls_domain_path)


def get_wlms_wls_domain_server(server_id: Optional[builtins.str] = None,
                               wls_domain_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainServerResult:
    """
    This data source provides details about a specific Wls Domain Server resource in Oracle Cloud Infrastructure Wlms service.

    Gets information about the specified server in a WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server = oci.oci.get_wlms_wls_domain_server(server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomainServer:getWlmsWlsDomainServer', __args__, opts=opts, typ=GetWlmsWlsDomainServerResult).value

    return AwaitableGetWlmsWlsDomainServerResult(
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        is_admin=pulumi.get(__ret__, 'is_admin'),
        jdk_path=pulumi.get(__ret__, 'jdk_path'),
        jdk_version=pulumi.get(__ret__, 'jdk_version'),
        latest_patches_status=pulumi.get(__ret__, 'latest_patches_status'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        middleware_path=pulumi.get(__ret__, 'middleware_path'),
        middleware_type=pulumi.get(__ret__, 'middleware_type'),
        name=pulumi.get(__ret__, 'name'),
        patch_readiness_status=pulumi.get(__ret__, 'patch_readiness_status'),
        restart_order=pulumi.get(__ret__, 'restart_order'),
        server_id=pulumi.get(__ret__, 'server_id'),
        status=pulumi.get(__ret__, 'status'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        weblogic_version=pulumi.get(__ret__, 'weblogic_version'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'),
        wls_domain_name=pulumi.get(__ret__, 'wls_domain_name'),
        wls_domain_path=pulumi.get(__ret__, 'wls_domain_path'))
def get_wlms_wls_domain_server_output(server_id: Optional[pulumi.Input[builtins.str]] = None,
                                      wls_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainServerResult]:
    """
    This data source provides details about a specific Wls Domain Server resource in Oracle Cloud Infrastructure Wlms service.

    Gets information about the specified server in a WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server = oci.oci.get_wlms_wls_domain_server(server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomainServer:getWlmsWlsDomainServer', __args__, opts=opts, typ=GetWlmsWlsDomainServerResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainServerResult(
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        is_admin=pulumi.get(__response__, 'is_admin'),
        jdk_path=pulumi.get(__response__, 'jdk_path'),
        jdk_version=pulumi.get(__response__, 'jdk_version'),
        latest_patches_status=pulumi.get(__response__, 'latest_patches_status'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        middleware_path=pulumi.get(__response__, 'middleware_path'),
        middleware_type=pulumi.get(__response__, 'middleware_type'),
        name=pulumi.get(__response__, 'name'),
        patch_readiness_status=pulumi.get(__response__, 'patch_readiness_status'),
        restart_order=pulumi.get(__response__, 'restart_order'),
        server_id=pulumi.get(__response__, 'server_id'),
        status=pulumi.get(__response__, 'status'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        weblogic_version=pulumi.get(__response__, 'weblogic_version'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id'),
        wls_domain_name=pulumi.get(__response__, 'wls_domain_name'),
        wls_domain_path=pulumi.get(__response__, 'wls_domain_path')))
