# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWlmsWlsDomainServerBackupResult',
    'AwaitableGetWlmsWlsDomainServerBackupResult',
    'get_wlms_wls_domain_server_backup',
    'get_wlms_wls_domain_server_backup_output',
]

@pulumi.output_type
class GetWlmsWlsDomainServerBackupResult:
    """
    A collection of values returned by getWlmsWlsDomainServerBackup.
    """
    def __init__(__self__, backup_id=None, backup_location=None, content_type=None, id=None, managed_instance_id=None, server_id=None, time_created=None, type=None, wls_domain_id=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if backup_location and not isinstance(backup_location, str):
            raise TypeError("Expected argument 'backup_location' to be a str")
        pulumi.set(__self__, "backup_location", backup_location)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="backupLocation")
    def backup_location(self) -> builtins.str:
        """
        The location of the backup. For backups of type LOCAL_FILE this is the absolute path of the backup file.
        """
        return pulumi.get(self, "backup_location")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        The type of content of the backup.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> builtins.str:
        """
        The managed instance ID of the server for which the backup was created.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> builtins.str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time when the backup was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the backup.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> builtins.str:
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsWlsDomainServerBackupResult(GetWlmsWlsDomainServerBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainServerBackupResult(
            backup_id=self.backup_id,
            backup_location=self.backup_location,
            content_type=self.content_type,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            server_id=self.server_id,
            time_created=self.time_created,
            type=self.type,
            wls_domain_id=self.wls_domain_id)


def get_wlms_wls_domain_server_backup(backup_id: Optional[builtins.str] = None,
                                      server_id: Optional[builtins.str] = None,
                                      wls_domain_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainServerBackupResult:
    """
    This data source provides details about a specific Wls Domain Server Backup resource in Oracle Cloud Infrastructure Wlms service.

    Get details of specific backup for the WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backup = oci.oci.get_wlms_wls_domain_server_backup(backup_id=test_backup["id"],
        server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str backup_id: The unique identifier of the backup.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomainServerBackup:getWlmsWlsDomainServerBackup', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupResult).value

    return AwaitableGetWlmsWlsDomainServerBackupResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        backup_location=pulumi.get(__ret__, 'backup_location'),
        content_type=pulumi.get(__ret__, 'content_type'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        type=pulumi.get(__ret__, 'type'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_wls_domain_server_backup_output(backup_id: Optional[pulumi.Input[builtins.str]] = None,
                                             server_id: Optional[pulumi.Input[builtins.str]] = None,
                                             wls_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainServerBackupResult]:
    """
    This data source provides details about a specific Wls Domain Server Backup resource in Oracle Cloud Infrastructure Wlms service.

    Get details of specific backup for the WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backup = oci.oci.get_wlms_wls_domain_server_backup(backup_id=test_backup["id"],
        server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str backup_id: The unique identifier of the backup.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomainServerBackup:getWlmsWlsDomainServerBackup', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainServerBackupResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        backup_location=pulumi.get(__response__, 'backup_location'),
        content_type=pulumi.get(__response__, 'content_type'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        type=pulumi.get(__response__, 'type'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
