# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOdaInstancesResult',
    'AwaitableGetOdaInstancesResult',
    'get_oda_instances',
    'get_oda_instances_output',
]

@pulumi.output_type
class GetOdaInstancesResult:
    """
    A collection of values returned by getOdaInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oda_instances=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oda_instances and not isinstance(oda_instances, list):
            raise TypeError("Expected argument 'oda_instances' to be a list")
        pulumi.set(__self__, "oda_instances", oda_instances)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Identifier of the compartment that the instance belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        User-defined name for the Digital Assistant instance. Avoid entering confidential information. You can change this value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOdaInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaInstances")
    def oda_instances(self) -> Sequence['outputs.GetOdaInstancesOdaInstanceResult']:
        """
        The list of oda_instances.
        """
        return pulumi.get(self, "oda_instances")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Digital Assistant instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetOdaInstancesResult(GetOdaInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOdaInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oda_instances=self.oda_instances,
            state=self.state)


def get_oda_instances(compartment_id: Optional[builtins.str] = None,
                      display_name: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetOdaInstancesFilterArgs', 'GetOdaInstancesFilterArgsDict']]] = None,
                      state: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOdaInstancesResult:
    """
    This data source provides the list of Oda Instances in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of Digital Assistant instances that belong to the specified
    compartment.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_instances = oci.Oda.get_oda_instances(compartment_id=compartment_id,
        display_name=oda_instance_display_name,
        state=oda_instance_state)
    ```


    :param builtins.str compartment_id: List the Digital Assistant instances that belong to this compartment.
    :param builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
    :param builtins.str state: List only the Digital Assistant instances that are in this lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Oda/getOdaInstances:getOdaInstances', __args__, opts=opts, typ=GetOdaInstancesResult).value

    return AwaitableGetOdaInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oda_instances=pulumi.get(__ret__, 'oda_instances'),
        state=pulumi.get(__ret__, 'state'))
def get_oda_instances_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOdaInstancesFilterArgs', 'GetOdaInstancesFilterArgsDict']]]]] = None,
                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOdaInstancesResult]:
    """
    This data source provides the list of Oda Instances in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of Digital Assistant instances that belong to the specified
    compartment.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_instances = oci.Oda.get_oda_instances(compartment_id=compartment_id,
        display_name=oda_instance_display_name,
        state=oda_instance_state)
    ```


    :param builtins.str compartment_id: List the Digital Assistant instances that belong to this compartment.
    :param builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
    :param builtins.str state: List only the Digital Assistant instances that are in this lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Oda/getOdaInstances:getOdaInstances', __args__, opts=opts, typ=GetOdaInstancesResult)
    return __ret__.apply(lambda __response__: GetOdaInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oda_instances=pulumi.get(__response__, 'oda_instances'),
        state=pulumi.get(__response__, 'state')))
