# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBillingSchedulesResult',
    'AwaitableGetBillingSchedulesResult',
    'get_billing_schedules',
    'get_billing_schedules_output',
]

@pulumi.output_type
class GetBillingSchedulesResult:
    """
    A collection of values returned by getBillingSchedules.
    """
    def __init__(__self__, billing_schedules=None, compartment_id=None, filters=None, id=None, subscribed_service_id=None, subscription_id=None):
        if billing_schedules and not isinstance(billing_schedules, list):
            raise TypeError("Expected argument 'billing_schedules' to be a list")
        pulumi.set(__self__, "billing_schedules", billing_schedules)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscribed_service_id and not isinstance(subscribed_service_id, str):
            raise TypeError("Expected argument 'subscribed_service_id' to be a str")
        pulumi.set(__self__, "subscribed_service_id", subscribed_service_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="billingSchedules")
    def billing_schedules(self) -> Sequence['outputs.GetBillingSchedulesBillingScheduleResult']:
        """
        The list of billing_schedules.
        """
        return pulumi.get(self, "billing_schedules")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBillingSchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subscribedServiceId")
    def subscribed_service_id(self) -> Optional[builtins.str]:
        """
        SPM internal Subscribed Service ID
        """
        return pulumi.get(self, "subscribed_service_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return pulumi.get(self, "subscription_id")


class AwaitableGetBillingSchedulesResult(GetBillingSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBillingSchedulesResult(
            billing_schedules=self.billing_schedules,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            subscribed_service_id=self.subscribed_service_id,
            subscription_id=self.subscription_id)


def get_billing_schedules(compartment_id: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetBillingSchedulesFilterArgs', 'GetBillingSchedulesFilterArgsDict']]] = None,
                          subscribed_service_id: Optional[builtins.str] = None,
                          subscription_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBillingSchedulesResult:
    """
    This data source provides the list of Billing Schedules in Oracle Cloud Infrastructure Onesubscription service.

    This list API returns all billing schedules for given subscription id and
    for a particular Subscribed Service if provided

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_billing_schedules = oci.OneSubsription.get_billing_schedules(compartment_id=compartment_id,
        subscription_id=test_subscription["id"],
        subscribed_service_id=test_subscribed_service["id"])
    ```


    :param builtins.str compartment_id: The OCID of the root compartment.
    :param builtins.str subscribed_service_id: This param is used to get only the billing schedules for a particular Subscribed Service
    :param builtins.str subscription_id: This param is used to get only the billing schedules for a particular Subscription Id
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscribedServiceId'] = subscribed_service_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OneSubsription/getBillingSchedules:getBillingSchedules', __args__, opts=opts, typ=GetBillingSchedulesResult).value

    return AwaitableGetBillingSchedulesResult(
        billing_schedules=pulumi.get(__ret__, 'billing_schedules'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        subscribed_service_id=pulumi.get(__ret__, 'subscribed_service_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_billing_schedules_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBillingSchedulesFilterArgs', 'GetBillingSchedulesFilterArgsDict']]]]] = None,
                                 subscribed_service_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBillingSchedulesResult]:
    """
    This data source provides the list of Billing Schedules in Oracle Cloud Infrastructure Onesubscription service.

    This list API returns all billing schedules for given subscription id and
    for a particular Subscribed Service if provided

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_billing_schedules = oci.OneSubsription.get_billing_schedules(compartment_id=compartment_id,
        subscription_id=test_subscription["id"],
        subscribed_service_id=test_subscribed_service["id"])
    ```


    :param builtins.str compartment_id: The OCID of the root compartment.
    :param builtins.str subscribed_service_id: This param is used to get only the billing schedules for a particular Subscribed Service
    :param builtins.str subscription_id: This param is used to get only the billing schedules for a particular Subscription Id
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscribedServiceId'] = subscribed_service_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OneSubsription/getBillingSchedules:getBillingSchedules', __args__, opts=opts, typ=GetBillingSchedulesResult)
    return __ret__.apply(lambda __response__: GetBillingSchedulesResult(
        billing_schedules=pulumi.get(__response__, 'billing_schedules'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        subscribed_service_id=pulumi.get(__response__, 'subscribed_service_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
