# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpensearchClusterPipelineResult',
    'AwaitableGetOpensearchClusterPipelineResult',
    'get_opensearch_cluster_pipeline',
    'get_opensearch_cluster_pipeline_output',
]

@pulumi.output_type
class GetOpensearchClusterPipelineResult:
    """
    A collection of values returned by getOpensearchClusterPipeline.
    """
    def __init__(__self__, compartment_id=None, data_prepper_configuration_body=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, memory_gb=None, node_count=None, node_shape=None, nsg_id=None, ocpu_count=None, opc_dry_run=None, opensearch_cluster_pipeline_id=None, opensearch_pipeline_fqdn=None, opensearch_pipeline_private_ip=None, pipeline_configuration_body=None, pipeline_mode=None, reverse_connection_endpoints=None, state=None, subnet_compartment_id=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None, vcn_compartment_id=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_prepper_configuration_body and not isinstance(data_prepper_configuration_body, str):
            raise TypeError("Expected argument 'data_prepper_configuration_body' to be a str")
        pulumi.set(__self__, "data_prepper_configuration_body", data_prepper_configuration_body)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory_gb and not isinstance(memory_gb, int):
            raise TypeError("Expected argument 'memory_gb' to be a int")
        pulumi.set(__self__, "memory_gb", memory_gb)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if node_shape and not isinstance(node_shape, str):
            raise TypeError("Expected argument 'node_shape' to be a str")
        pulumi.set(__self__, "node_shape", node_shape)
        if nsg_id and not isinstance(nsg_id, str):
            raise TypeError("Expected argument 'nsg_id' to be a str")
        pulumi.set(__self__, "nsg_id", nsg_id)
        if ocpu_count and not isinstance(ocpu_count, int):
            raise TypeError("Expected argument 'ocpu_count' to be a int")
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        if opc_dry_run and not isinstance(opc_dry_run, bool):
            raise TypeError("Expected argument 'opc_dry_run' to be a bool")
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if opensearch_cluster_pipeline_id and not isinstance(opensearch_cluster_pipeline_id, str):
            raise TypeError("Expected argument 'opensearch_cluster_pipeline_id' to be a str")
        pulumi.set(__self__, "opensearch_cluster_pipeline_id", opensearch_cluster_pipeline_id)
        if opensearch_pipeline_fqdn and not isinstance(opensearch_pipeline_fqdn, str):
            raise TypeError("Expected argument 'opensearch_pipeline_fqdn' to be a str")
        pulumi.set(__self__, "opensearch_pipeline_fqdn", opensearch_pipeline_fqdn)
        if opensearch_pipeline_private_ip and not isinstance(opensearch_pipeline_private_ip, str):
            raise TypeError("Expected argument 'opensearch_pipeline_private_ip' to be a str")
        pulumi.set(__self__, "opensearch_pipeline_private_ip", opensearch_pipeline_private_ip)
        if pipeline_configuration_body and not isinstance(pipeline_configuration_body, str):
            raise TypeError("Expected argument 'pipeline_configuration_body' to be a str")
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if pipeline_mode and not isinstance(pipeline_mode, str):
            raise TypeError("Expected argument 'pipeline_mode' to be a str")
        pulumi.set(__self__, "pipeline_mode", pipeline_mode)
        if reverse_connection_endpoints and not isinstance(reverse_connection_endpoints, list):
            raise TypeError("Expected argument 'reverse_connection_endpoints' to be a list")
        pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_compartment_id and not isinstance(subnet_compartment_id, str):
            raise TypeError("Expected argument 'subnet_compartment_id' to be a str")
        pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vcn_compartment_id and not isinstance(vcn_compartment_id, str):
            raise TypeError("Expected argument 'vcn_compartment_id' to be a str")
        pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment where the pipeline is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataPrepperConfigurationBody")
    def data_prepper_configuration_body(self) -> builtins.str:
        """
        The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "data_prepper_configuration_body")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name of the pipeline. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the cluster pipeline.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> builtins.int:
        """
        The amount of memory in GB, for each pipeline node.
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes configured for the pipeline.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> builtins.str:
        """
        The pipeline node shape.
        """
        return pulumi.get(self, "node_shape")

    @property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> builtins.str:
        """
        The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> builtins.int:
        """
        The number of OCPUs configured for each pipeline node.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> builtins.bool:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="opensearchClusterPipelineId")
    def opensearch_cluster_pipeline_id(self) -> builtins.str:
        return pulumi.get(self, "opensearch_cluster_pipeline_id")

    @property
    @pulumi.getter(name="opensearchPipelineFqdn")
    def opensearch_pipeline_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_pipeline_fqdn")

    @property
    @pulumi.getter(name="opensearchPipelinePrivateIp")
    def opensearch_pipeline_private_ip(self) -> builtins.str:
        """
        The pipeline's private IP address.
        """
        return pulumi.get(self, "opensearch_pipeline_private_ip")

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> builtins.str:
        """
        The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @property
    @pulumi.getter(name="pipelineMode")
    def pipeline_mode(self) -> builtins.str:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "pipeline_mode")

    @property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Sequence['outputs.GetOpensearchClusterPipelineReverseConnectionEndpointResult']:
        """
        The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the cluster backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> builtins.str:
        """
        The OCID for the compartment where the pipeline's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of the pipeline's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The amount of time in milliseconds since the pipeline was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> builtins.str:
        """
        The OCID for the compartment where the pipeline's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The OCID of the pipeline's VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetOpensearchClusterPipelineResult(GetOpensearchClusterPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchClusterPipelineResult(
            compartment_id=self.compartment_id,
            data_prepper_configuration_body=self.data_prepper_configuration_body,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            memory_gb=self.memory_gb,
            node_count=self.node_count,
            node_shape=self.node_shape,
            nsg_id=self.nsg_id,
            ocpu_count=self.ocpu_count,
            opc_dry_run=self.opc_dry_run,
            opensearch_cluster_pipeline_id=self.opensearch_cluster_pipeline_id,
            opensearch_pipeline_fqdn=self.opensearch_pipeline_fqdn,
            opensearch_pipeline_private_ip=self.opensearch_pipeline_private_ip,
            pipeline_configuration_body=self.pipeline_configuration_body,
            pipeline_mode=self.pipeline_mode,
            reverse_connection_endpoints=self.reverse_connection_endpoints,
            state=self.state,
            subnet_compartment_id=self.subnet_compartment_id,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vcn_compartment_id=self.vcn_compartment_id,
            vcn_id=self.vcn_id)


def get_opensearch_cluster_pipeline(opensearch_cluster_pipeline_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchClusterPipelineResult:
    """
    This data source provides details about a specific Opensearch Cluster Pipeline resource in Oracle Cloud Infrastructure Opensearch service.

    Gets a OpensearchCluster Pipeline by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_cluster_pipeline = oci.Opensearch.get_opensearch_cluster_pipeline(opensearch_cluster_pipeline_id=test_opensearch_cluster_pipeline_oci_opensearch_opensearch_cluster_pipeline["id"])
    ```


    :param builtins.str opensearch_cluster_pipeline_id: unique OpensearchClusterPipeline identifier
    """
    __args__ = dict()
    __args__['opensearchClusterPipelineId'] = opensearch_cluster_pipeline_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opensearch/getOpensearchClusterPipeline:getOpensearchClusterPipeline', __args__, opts=opts, typ=GetOpensearchClusterPipelineResult).value

    return AwaitableGetOpensearchClusterPipelineResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_prepper_configuration_body=pulumi.get(__ret__, 'data_prepper_configuration_body'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        memory_gb=pulumi.get(__ret__, 'memory_gb'),
        node_count=pulumi.get(__ret__, 'node_count'),
        node_shape=pulumi.get(__ret__, 'node_shape'),
        nsg_id=pulumi.get(__ret__, 'nsg_id'),
        ocpu_count=pulumi.get(__ret__, 'ocpu_count'),
        opc_dry_run=pulumi.get(__ret__, 'opc_dry_run'),
        opensearch_cluster_pipeline_id=pulumi.get(__ret__, 'opensearch_cluster_pipeline_id'),
        opensearch_pipeline_fqdn=pulumi.get(__ret__, 'opensearch_pipeline_fqdn'),
        opensearch_pipeline_private_ip=pulumi.get(__ret__, 'opensearch_pipeline_private_ip'),
        pipeline_configuration_body=pulumi.get(__ret__, 'pipeline_configuration_body'),
        pipeline_mode=pulumi.get(__ret__, 'pipeline_mode'),
        reverse_connection_endpoints=pulumi.get(__ret__, 'reverse_connection_endpoints'),
        state=pulumi.get(__ret__, 'state'),
        subnet_compartment_id=pulumi.get(__ret__, 'subnet_compartment_id'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vcn_compartment_id=pulumi.get(__ret__, 'vcn_compartment_id'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_opensearch_cluster_pipeline_output(opensearch_cluster_pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpensearchClusterPipelineResult]:
    """
    This data source provides details about a specific Opensearch Cluster Pipeline resource in Oracle Cloud Infrastructure Opensearch service.

    Gets a OpensearchCluster Pipeline by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_cluster_pipeline = oci.Opensearch.get_opensearch_cluster_pipeline(opensearch_cluster_pipeline_id=test_opensearch_cluster_pipeline_oci_opensearch_opensearch_cluster_pipeline["id"])
    ```


    :param builtins.str opensearch_cluster_pipeline_id: unique OpensearchClusterPipeline identifier
    """
    __args__ = dict()
    __args__['opensearchClusterPipelineId'] = opensearch_cluster_pipeline_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opensearch/getOpensearchClusterPipeline:getOpensearchClusterPipeline', __args__, opts=opts, typ=GetOpensearchClusterPipelineResult)
    return __ret__.apply(lambda __response__: GetOpensearchClusterPipelineResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_prepper_configuration_body=pulumi.get(__response__, 'data_prepper_configuration_body'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        memory_gb=pulumi.get(__response__, 'memory_gb'),
        node_count=pulumi.get(__response__, 'node_count'),
        node_shape=pulumi.get(__response__, 'node_shape'),
        nsg_id=pulumi.get(__response__, 'nsg_id'),
        ocpu_count=pulumi.get(__response__, 'ocpu_count'),
        opc_dry_run=pulumi.get(__response__, 'opc_dry_run'),
        opensearch_cluster_pipeline_id=pulumi.get(__response__, 'opensearch_cluster_pipeline_id'),
        opensearch_pipeline_fqdn=pulumi.get(__response__, 'opensearch_pipeline_fqdn'),
        opensearch_pipeline_private_ip=pulumi.get(__response__, 'opensearch_pipeline_private_ip'),
        pipeline_configuration_body=pulumi.get(__response__, 'pipeline_configuration_body'),
        pipeline_mode=pulumi.get(__response__, 'pipeline_mode'),
        reverse_connection_endpoints=pulumi.get(__response__, 'reverse_connection_endpoints'),
        state=pulumi.get(__response__, 'state'),
        subnet_compartment_id=pulumi.get(__response__, 'subnet_compartment_id'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        vcn_compartment_id=pulumi.get(__response__, 'vcn_compartment_id'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
