# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceGroupModulesResult',
    'AwaitableGetManagedInstanceGroupModulesResult',
    'get_managed_instance_group_modules',
    'get_managed_instance_group_modules_output',
]

@pulumi.output_type
class GetManagedInstanceGroupModulesResult:
    """
    A collection of values returned by getManagedInstanceGroupModules.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, managed_instance_group_id=None, managed_instance_group_module_collections=None, name=None, name_contains=None, stream_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instance_group_module_collections and not isinstance(managed_instance_group_module_collections, list):
            raise TypeError("Expected argument 'managed_instance_group_module_collections' to be a list")
        pulumi.set(__self__, "managed_instance_group_module_collections", managed_instance_group_module_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if stream_name and not isinstance(stream_name, str):
            raise TypeError("Expected argument 'stream_name' to be a str")
        pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceGroupModulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> builtins.str:
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstanceGroupModuleCollections")
    def managed_instance_group_module_collections(self) -> Sequence['outputs.GetManagedInstanceGroupModulesManagedInstanceGroupModuleCollectionResult']:
        """
        The list of managed_instance_group_module_collection.
        """
        return pulumi.get(self, "managed_instance_group_module_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the module.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "stream_name")


class AwaitableGetManagedInstanceGroupModulesResult(GetManagedInstanceGroupModulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceGroupModulesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            managed_instance_group_id=self.managed_instance_group_id,
            managed_instance_group_module_collections=self.managed_instance_group_module_collections,
            name=self.name,
            name_contains=self.name_contains,
            stream_name=self.stream_name)


def get_managed_instance_group_modules(compartment_id: Optional[builtins.str] = None,
                                       filters: Optional[Sequence[Union['GetManagedInstanceGroupModulesFilterArgs', 'GetManagedInstanceGroupModulesFilterArgsDict']]] = None,
                                       managed_instance_group_id: Optional[builtins.str] = None,
                                       name: Optional[builtins.str] = None,
                                       name_contains: Optional[builtins.str] = None,
                                       stream_name: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceGroupModulesResult:
    """
    This data source provides the list of Managed Instance Group Modules in Oracle Cloud Infrastructure Os Management Hub service.

    Retrieve a list of module streams, along with a summary of their
    status, from a managed instance group.  Filters may be applied to select
    a subset of module streams based on the filter criteria.

    The 'moduleName' attribute filters against the name of a module.
    It accepts strings of the format "<module>".  If this attribute
    is defined, only streams that belong to the specified module are
    included in the result set.  If it is not defined, the request is
    not subject to this filter.

    The "status" attribute filters against the state of a module stream.
    Valid values are "ENABLED", "DISABLED", and "ACTIVE".  If the
    attribute is set to "ENABLED", only module streams that are enabled
    are included in the result set.  If the attribute is set to "DISABLED",
    only module streams that are not enabled are included in the result
    set.  If the attribute is set to "ACTIVE", only module streams that
    are active are included in the result set.  If the attribute is not
    defined, the request is not subject to this filter.

    When sorting by the display name, the result set is sorted first
    by the module name and then by the stream name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group_modules = oci.OsManagementHub.get_managed_instance_group_modules(managed_instance_group_id=test_managed_instance_group["id"],
        compartment_id=compartment_id,
        name=managed_instance_group_module_name,
        name_contains=managed_instance_group_module_name_contains,
        stream_name=test_stream["name"])
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
    :param builtins.str name: The resource name.
    :param builtins.str name_contains: A filter to return resources that may partially match the name given.
    :param builtins.str stream_name: The name of the module stream. This parameter is required if a profile name is specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['streamName'] = stream_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceGroupModules:getManagedInstanceGroupModules', __args__, opts=opts, typ=GetManagedInstanceGroupModulesResult).value

    return AwaitableGetManagedInstanceGroupModulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'),
        managed_instance_group_module_collections=pulumi.get(__ret__, 'managed_instance_group_module_collections'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        stream_name=pulumi.get(__ret__, 'stream_name'))
def get_managed_instance_group_modules_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedInstanceGroupModulesFilterArgs', 'GetManagedInstanceGroupModulesFilterArgsDict']]]]] = None,
                                              managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              stream_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedInstanceGroupModulesResult]:
    """
    This data source provides the list of Managed Instance Group Modules in Oracle Cloud Infrastructure Os Management Hub service.

    Retrieve a list of module streams, along with a summary of their
    status, from a managed instance group.  Filters may be applied to select
    a subset of module streams based on the filter criteria.

    The 'moduleName' attribute filters against the name of a module.
    It accepts strings of the format "<module>".  If this attribute
    is defined, only streams that belong to the specified module are
    included in the result set.  If it is not defined, the request is
    not subject to this filter.

    The "status" attribute filters against the state of a module stream.
    Valid values are "ENABLED", "DISABLED", and "ACTIVE".  If the
    attribute is set to "ENABLED", only module streams that are enabled
    are included in the result set.  If the attribute is set to "DISABLED",
    only module streams that are not enabled are included in the result
    set.  If the attribute is set to "ACTIVE", only module streams that
    are active are included in the result set.  If the attribute is not
    defined, the request is not subject to this filter.

    When sorting by the display name, the result set is sorted first
    by the module name and then by the stream name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group_modules = oci.OsManagementHub.get_managed_instance_group_modules(managed_instance_group_id=test_managed_instance_group["id"],
        compartment_id=compartment_id,
        name=managed_instance_group_module_name,
        name_contains=managed_instance_group_module_name_contains,
        stream_name=test_stream["name"])
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
    :param builtins.str name: The resource name.
    :param builtins.str name_contains: A filter to return resources that may partially match the name given.
    :param builtins.str stream_name: The name of the module stream. This parameter is required if a profile name is specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['streamName'] = stream_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagedInstanceGroupModules:getManagedInstanceGroupModules', __args__, opts=opts, typ=GetManagedInstanceGroupModulesResult)
    return __ret__.apply(lambda __response__: GetManagedInstanceGroupModulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_group_id=pulumi.get(__response__, 'managed_instance_group_id'),
        managed_instance_group_module_collections=pulumi.get(__response__, 'managed_instance_group_module_collections'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        stream_name=pulumi.get(__response__, 'stream_name')))
