# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementStationArgs', 'ManagementStation']

@pulumi.input_type
class ManagementStationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 mirror: pulumi.Input['ManagementStationMirrorArgs'],
                 proxy: pulumi.Input['ManagementStationProxyArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_auto_config_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 refresh_trigger: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ManagementStation resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] hostname: (Updatable) Hostname of the management station.
        :param pulumi.Input['ManagementStationMirrorArgs'] mirror: (Updatable) Information used to create the mirror configuration for a management station.
        :param pulumi.Input['ManagementStationProxyArgs'] proxy: (Updatable) Information used to create the proxy configuration for a management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the management station. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_auto_config_enabled: (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        :param pulumi.Input[builtins.int] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "mirror", mirror)
        pulumi.set(__self__, "proxy", proxy)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_config_enabled is not None:
            pulumi.set(__self__, "is_auto_config_enabled", is_auto_config_enabled)
        if refresh_trigger is not None:
            pulumi.set(__self__, "refresh_trigger", refresh_trigger)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Hostname of the management station.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Input['ManagementStationMirrorArgs']:
        """
        (Updatable) Information used to create the mirror configuration for a management station.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: pulumi.Input['ManagementStationMirrorArgs']):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Input['ManagementStationProxyArgs']:
        """
        (Updatable) Information used to create the proxy configuration for a management station.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: pulumi.Input['ManagementStationProxyArgs']):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the management station. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoConfigEnabled")
    def is_auto_config_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        """
        return pulumi.get(self, "is_auto_config_enabled")

    @is_auto_config_enabled.setter
    def is_auto_config_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_config_enabled", value)

    @property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @refresh_trigger.setter
    def refresh_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_trigger", value)


@pulumi.input_type
class _ManagementStationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 healths: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationHealthArgs']]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 is_auto_config_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 mirror: Optional[pulumi.Input['ManagementStationMirrorArgs']] = None,
                 mirror_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 mirror_package_count: Optional[pulumi.Input[builtins.int]] = None,
                 mirror_size: Optional[pulumi.Input[builtins.str]] = None,
                 mirror_storage_available_size: Optional[pulumi.Input[builtins.str]] = None,
                 mirror_storage_size: Optional[pulumi.Input[builtins.str]] = None,
                 mirror_sync_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]] = None,
                 mirror_unique_package_count: Optional[pulumi.Input[builtins.int]] = None,
                 overall_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 overall_state: Optional[pulumi.Input[builtins.str]] = None,
                 peer_management_stations: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationPeerManagementStationArgs']]]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 proxy: Optional[pulumi.Input['ManagementStationProxyArgs']] = None,
                 refresh_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 scheduled_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 total_mirrors: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ManagementStation resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the management station. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['ManagementStationHealthArgs']]] healths: Overall health information of the management station.
        :param pulumi.Input[builtins.str] hostname: (Updatable) Hostname of the management station.
        :param pulumi.Input[builtins.bool] is_auto_config_enabled: (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        :param pulumi.Input[builtins.str] location: The location of the instance that is acting as the management station.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        :param pulumi.Input['ManagementStationMirrorArgs'] mirror: (Updatable) Information used to create the mirror configuration for a management station.
        :param pulumi.Input[builtins.int] mirror_capacity: A decimal number representing the amount of mirror capacity used by the sync.
        :param pulumi.Input[builtins.int] mirror_package_count: The total number of all packages within the mirrored software sources.
        :param pulumi.Input[builtins.str] mirror_size: The total size of all software source mirrors in bytes.
        :param pulumi.Input[builtins.str] mirror_storage_available_size: Amount of available mirror storage in bytes.
        :param pulumi.Input[builtins.str] mirror_storage_size: Total mirror storage size in bytes.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]] mirror_sync_statuses: Status summary of the mirror sync.
        :param pulumi.Input[builtins.int] mirror_unique_package_count: The total number of unique packages within the mirrored software sources on the station. Each package is counted only once, regardless of how many versions it has.
        :param pulumi.Input[builtins.int] overall_percentage: A decimal number representing the progress of the current mirror sync.
        :param pulumi.Input[builtins.str] overall_state: Current state of the mirror sync for the management station.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementStationPeerManagementStationArgs']]] peer_management_stations: A list of other management stations that are behind the same load balancer within a high availability configuration. Stations are identified as peers if they have the same hostname and compartment.
        :param pulumi.Input[builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile used for the management station.
        :param pulumi.Input['ManagementStationProxyArgs'] proxy: (Updatable) Information used to create the proxy configuration for a management station.
        :param pulumi.Input[builtins.int] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] scheduled_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job for the mirror sync.
        :param pulumi.Input[builtins.str] state: The current state of the management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.int] total_mirrors: The number of software sources that the station is mirroring.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_auto_config_enabled is not None:
            pulumi.set(__self__, "is_auto_config_enabled", is_auto_config_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_capacity is not None:
            pulumi.set(__self__, "mirror_capacity", mirror_capacity)
        if mirror_package_count is not None:
            pulumi.set(__self__, "mirror_package_count", mirror_package_count)
        if mirror_size is not None:
            pulumi.set(__self__, "mirror_size", mirror_size)
        if mirror_storage_available_size is not None:
            pulumi.set(__self__, "mirror_storage_available_size", mirror_storage_available_size)
        if mirror_storage_size is not None:
            pulumi.set(__self__, "mirror_storage_size", mirror_storage_size)
        if mirror_sync_statuses is not None:
            pulumi.set(__self__, "mirror_sync_statuses", mirror_sync_statuses)
        if mirror_unique_package_count is not None:
            pulumi.set(__self__, "mirror_unique_package_count", mirror_unique_package_count)
        if overall_percentage is not None:
            pulumi.set(__self__, "overall_percentage", overall_percentage)
        if overall_state is not None:
            pulumi.set(__self__, "overall_state", overall_state)
        if peer_management_stations is not None:
            pulumi.set(__self__, "peer_management_stations", peer_management_stations)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if refresh_trigger is not None:
            pulumi.set(__self__, "refresh_trigger", refresh_trigger)
        if scheduled_job_id is not None:
            pulumi.set(__self__, "scheduled_job_id", scheduled_job_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if total_mirrors is not None:
            pulumi.set(__self__, "total_mirrors", total_mirrors)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the management station. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def healths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationHealthArgs']]]]:
        """
        Overall health information of the management station.
        """
        return pulumi.get(self, "healths")

    @healths.setter
    def healths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationHealthArgs']]]]):
        pulumi.set(self, "healths", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Hostname of the management station.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="isAutoConfigEnabled")
    def is_auto_config_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        """
        return pulumi.get(self, "is_auto_config_enabled")

    @is_auto_config_enabled.setter
    def is_auto_config_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_auto_config_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the instance that is acting as the management station.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input['ManagementStationMirrorArgs']]:
        """
        (Updatable) Information used to create the mirror configuration for a management station.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input['ManagementStationMirrorArgs']]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorCapacity")
    def mirror_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A decimal number representing the amount of mirror capacity used by the sync.
        """
        return pulumi.get(self, "mirror_capacity")

    @mirror_capacity.setter
    def mirror_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mirror_capacity", value)

    @property
    @pulumi.getter(name="mirrorPackageCount")
    def mirror_package_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total number of all packages within the mirrored software sources.
        """
        return pulumi.get(self, "mirror_package_count")

    @mirror_package_count.setter
    def mirror_package_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mirror_package_count", value)

    @property
    @pulumi.getter(name="mirrorSize")
    def mirror_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The total size of all software source mirrors in bytes.
        """
        return pulumi.get(self, "mirror_size")

    @mirror_size.setter
    def mirror_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mirror_size", value)

    @property
    @pulumi.getter(name="mirrorStorageAvailableSize")
    def mirror_storage_available_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amount of available mirror storage in bytes.
        """
        return pulumi.get(self, "mirror_storage_available_size")

    @mirror_storage_available_size.setter
    def mirror_storage_available_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mirror_storage_available_size", value)

    @property
    @pulumi.getter(name="mirrorStorageSize")
    def mirror_storage_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Total mirror storage size in bytes.
        """
        return pulumi.get(self, "mirror_storage_size")

    @mirror_storage_size.setter
    def mirror_storage_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mirror_storage_size", value)

    @property
    @pulumi.getter(name="mirrorSyncStatuses")
    def mirror_sync_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]]:
        """
        Status summary of the mirror sync.
        """
        return pulumi.get(self, "mirror_sync_statuses")

    @mirror_sync_statuses.setter
    def mirror_sync_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]]):
        pulumi.set(self, "mirror_sync_statuses", value)

    @property
    @pulumi.getter(name="mirrorUniquePackageCount")
    def mirror_unique_package_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total number of unique packages within the mirrored software sources on the station. Each package is counted only once, regardless of how many versions it has.
        """
        return pulumi.get(self, "mirror_unique_package_count")

    @mirror_unique_package_count.setter
    def mirror_unique_package_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mirror_unique_package_count", value)

    @property
    @pulumi.getter(name="overallPercentage")
    def overall_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A decimal number representing the progress of the current mirror sync.
        """
        return pulumi.get(self, "overall_percentage")

    @overall_percentage.setter
    def overall_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "overall_percentage", value)

    @property
    @pulumi.getter(name="overallState")
    def overall_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current state of the mirror sync for the management station.
        """
        return pulumi.get(self, "overall_state")

    @overall_state.setter
    def overall_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "overall_state", value)

    @property
    @pulumi.getter(name="peerManagementStations")
    def peer_management_stations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationPeerManagementStationArgs']]]]:
        """
        A list of other management stations that are behind the same load balancer within a high availability configuration. Stations are identified as peers if they have the same hostname and compartment.
        """
        return pulumi.get(self, "peer_management_stations")

    @peer_management_stations.setter
    def peer_management_stations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationPeerManagementStationArgs']]]]):
        pulumi.set(self, "peer_management_stations", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile used for the management station.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['ManagementStationProxyArgs']]:
        """
        (Updatable) Information used to create the proxy configuration for a management station.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['ManagementStationProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @refresh_trigger.setter
    def refresh_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_trigger", value)

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job for the mirror sync.
        """
        return pulumi.get(self, "scheduled_job_id")

    @scheduled_job_id.setter
    def scheduled_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduled_job_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the management station.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="totalMirrors")
    def total_mirrors(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of software sources that the station is mirroring.
        """
        return pulumi.get(self, "total_mirrors")

    @total_mirrors.setter
    def total_mirrors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_mirrors", value)


@pulumi.type_token("oci:OsManagementHub/managementStation:ManagementStation")
class ManagementStation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 is_auto_config_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[Union['ManagementStationMirrorArgs', 'ManagementStationMirrorArgsDict']]] = None,
                 proxy: Optional[pulumi.Input[Union['ManagementStationProxyArgs', 'ManagementStationProxyArgsDict']]] = None,
                 refresh_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a management station using the proxy and mirror configuration information provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station = oci.os_management_hub.ManagementStation("test_management_station",
            compartment_id=compartment_id,
            display_name=management_station_display_name,
            hostname=management_station_hostname,
            mirror={
                "directory": management_station_mirror_directory,
                "port": management_station_mirror_port,
                "sslport": management_station_mirror_sslport,
                "is_sslverify_enabled": management_station_mirror_is_sslverify_enabled,
                "sslcert": management_station_mirror_sslcert,
            },
            proxy={
                "is_enabled": management_station_proxy_is_enabled,
                "forward": management_station_proxy_forward,
                "hosts": management_station_proxy_hosts,
                "port": management_station_proxy_port,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=management_station_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_config_enabled=management_station_is_auto_config_enabled)
        ```

        ## Import

        ManagementStations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managementStation:ManagementStation test_management_station "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the management station. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] hostname: (Updatable) Hostname of the management station.
        :param pulumi.Input[builtins.bool] is_auto_config_enabled: (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        :param pulumi.Input[Union['ManagementStationMirrorArgs', 'ManagementStationMirrorArgsDict']] mirror: (Updatable) Information used to create the mirror configuration for a management station.
        :param pulumi.Input[Union['ManagementStationProxyArgs', 'ManagementStationProxyArgsDict']] proxy: (Updatable) Information used to create the proxy configuration for a management station.
        :param pulumi.Input[builtins.int] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementStationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a management station using the proxy and mirror configuration information provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station = oci.os_management_hub.ManagementStation("test_management_station",
            compartment_id=compartment_id,
            display_name=management_station_display_name,
            hostname=management_station_hostname,
            mirror={
                "directory": management_station_mirror_directory,
                "port": management_station_mirror_port,
                "sslport": management_station_mirror_sslport,
                "is_sslverify_enabled": management_station_mirror_is_sslverify_enabled,
                "sslcert": management_station_mirror_sslcert,
            },
            proxy={
                "is_enabled": management_station_proxy_is_enabled,
                "forward": management_station_proxy_forward,
                "hosts": management_station_proxy_hosts,
                "port": management_station_proxy_port,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=management_station_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_config_enabled=management_station_is_auto_config_enabled)
        ```

        ## Import

        ManagementStations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managementStation:ManagementStation test_management_station "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementStationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementStationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 is_auto_config_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[Union['ManagementStationMirrorArgs', 'ManagementStationMirrorArgsDict']]] = None,
                 proxy: Optional[pulumi.Input[Union['ManagementStationProxyArgs', 'ManagementStationProxyArgsDict']]] = None,
                 refresh_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementStationArgs.__new__(ManagementStationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["is_auto_config_enabled"] = is_auto_config_enabled
            if mirror is None and not opts.urn:
                raise TypeError("Missing required property 'mirror'")
            __props__.__dict__["mirror"] = mirror
            if proxy is None and not opts.urn:
                raise TypeError("Missing required property 'proxy'")
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["refresh_trigger"] = refresh_trigger
            __props__.__dict__["healths"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["managed_instance_id"] = None
            __props__.__dict__["mirror_capacity"] = None
            __props__.__dict__["mirror_package_count"] = None
            __props__.__dict__["mirror_size"] = None
            __props__.__dict__["mirror_storage_available_size"] = None
            __props__.__dict__["mirror_storage_size"] = None
            __props__.__dict__["mirror_sync_statuses"] = None
            __props__.__dict__["mirror_unique_package_count"] = None
            __props__.__dict__["overall_percentage"] = None
            __props__.__dict__["overall_state"] = None
            __props__.__dict__["peer_management_stations"] = None
            __props__.__dict__["profile_id"] = None
            __props__.__dict__["scheduled_job_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["total_mirrors"] = None
        super(ManagementStation, __self__).__init__(
            'oci:OsManagementHub/managementStation:ManagementStation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            healths: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationHealthArgs', 'ManagementStationHealthArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            is_auto_config_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            mirror: Optional[pulumi.Input[Union['ManagementStationMirrorArgs', 'ManagementStationMirrorArgsDict']]] = None,
            mirror_capacity: Optional[pulumi.Input[builtins.int]] = None,
            mirror_package_count: Optional[pulumi.Input[builtins.int]] = None,
            mirror_size: Optional[pulumi.Input[builtins.str]] = None,
            mirror_storage_available_size: Optional[pulumi.Input[builtins.str]] = None,
            mirror_storage_size: Optional[pulumi.Input[builtins.str]] = None,
            mirror_sync_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationMirrorSyncStatusArgs', 'ManagementStationMirrorSyncStatusArgsDict']]]]] = None,
            mirror_unique_package_count: Optional[pulumi.Input[builtins.int]] = None,
            overall_percentage: Optional[pulumi.Input[builtins.int]] = None,
            overall_state: Optional[pulumi.Input[builtins.str]] = None,
            peer_management_stations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationPeerManagementStationArgs', 'ManagementStationPeerManagementStationArgsDict']]]]] = None,
            profile_id: Optional[pulumi.Input[builtins.str]] = None,
            proxy: Optional[pulumi.Input[Union['ManagementStationProxyArgs', 'ManagementStationProxyArgsDict']]] = None,
            refresh_trigger: Optional[pulumi.Input[builtins.int]] = None,
            scheduled_job_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            total_mirrors: Optional[pulumi.Input[builtins.int]] = None) -> 'ManagementStation':
        """
        Get an existing ManagementStation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the management station. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationHealthArgs', 'ManagementStationHealthArgsDict']]]] healths: Overall health information of the management station.
        :param pulumi.Input[builtins.str] hostname: (Updatable) Hostname of the management station.
        :param pulumi.Input[builtins.bool] is_auto_config_enabled: (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        :param pulumi.Input[builtins.str] location: The location of the instance that is acting as the management station.
        :param pulumi.Input[builtins.str] managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        :param pulumi.Input[Union['ManagementStationMirrorArgs', 'ManagementStationMirrorArgsDict']] mirror: (Updatable) Information used to create the mirror configuration for a management station.
        :param pulumi.Input[builtins.int] mirror_capacity: A decimal number representing the amount of mirror capacity used by the sync.
        :param pulumi.Input[builtins.int] mirror_package_count: The total number of all packages within the mirrored software sources.
        :param pulumi.Input[builtins.str] mirror_size: The total size of all software source mirrors in bytes.
        :param pulumi.Input[builtins.str] mirror_storage_available_size: Amount of available mirror storage in bytes.
        :param pulumi.Input[builtins.str] mirror_storage_size: Total mirror storage size in bytes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationMirrorSyncStatusArgs', 'ManagementStationMirrorSyncStatusArgsDict']]]] mirror_sync_statuses: Status summary of the mirror sync.
        :param pulumi.Input[builtins.int] mirror_unique_package_count: The total number of unique packages within the mirrored software sources on the station. Each package is counted only once, regardless of how many versions it has.
        :param pulumi.Input[builtins.int] overall_percentage: A decimal number representing the progress of the current mirror sync.
        :param pulumi.Input[builtins.str] overall_state: Current state of the mirror sync for the management station.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementStationPeerManagementStationArgs', 'ManagementStationPeerManagementStationArgsDict']]]] peer_management_stations: A list of other management stations that are behind the same load balancer within a high availability configuration. Stations are identified as peers if they have the same hostname and compartment.
        :param pulumi.Input[builtins.str] profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile used for the management station.
        :param pulumi.Input[Union['ManagementStationProxyArgs', 'ManagementStationProxyArgsDict']] proxy: (Updatable) Information used to create the proxy configuration for a management station.
        :param pulumi.Input[builtins.int] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] scheduled_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job for the mirror sync.
        :param pulumi.Input[builtins.str] state: The current state of the management station.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.int] total_mirrors: The number of software sources that the station is mirroring.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementStationState.__new__(_ManagementStationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["healths"] = healths
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["is_auto_config_enabled"] = is_auto_config_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["mirror_capacity"] = mirror_capacity
        __props__.__dict__["mirror_package_count"] = mirror_package_count
        __props__.__dict__["mirror_size"] = mirror_size
        __props__.__dict__["mirror_storage_available_size"] = mirror_storage_available_size
        __props__.__dict__["mirror_storage_size"] = mirror_storage_size
        __props__.__dict__["mirror_sync_statuses"] = mirror_sync_statuses
        __props__.__dict__["mirror_unique_package_count"] = mirror_unique_package_count
        __props__.__dict__["overall_percentage"] = overall_percentage
        __props__.__dict__["overall_state"] = overall_state
        __props__.__dict__["peer_management_stations"] = peer_management_stations
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["refresh_trigger"] = refresh_trigger
        __props__.__dict__["scheduled_job_id"] = scheduled_job_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["total_mirrors"] = total_mirrors
        return ManagementStation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-specified description of the management station. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-friendly name for the management station. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def healths(self) -> pulumi.Output[Sequence['outputs.ManagementStationHealth']]:
        """
        Overall health information of the management station.
        """
        return pulumi.get(self, "healths")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Hostname of the management station.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="isAutoConfigEnabled")
    def is_auto_config_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) When enabled, the station setup script automatically runs to configure the firewall and SELinux settings on the station.
        """
        return pulumi.get(self, "is_auto_config_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the instance that is acting as the management station.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output['outputs.ManagementStationMirror']:
        """
        (Updatable) Information used to create the mirror configuration for a management station.
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorCapacity")
    def mirror_capacity(self) -> pulumi.Output[builtins.int]:
        """
        A decimal number representing the amount of mirror capacity used by the sync.
        """
        return pulumi.get(self, "mirror_capacity")

    @property
    @pulumi.getter(name="mirrorPackageCount")
    def mirror_package_count(self) -> pulumi.Output[builtins.int]:
        """
        The total number of all packages within the mirrored software sources.
        """
        return pulumi.get(self, "mirror_package_count")

    @property
    @pulumi.getter(name="mirrorSize")
    def mirror_size(self) -> pulumi.Output[builtins.str]:
        """
        The total size of all software source mirrors in bytes.
        """
        return pulumi.get(self, "mirror_size")

    @property
    @pulumi.getter(name="mirrorStorageAvailableSize")
    def mirror_storage_available_size(self) -> pulumi.Output[builtins.str]:
        """
        Amount of available mirror storage in bytes.
        """
        return pulumi.get(self, "mirror_storage_available_size")

    @property
    @pulumi.getter(name="mirrorStorageSize")
    def mirror_storage_size(self) -> pulumi.Output[builtins.str]:
        """
        Total mirror storage size in bytes.
        """
        return pulumi.get(self, "mirror_storage_size")

    @property
    @pulumi.getter(name="mirrorSyncStatuses")
    def mirror_sync_statuses(self) -> pulumi.Output[Sequence['outputs.ManagementStationMirrorSyncStatus']]:
        """
        Status summary of the mirror sync.
        """
        return pulumi.get(self, "mirror_sync_statuses")

    @property
    @pulumi.getter(name="mirrorUniquePackageCount")
    def mirror_unique_package_count(self) -> pulumi.Output[builtins.int]:
        """
        The total number of unique packages within the mirrored software sources on the station. Each package is counted only once, regardless of how many versions it has.
        """
        return pulumi.get(self, "mirror_unique_package_count")

    @property
    @pulumi.getter(name="overallPercentage")
    def overall_percentage(self) -> pulumi.Output[builtins.int]:
        """
        A decimal number representing the progress of the current mirror sync.
        """
        return pulumi.get(self, "overall_percentage")

    @property
    @pulumi.getter(name="overallState")
    def overall_state(self) -> pulumi.Output[builtins.str]:
        """
        Current state of the mirror sync for the management station.
        """
        return pulumi.get(self, "overall_state")

    @property
    @pulumi.getter(name="peerManagementStations")
    def peer_management_stations(self) -> pulumi.Output[Sequence['outputs.ManagementStationPeerManagementStation']]:
        """
        A list of other management stations that are behind the same load balancer within a high availability configuration. Stations are identified as peers if they have the same hostname and compartment.
        """
        return pulumi.get(self, "peer_management_stations")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile used for the management station.
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output['outputs.ManagementStationProxy']:
        """
        (Updatable) Information used to create the proxy configuration for a management station.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job for the mirror sync.
        """
        return pulumi.get(self, "scheduled_job_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the management station.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="totalMirrors")
    def total_mirrors(self) -> pulumi.Output[builtins.int]:
        """
        The number of software sources that the station is mirroring.
        """
        return pulumi.get(self, "total_mirrors")

