# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBackupsResult',
    'AwaitableGetBackupsResult',
    'get_backups',
    'get_backups_output',
]

@pulumi.output_type
class GetBackupsResult:
    """
    A collection of values returned by getBackups.
    """
    def __init__(__self__, backup_collections=None, backup_id=None, compartment_id=None, display_name=None, filters=None, id=None, state=None, time_ended=None, time_started=None):
        if backup_collections and not isinstance(backup_collections, list):
            raise TypeError("Expected argument 'backup_collections' to be a list")
        pulumi.set(__self__, "backup_collections", backup_collections)
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="backupCollections")
    def backup_collections(self) -> Sequence['outputs.GetBackupsBackupCollectionResult']:
        """
        The list of backup_collection.
        """
        return pulumi.get(self, "backup_collections")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the backup.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly display name for the backup. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_started")


class AwaitableGetBackupsResult(GetBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupsResult(
            backup_collections=self.backup_collections,
            backup_id=self.backup_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_backups(backup_id: Optional[builtins.str] = None,
                compartment_id: Optional[builtins.str] = None,
                display_name: Optional[builtins.str] = None,
                filters: Optional[Sequence[Union['GetBackupsFilterArgs', 'GetBackupsFilterArgsDict']]] = None,
                id: Optional[builtins.str] = None,
                state: Optional[builtins.str] = None,
                time_ended: Optional[builtins.str] = None,
                time_started: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupsResult:
    """
    This data source provides the list of Backups in Oracle Cloud Infrastructure Psql service.

    Returns a list of backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backups = oci.Psql.get_backups(backup_id=test_backup["id"],
        compartment_id=compartment_id,
        display_name=backup_display_name,
        id=backup_id,
        state=backup_state,
        time_ended=backup_time_ended,
        time_started=backup_time_started)
    ```


    :param builtins.str backup_id: A unique identifier for the backup.
    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A unique identifier for the database system.
    :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    :param builtins.str time_ended: The end date for getting backups. An [RFC 3339](https://tools.ietf.org/rfc/rfc3339) formatted datetime string.
    :param builtins.str time_started: The start date for getting backups. An [RFC 3339](https://tools.ietf.org/rfc/rfc3339) formatted datetime string.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getBackups:getBackups', __args__, opts=opts, typ=GetBackupsResult).value

    return AwaitableGetBackupsResult(
        backup_collections=pulumi.get(__ret__, 'backup_collections'),
        backup_id=pulumi.get(__ret__, 'backup_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))
def get_backups_output(backup_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBackupsFilterArgs', 'GetBackupsFilterArgsDict']]]]] = None,
                       id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       time_ended: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       time_started: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupsResult]:
    """
    This data source provides the list of Backups in Oracle Cloud Infrastructure Psql service.

    Returns a list of backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backups = oci.Psql.get_backups(backup_id=test_backup["id"],
        compartment_id=compartment_id,
        display_name=backup_display_name,
        id=backup_id,
        state=backup_state,
        time_ended=backup_time_ended,
        time_started=backup_time_started)
    ```


    :param builtins.str backup_id: A unique identifier for the backup.
    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A unique identifier for the database system.
    :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    :param builtins.str time_ended: The end date for getting backups. An [RFC 3339](https://tools.ietf.org/rfc/rfc3339) formatted datetime string.
    :param builtins.str time_started: The start date for getting backups. An [RFC 3339](https://tools.ietf.org/rfc/rfc3339) formatted datetime string.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Psql/getBackups:getBackups', __args__, opts=opts, typ=GetBackupsResult)
    return __ret__.apply(lambda __response__: GetBackupsResult(
        backup_collections=pulumi.get(__response__, 'backup_collections'),
        backup_id=pulumi.get(__response__, 'backup_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started')))
