# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetricExtensionsResult',
    'AwaitableGetMetricExtensionsResult',
    'get_metric_extensions',
    'get_metric_extensions_output',
]

@pulumi.output_type
class GetMetricExtensionsResult:
    """
    A collection of values returned by getMetricExtensions.
    """
    def __init__(__self__, compartment_id=None, enabled_on_resource_id=None, filters=None, id=None, metric_extension_collections=None, metric_extension_id=None, name=None, resource_type=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if enabled_on_resource_id and not isinstance(enabled_on_resource_id, str):
            raise TypeError("Expected argument 'enabled_on_resource_id' to be a str")
        pulumi.set(__self__, "enabled_on_resource_id", enabled_on_resource_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metric_extension_collections and not isinstance(metric_extension_collections, list):
            raise TypeError("Expected argument 'metric_extension_collections' to be a list")
        pulumi.set(__self__, "metric_extension_collections", metric_extension_collections)
        if metric_extension_id and not isinstance(metric_extension_id, str):
            raise TypeError("Expected argument 'metric_extension_id' to be a str")
        pulumi.set(__self__, "metric_extension_id", metric_extension_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="enabledOnResourceId")
    def enabled_on_resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "enabled_on_resource_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMetricExtensionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metricExtensionCollections")
    def metric_extension_collections(self) -> Sequence['outputs.GetMetricExtensionsMetricExtensionCollectionResult']:
        """
        The list of metric_extension_collection.
        """
        return pulumi.get(self, "metric_extension_collections")

    @property
    @pulumi.getter(name="metricExtensionId")
    def metric_extension_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "metric_extension_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the script file
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        """
        Resource type to which Metric Extension applies
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The current status of the metric extension i.e. whether it is Draft or Published
        """
        return pulumi.get(self, "status")


class AwaitableGetMetricExtensionsResult(GetMetricExtensionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricExtensionsResult(
            compartment_id=self.compartment_id,
            enabled_on_resource_id=self.enabled_on_resource_id,
            filters=self.filters,
            id=self.id,
            metric_extension_collections=self.metric_extension_collections,
            metric_extension_id=self.metric_extension_id,
            name=self.name,
            resource_type=self.resource_type,
            state=self.state,
            status=self.status)


def get_metric_extensions(compartment_id: Optional[builtins.str] = None,
                          enabled_on_resource_id: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetMetricExtensionsFilterArgs', 'GetMetricExtensionsFilterArgsDict']]] = None,
                          metric_extension_id: Optional[builtins.str] = None,
                          name: Optional[builtins.str] = None,
                          resource_type: Optional[builtins.str] = None,
                          state: Optional[builtins.str] = None,
                          status: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricExtensionsResult:
    """
    This data source provides the list of Metric Extensions in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of metric extensions

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_extensions = oci.StackMonitoring.get_metric_extensions(compartment_id=compartment_id,
        enabled_on_resource_id=test_resource["id"],
        metric_extension_id=test_metric_extension["id"],
        name=metric_extension_name,
        resource_type=metric_extension_resource_type,
        state=metric_extension_state,
        status=metric_extension_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param builtins.str enabled_on_resource_id: A filter to return metric extensions based on input resource Id on which metric extension is enabled
    :param builtins.str metric_extension_id: Identifier for the metric extension
    :param builtins.str name: A filter to return resources based on name.
    :param builtins.str resource_type: A filter to return resources based on resource type.
    :param builtins.str state: A filter to return metric extensions based on Lifecycle State
    :param builtins.str status: A filter to return resources based on status e.g. Draft or Published
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['enabledOnResourceId'] = enabled_on_resource_id
    __args__['filters'] = filters
    __args__['metricExtensionId'] = metric_extension_id
    __args__['name'] = name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMetricExtensions:getMetricExtensions', __args__, opts=opts, typ=GetMetricExtensionsResult).value

    return AwaitableGetMetricExtensionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        enabled_on_resource_id=pulumi.get(__ret__, 'enabled_on_resource_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        metric_extension_collections=pulumi.get(__ret__, 'metric_extension_collections'),
        metric_extension_id=pulumi.get(__ret__, 'metric_extension_id'),
        name=pulumi.get(__ret__, 'name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_metric_extensions_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 enabled_on_resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMetricExtensionsFilterArgs', 'GetMetricExtensionsFilterArgsDict']]]]] = None,
                                 metric_extension_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 resource_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetricExtensionsResult]:
    """
    This data source provides the list of Metric Extensions in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of metric extensions

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_extensions = oci.StackMonitoring.get_metric_extensions(compartment_id=compartment_id,
        enabled_on_resource_id=test_resource["id"],
        metric_extension_id=test_metric_extension["id"],
        name=metric_extension_name,
        resource_type=metric_extension_resource_type,
        state=metric_extension_state,
        status=metric_extension_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param builtins.str enabled_on_resource_id: A filter to return metric extensions based on input resource Id on which metric extension is enabled
    :param builtins.str metric_extension_id: Identifier for the metric extension
    :param builtins.str name: A filter to return resources based on name.
    :param builtins.str resource_type: A filter to return resources based on resource type.
    :param builtins.str state: A filter to return metric extensions based on Lifecycle State
    :param builtins.str status: A filter to return resources based on status e.g. Draft or Published
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['enabledOnResourceId'] = enabled_on_resource_id
    __args__['filters'] = filters
    __args__['metricExtensionId'] = metric_extension_id
    __args__['name'] = name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMetricExtensions:getMetricExtensions', __args__, opts=opts, typ=GetMetricExtensionsResult)
    return __ret__.apply(lambda __response__: GetMetricExtensionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        enabled_on_resource_id=pulumi.get(__response__, 'enabled_on_resource_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        metric_extension_collections=pulumi.get(__response__, 'metric_extension_collections'),
        metric_extension_id=pulumi.get(__response__, 'metric_extension_id'),
        name=pulumi.get(__response__, 'name'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
