# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourceTaskArgs', 'MonitoredResourceTask']

@pulumi.input_type
class MonitoredResourceTaskArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 task_details: pulumi.Input['MonitoredResourceTaskTaskDetailsArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MonitoredResourceTask resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        :param pulumi.Input['MonitoredResourceTaskTaskDetailsArgs'] task_details: The request details for the performing the task.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "task_details", task_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> pulumi.Input['MonitoredResourceTaskTaskDetailsArgs']:
        """
        The request details for the performing the task.
        """
        return pulumi.get(self, "task_details")

    @task_details.setter
    def task_details(self, value: pulumi.Input['MonitoredResourceTaskTaskDetailsArgs']):
        pulumi.set(self, "task_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MonitoredResourceTaskState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 task_details: Optional[pulumi.Input['MonitoredResourceTaskTaskDetailsArgs']] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MonitoredResourceTask resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        :param pulumi.Input[builtins.str] state: The current state of the stack monitoring resource task.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input['MonitoredResourceTaskTaskDetailsArgs'] task_details: The request details for the performing the task.
        :param pulumi.Input[builtins.str] tenant_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
        :param pulumi.Input[builtins.str] time_created: The date and time when the stack monitoring resource task was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The date and time when the stack monitoring resource task was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] type: Type of the task.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] work_request_ids: Identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for work requests submitted for this task.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if task_details is not None:
            pulumi.set(__self__, "task_details", task_details)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if work_request_ids is not None:
            pulumi.set(__self__, "work_request_ids", work_request_ids)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the stack monitoring resource task.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> Optional[pulumi.Input['MonitoredResourceTaskTaskDetailsArgs']]:
        """
        The request details for the performing the task.
        """
        return pulumi.get(self, "task_details")

    @task_details.setter
    def task_details(self, value: Optional[pulumi.Input['MonitoredResourceTaskTaskDetailsArgs']]):
        pulumi.set(self, "task_details", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the stack monitoring resource task was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the stack monitoring resource task was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the task.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workRequestIds")
    def work_request_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for work requests submitted for this task.
        """
        return pulumi.get(self, "work_request_ids")

    @work_request_ids.setter
    def work_request_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "work_request_ids", value)


@pulumi.type_token("oci:StackMonitoring/monitoredResourceTask:MonitoredResourceTask")
class MonitoredResourceTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 task_details: Optional[pulumi.Input[Union['MonitoredResourceTaskTaskDetailsArgs', 'MonitoredResourceTaskTaskDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Monitored Resource Task resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Create a new stack monitoring resource task.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource_task = oci.stack_monitoring.MonitoredResourceTask("test_monitored_resource_task",
            compartment_id=compartment_id,
            task_details={
                "type": monitored_resource_task_task_details_type,
                "agent_id": test_agent["id"],
                "availability_proxy_metric_collection_interval": monitored_resource_task_task_details_availability_proxy_metric_collection_interval,
                "availability_proxy_metrics": monitored_resource_task_task_details_availability_proxy_metrics,
                "console_path_prefix": monitored_resource_task_task_details_console_path_prefix,
                "external_id_mapping": monitored_resource_task_task_details_external_id_mapping,
                "handler_type": monitored_resource_task_task_details_handler_type,
                "is_enable": monitored_resource_task_task_details_is_enable,
                "lifecycle_status_mappings_for_up_statuses": monitored_resource_task_task_details_lifecycle_status_mappings_for_up_status,
                "namespace": monitored_resource_task_task_details_namespace,
                "receiver_properties": {
                    "listener_port": monitored_resource_task_task_details_receiver_properties_listener_port,
                },
                "resource_group": monitored_resource_task_task_details_resource_group,
                "resource_name_filter": monitored_resource_task_task_details_resource_name_filter,
                "resource_name_mapping": monitored_resource_task_task_details_resource_name_mapping,
                "resource_type_filter": monitored_resource_task_task_details_resource_type_filter,
                "resource_type_mapping": monitored_resource_task_task_details_resource_type_mapping,
                "resource_types_configurations": [{
                    "availability_metrics_config": {
                        "collection_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_availability_metrics_config_collection_interval_in_seconds,
                        "metrics": monitored_resource_task_task_details_resource_types_configuration_availability_metrics_config_metrics,
                    },
                    "handler_config": {
                        "collectd_resource_name_config": {
                            "exclude_properties": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_exclude_properties,
                            "include_properties": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_include_properties,
                            "suffix": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_suffix,
                        },
                        "collector_types": monitored_resource_task_task_details_resource_types_configuration_handler_config_collector_types,
                        "handler_properties": [{
                            "name": monitored_resource_task_task_details_resource_types_configuration_handler_config_handler_properties_name,
                            "value": monitored_resource_task_task_details_resource_types_configuration_handler_config_handler_properties_value,
                        }],
                        "metric_mappings": [{
                            "collector_metric_name": test_metric["name"],
                            "is_skip_upload": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_mappings_is_skip_upload,
                            "metric_upload_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_mappings_metric_upload_interval_in_seconds,
                            "telemetry_metric_name": test_metric["name"],
                        }],
                        "metric_name_config": {
                            "exclude_pattern_on_prefix": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_name_config_exclude_pattern_on_prefix,
                            "is_prefix_with_collector_type": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_name_config_is_prefix_with_collector_type,
                        },
                        "metric_upload_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_upload_interval_in_seconds,
                        "telegraf_resource_name_config": {
                            "exclude_tags": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_exclude_tags,
                            "include_tags": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_include_tags,
                            "is_use_tags_only": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_is_use_tags_only,
                        },
                        "telemetry_resource_group": monitored_resource_task_task_details_resource_types_configuration_handler_config_telemetry_resource_group,
                    },
                    "resource_type": monitored_resource_task_task_details_resource_types_configuration_resource_type,
                }],
                "service_base_url": monitored_resource_task_task_details_service_base_url,
                "should_use_metrics_flow_for_status": monitored_resource_task_task_details_should_use_metrics_flow_for_status,
                "source": monitored_resource_task_task_details_source,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            name=monitored_resource_task_name)
        ```

        ## Import

        MonitoredResourceTasks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourceTask:MonitoredResourceTask test_monitored_resource_task "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        :param pulumi.Input[Union['MonitoredResourceTaskTaskDetailsArgs', 'MonitoredResourceTaskTaskDetailsArgsDict']] task_details: The request details for the performing the task.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourceTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitored Resource Task resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Create a new stack monitoring resource task.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource_task = oci.stack_monitoring.MonitoredResourceTask("test_monitored_resource_task",
            compartment_id=compartment_id,
            task_details={
                "type": monitored_resource_task_task_details_type,
                "agent_id": test_agent["id"],
                "availability_proxy_metric_collection_interval": monitored_resource_task_task_details_availability_proxy_metric_collection_interval,
                "availability_proxy_metrics": monitored_resource_task_task_details_availability_proxy_metrics,
                "console_path_prefix": monitored_resource_task_task_details_console_path_prefix,
                "external_id_mapping": monitored_resource_task_task_details_external_id_mapping,
                "handler_type": monitored_resource_task_task_details_handler_type,
                "is_enable": monitored_resource_task_task_details_is_enable,
                "lifecycle_status_mappings_for_up_statuses": monitored_resource_task_task_details_lifecycle_status_mappings_for_up_status,
                "namespace": monitored_resource_task_task_details_namespace,
                "receiver_properties": {
                    "listener_port": monitored_resource_task_task_details_receiver_properties_listener_port,
                },
                "resource_group": monitored_resource_task_task_details_resource_group,
                "resource_name_filter": monitored_resource_task_task_details_resource_name_filter,
                "resource_name_mapping": monitored_resource_task_task_details_resource_name_mapping,
                "resource_type_filter": monitored_resource_task_task_details_resource_type_filter,
                "resource_type_mapping": monitored_resource_task_task_details_resource_type_mapping,
                "resource_types_configurations": [{
                    "availability_metrics_config": {
                        "collection_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_availability_metrics_config_collection_interval_in_seconds,
                        "metrics": monitored_resource_task_task_details_resource_types_configuration_availability_metrics_config_metrics,
                    },
                    "handler_config": {
                        "collectd_resource_name_config": {
                            "exclude_properties": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_exclude_properties,
                            "include_properties": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_include_properties,
                            "suffix": monitored_resource_task_task_details_resource_types_configuration_handler_config_collectd_resource_name_config_suffix,
                        },
                        "collector_types": monitored_resource_task_task_details_resource_types_configuration_handler_config_collector_types,
                        "handler_properties": [{
                            "name": monitored_resource_task_task_details_resource_types_configuration_handler_config_handler_properties_name,
                            "value": monitored_resource_task_task_details_resource_types_configuration_handler_config_handler_properties_value,
                        }],
                        "metric_mappings": [{
                            "collector_metric_name": test_metric["name"],
                            "is_skip_upload": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_mappings_is_skip_upload,
                            "metric_upload_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_mappings_metric_upload_interval_in_seconds,
                            "telemetry_metric_name": test_metric["name"],
                        }],
                        "metric_name_config": {
                            "exclude_pattern_on_prefix": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_name_config_exclude_pattern_on_prefix,
                            "is_prefix_with_collector_type": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_name_config_is_prefix_with_collector_type,
                        },
                        "metric_upload_interval_in_seconds": monitored_resource_task_task_details_resource_types_configuration_handler_config_metric_upload_interval_in_seconds,
                        "telegraf_resource_name_config": {
                            "exclude_tags": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_exclude_tags,
                            "include_tags": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_include_tags,
                            "is_use_tags_only": monitored_resource_task_task_details_resource_types_configuration_handler_config_telegraf_resource_name_config_is_use_tags_only,
                        },
                        "telemetry_resource_group": monitored_resource_task_task_details_resource_types_configuration_handler_config_telemetry_resource_group,
                    },
                    "resource_type": monitored_resource_task_task_details_resource_types_configuration_resource_type,
                }],
                "service_base_url": monitored_resource_task_task_details_service_base_url,
                "should_use_metrics_flow_for_status": monitored_resource_task_task_details_should_use_metrics_flow_for_status,
                "source": monitored_resource_task_task_details_source,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            name=monitored_resource_task_name)
        ```

        ## Import

        MonitoredResourceTasks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResourceTask:MonitoredResourceTask test_monitored_resource_task "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourceTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourceTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 task_details: Optional[pulumi.Input[Union['MonitoredResourceTaskTaskDetailsArgs', 'MonitoredResourceTaskTaskDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourceTaskArgs.__new__(MonitoredResourceTaskArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            if task_details is None and not opts.urn:
                raise TypeError("Missing required property 'task_details'")
            __props__.__dict__["task_details"] = task_details
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["work_request_ids"] = None
        super(MonitoredResourceTask, __self__).__init__(
            'oci:StackMonitoring/monitoredResourceTask:MonitoredResourceTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            task_details: Optional[pulumi.Input[Union['MonitoredResourceTaskTaskDetailsArgs', 'MonitoredResourceTaskTaskDetailsArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            work_request_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'MonitoredResourceTask':
        """
        Get an existing MonitoredResourceTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        :param pulumi.Input[builtins.str] state: The current state of the stack monitoring resource task.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Union['MonitoredResourceTaskTaskDetailsArgs', 'MonitoredResourceTaskTaskDetailsArgsDict']] task_details: The request details for the performing the task.
        :param pulumi.Input[builtins.str] tenant_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
        :param pulumi.Input[builtins.str] time_created: The date and time when the stack monitoring resource task was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The date and time when the stack monitoring resource task was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] type: Type of the task.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] work_request_ids: Identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for work requests submitted for this task.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourceTaskState.__new__(_MonitoredResourceTaskState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["task_details"] = task_details
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["work_request_ids"] = work_request_ids
        return MonitoredResourceTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the task. If not provided by default the following names will be taken Oracle Cloud Infrastructure tasks - namespace plus timestamp.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the stack monitoring resource task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> pulumi.Output['outputs.MonitoredResourceTaskTaskDetails']:
        """
        The request details for the performing the task.
        """
        return pulumi.get(self, "task_details")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the stack monitoring resource task was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the stack monitoring resource task was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the task.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workRequestIds")
    def work_request_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Identifiers [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for work requests submitted for this task.
        """
        return pulumi.get(self, "work_request_ids")

