# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAssignedSubscriptionsResult',
    'AwaitableGetAssignedSubscriptionsResult',
    'get_assigned_subscriptions',
    'get_assigned_subscriptions_output',
]

@pulumi.output_type
class GetAssignedSubscriptionsResult:
    """
    A collection of values returned by getAssignedSubscriptions.
    """
    def __init__(__self__, assigned_subscription_collections=None, compartment_id=None, entity_version=None, filters=None, id=None, subscription_id=None):
        if assigned_subscription_collections and not isinstance(assigned_subscription_collections, list):
            raise TypeError("Expected argument 'assigned_subscription_collections' to be a list")
        pulumi.set(__self__, "assigned_subscription_collections", assigned_subscription_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if entity_version and not isinstance(entity_version, str):
            raise TypeError("Expected argument 'entity_version' to be a str")
        pulumi.set(__self__, "entity_version", entity_version)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="assignedSubscriptionCollections")
    def assigned_subscription_collections(self) -> Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionResult']:
        """
        The list of assigned_subscription_collection.
        """
        return pulumi.get(self, "assigned_subscription_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the owning compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="entityVersion")
    def entity_version(self) -> Optional[builtins.str]:
        """
        The entity version of the subscription, whether V1 (the legacy schema version), or V2 (the latest 20230401 API version).
        """
        return pulumi.get(self, "entity_version")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAssignedSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subscription_id")


class AwaitableGetAssignedSubscriptionsResult(GetAssignedSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssignedSubscriptionsResult(
            assigned_subscription_collections=self.assigned_subscription_collections,
            compartment_id=self.compartment_id,
            entity_version=self.entity_version,
            filters=self.filters,
            id=self.id,
            subscription_id=self.subscription_id)


def get_assigned_subscriptions(compartment_id: Optional[builtins.str] = None,
                               entity_version: Optional[builtins.str] = None,
                               filters: Optional[Sequence[Union['GetAssignedSubscriptionsFilterArgs', 'GetAssignedSubscriptionsFilterArgsDict']]] = None,
                               subscription_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssignedSubscriptionsResult:
    """
    This data source provides the list of Assigned Subscriptions in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists subscriptions that are consumed by the compartment. Only the root compartment is allowed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_assigned_subscriptions = oci.Tenantmanagercontrolplane.get_assigned_subscriptions(compartment_id=compartment_id,
        entity_version=assigned_subscription_entity_version,
        subscription_id=test_subscription["id"])
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str entity_version: The version of the subscription entity.
    :param builtins.str subscription_id: The ID of the subscription to which the tenancy is associated.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['entityVersion'] = entity_version
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getAssignedSubscriptions:getAssignedSubscriptions', __args__, opts=opts, typ=GetAssignedSubscriptionsResult).value

    return AwaitableGetAssignedSubscriptionsResult(
        assigned_subscription_collections=pulumi.get(__ret__, 'assigned_subscription_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        entity_version=pulumi.get(__ret__, 'entity_version'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_assigned_subscriptions_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      entity_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAssignedSubscriptionsFilterArgs', 'GetAssignedSubscriptionsFilterArgsDict']]]]] = None,
                                      subscription_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAssignedSubscriptionsResult]:
    """
    This data source provides the list of Assigned Subscriptions in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists subscriptions that are consumed by the compartment. Only the root compartment is allowed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_assigned_subscriptions = oci.Tenantmanagercontrolplane.get_assigned_subscriptions(compartment_id=compartment_id,
        entity_version=assigned_subscription_entity_version,
        subscription_id=test_subscription["id"])
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str entity_version: The version of the subscription entity.
    :param builtins.str subscription_id: The ID of the subscription to which the tenancy is associated.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['entityVersion'] = entity_version
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getAssignedSubscriptions:getAssignedSubscriptions', __args__, opts=opts, typ=GetAssignedSubscriptionsResult)
    return __ret__.apply(lambda __response__: GetAssignedSubscriptionsResult(
        assigned_subscription_collections=pulumi.get(__response__, 'assigned_subscription_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        entity_version=pulumi.get(__response__, 'entity_version'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
