# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SubscriptionRedeemableUserItem',
    'GetResourceQuotasFilterResult',
    'GetResourceQuotasResourceQuotumCollectionResult',
    'GetResourceQuotasResourceQuotumCollectionItemResult',
    'GetResourcesFilterResult',
    'GetResourcesResourcesCollectionResult',
    'GetResourcesResourcesCollectionItemResult',
    'GetResourcesResourcesCollectionItemSkusResult',
    'GetSubscriptionProductItemResult',
    'GetSubscriptionProductsFilterResult',
    'GetSubscriptionProductsProductCollectionResult',
    'GetSubscriptionProductsProductCollectionItemResult',
    'GetSubscriptionProductsProductCollectionItemItemResult',
    'GetSubscriptionRedeemableUserItemResult',
    'GetSubscriptionRedeemableUsersFilterResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult',
    'GetSubscriptionRedemptionItemResult',
    'GetSubscriptionRedemptionsFilterResult',
    'GetSubscriptionRedemptionsRedemptionCollectionResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemItemResult',
    'GetSubscriptionRewardItemResult',
    'GetSubscriptionRewardSummaryResult',
    'GetSubscriptionRewardsFilterResult',
    'GetSubscriptionRewardsRewardCollectionResult',
    'GetSubscriptionRewardsRewardCollectionItemResult',
    'GetSubscriptionRewardsRewardCollectionItemItemResult',
    'GetSubscriptionRewardsRewardCollectionItemSummaryResult',
    'GetUsagelimitsFilterResult',
    'GetUsagelimitsUsageLimitCollectionResult',
    'GetUsagelimitsUsageLimitCollectionItemResult',
]

@pulumi.output_type
class SubscriptionRedeemableUserItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailId":
            suggest = "email_id"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRedeemableUserItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_id: builtins.str,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None):
        """
        :param builtins.str email_id: The email ID for a user that can redeem rewards.
        :param builtins.str first_name: The first name of the user that can redeem rewards.
        :param builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> builtins.str:
        """
        The email ID for a user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetResourceQuotasFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionResult(dict):
    def __init__(__self__, *,
                 is_allowed: builtins.bool,
                 items: Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']):
        """
        :param builtins.bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param Sequence['GetResourceQuotasResourceQuotumCollectionItemArgs'] items: The list of resource quota details.
        """
        pulumi.set(__self__, "is_allowed", is_allowed)
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> builtins.bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']:
        """
        The list of resource quota details.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionItemResult(dict):
    def __init__(__self__, *,
                 affected_resource: builtins.str,
                 balance: builtins.float,
                 is_allowed: builtins.bool,
                 is_dependency: builtins.bool,
                 is_overage: builtins.bool,
                 name: builtins.str,
                 purchased_limit: builtins.float,
                 service: builtins.str):
        """
        :param builtins.str affected_resource: The affected resource name.
        :param builtins.float balance: The quota balance.
        :param builtins.bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param builtins.bool is_dependency: Used to indicate any resource dependencies.
        :param builtins.bool is_overage: Used to indicate if overages are incurred.
        :param builtins.str name: The resource name.
        :param builtins.float purchased_limit: The purchased quota limit.
        :param builtins.str service: The service name.
        """
        pulumi.set(__self__, "affected_resource", affected_resource)
        pulumi.set(__self__, "balance", balance)
        pulumi.set(__self__, "is_allowed", is_allowed)
        pulumi.set(__self__, "is_dependency", is_dependency)
        pulumi.set(__self__, "is_overage", is_overage)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "purchased_limit", purchased_limit)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="affectedResource")
    def affected_resource(self) -> builtins.str:
        """
        The affected resource name.
        """
        return pulumi.get(self, "affected_resource")

    @property
    @pulumi.getter
    def balance(self) -> builtins.float:
        """
        The quota balance.
        """
        return pulumi.get(self, "balance")

    @property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> builtins.bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @property
    @pulumi.getter(name="isDependency")
    def is_dependency(self) -> builtins.bool:
        """
        Used to indicate any resource dependencies.
        """
        return pulumi.get(self, "is_dependency")

    @property
    @pulumi.getter(name="isOverage")
    def is_overage(self) -> builtins.bool:
        """
        Used to indicate if overages are incurred.
        """
        return pulumi.get(self, "is_overage")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purchasedLimit")
    def purchased_limit(self) -> builtins.float:
        """
        The purchased quota limit.
        """
        return pulumi.get(self, "purchased_limit")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        The service name.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourcesResourcesCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetResourcesResourcesCollectionItemResult']):
        """
        :param Sequence['GetResourcesResourcesCollectionItemArgs'] items: The list of resource details for a service.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemResult']:
        """
        The list of resource details for a service.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourcesResourcesCollectionItemResult(dict):
    def __init__(__self__, *,
                 child_resources: Sequence[builtins.str],
                 daily_unit_display_name: builtins.str,
                 description: builtins.str,
                 hourly_unit_display_name: builtins.str,
                 instance_type: builtins.str,
                 is_purchased: builtins.bool,
                 name: builtins.str,
                 raw_unit_display_name: builtins.str,
                 servicename: builtins.str,
                 skuses: Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult'],
                 usage_data_type: builtins.str):
        """
        :param Sequence[builtins.str] child_resources: The details of any child resources.
        :param builtins.str daily_unit_display_name: Units to be used for daily aggregated data.
        :param builtins.str description: Description of the resource.
        :param builtins.str hourly_unit_display_name: Units to be used for hourly aggregated data.
        :param builtins.str instance_type: Instance type for the resource.
        :param builtins.bool is_purchased: Indicates if the SKU was purchased
        :param builtins.str name: Name of the resource.
        :param builtins.str raw_unit_display_name: Default units to use when unspecified.
        :param builtins.str servicename: Name of the service.
        :param Sequence['GetResourcesResourcesCollectionItemSkusArgs'] skuses: The details of resource Skus.
        :param builtins.str usage_data_type: Usage data type of the resource.
        """
        pulumi.set(__self__, "child_resources", child_resources)
        pulumi.set(__self__, "daily_unit_display_name", daily_unit_display_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hourly_unit_display_name", hourly_unit_display_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "is_purchased", is_purchased)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "raw_unit_display_name", raw_unit_display_name)
        pulumi.set(__self__, "servicename", servicename)
        pulumi.set(__self__, "skuses", skuses)
        pulumi.set(__self__, "usage_data_type", usage_data_type)

    @property
    @pulumi.getter(name="childResources")
    def child_resources(self) -> Sequence[builtins.str]:
        """
        The details of any child resources.
        """
        return pulumi.get(self, "child_resources")

    @property
    @pulumi.getter(name="dailyUnitDisplayName")
    def daily_unit_display_name(self) -> builtins.str:
        """
        Units to be used for daily aggregated data.
        """
        return pulumi.get(self, "daily_unit_display_name")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hourlyUnitDisplayName")
    def hourly_unit_display_name(self) -> builtins.str:
        """
        Units to be used for hourly aggregated data.
        """
        return pulumi.get(self, "hourly_unit_display_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        """
        Instance type for the resource.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="isPurchased")
    def is_purchased(self) -> builtins.bool:
        """
        Indicates if the SKU was purchased
        """
        return pulumi.get(self, "is_purchased")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rawUnitDisplayName")
    def raw_unit_display_name(self) -> builtins.str:
        """
        Default units to use when unspecified.
        """
        return pulumi.get(self, "raw_unit_display_name")

    @property
    @pulumi.getter
    def servicename(self) -> builtins.str:
        """
        Name of the service.
        """
        return pulumi.get(self, "servicename")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult']:
        """
        The details of resource Skus.
        """
        return pulumi.get(self, "skuses")

    @property
    @pulumi.getter(name="usageDataType")
    def usage_data_type(self) -> builtins.str:
        """
        Usage data type of the resource.
        """
        return pulumi.get(self, "usage_data_type")


@pulumi.output_type
class GetResourcesResourcesCollectionItemSkusResult(dict):
    def __init__(__self__, *,
                 cloud_credit_type: builtins.str,
                 sku_id: builtins.str,
                 sku_type: builtins.str):
        """
        :param builtins.str cloud_credit_type: The cloud credit type for the resource.
        :param builtins.str sku_id: The Sku Id for the resource.
        :param builtins.str sku_type: The Sku type for the resource.
        """
        pulumi.set(__self__, "cloud_credit_type", cloud_credit_type)
        pulumi.set(__self__, "sku_id", sku_id)
        pulumi.set(__self__, "sku_type", sku_type)

    @property
    @pulumi.getter(name="cloudCreditType")
    def cloud_credit_type(self) -> builtins.str:
        """
        The cloud credit type for the resource.
        """
        return pulumi.get(self, "cloud_credit_type")

    @property
    @pulumi.getter(name="skuId")
    def sku_id(self) -> builtins.str:
        """
        The Sku Id for the resource.
        """
        return pulumi.get(self, "sku_id")

    @property
    @pulumi.getter(name="skuType")
    def sku_type(self) -> builtins.str:
        """
        The Sku type for the resource.
        """
        return pulumi.get(self, "sku_type")


@pulumi.output_type
class GetSubscriptionProductItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: builtins.float,
                 is_eligible_to_earn_rewards: builtins.bool,
                 product_name: builtins.str,
                 product_number: builtins.str,
                 usage_amount: builtins.float):
        """
        :param builtins.float earned_rewards: The earned rewards for the product.
        :param builtins.bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param builtins.str product_name: The rate card product name.
        :param builtins.str product_number: The rate card product number.
        :param builtins.float usage_amount: The rate card product usage amount.
        """
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_number", product_number)
        pulumi.set(__self__, "usage_amount", usage_amount)

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> builtins.float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> builtins.bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> builtins.str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> builtins.str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> builtins.float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionProductsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemArgs'] items: The list of product rewards summaries.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemItemArgs'] items: The list of product rewards summaries.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: builtins.float,
                 is_eligible_to_earn_rewards: builtins.bool,
                 product_name: builtins.str,
                 product_number: builtins.str,
                 usage_amount: builtins.float):
        """
        :param builtins.float earned_rewards: The earned rewards for the product.
        :param builtins.bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param builtins.str product_name: The rate card product name.
        :param builtins.str product_number: The rate card product number.
        :param builtins.float usage_amount: The rate card product usage amount.
        """
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_number", product_number)
        pulumi.set(__self__, "usage_amount", usage_amount)

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> builtins.float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> builtins.bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> builtins.str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> builtins.str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> builtins.float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionRedeemableUserItemResult(dict):
    def __init__(__self__, *,
                 email_id: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str):
        """
        :param builtins.str email_id: The email ID of the user that can redeem rewards.
        :param builtins.str first_name: The first name of the user that can redeem rewards.
        :param builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> builtins.str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedeemableUsersFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemArgs'] items: The list of user summary that can redeem rewards.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult'],
                 subscription_id: builtins.str,
                 tenancy_id: builtins.str,
                 user_id: builtins.str):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemArgs'] items: The list of user summary that can redeem rewards.
        :param builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param builtins.str tenancy_id: The OCID of the tenancy.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 email_id: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str):
        """
        :param builtins.str email_id: The email ID of the user that can redeem rewards.
        :param builtins.str first_name: The first name of the user that can redeem rewards.
        :param builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> builtins.str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedemptionItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: builtins.float,
                 fx_rate: builtins.float,
                 invoice_currency: builtins.str,
                 invoice_number: builtins.str,
                 invoice_total_amount: builtins.float,
                 redeemed_rewards: builtins.float,
                 redemption_code: builtins.str,
                 redemption_email: builtins.str,
                 time_invoiced: builtins.str,
                 time_redeemed: builtins.str):
        """
        :param builtins.float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param builtins.float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param builtins.str invoice_currency: The currency associated with invoice.
        :param builtins.str invoice_number: It provides the invoice number against the redemption.
        :param builtins.float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param builtins.float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param builtins.str redemption_email: It provides the redemption email id.
        :param builtins.str time_invoiced: It provides the invoice date.
        :param builtins.str time_redeemed: It provides redeem date.
        """
        pulumi.set(__self__, "base_rewards", base_rewards)
        pulumi.set(__self__, "fx_rate", fx_rate)
        pulumi.set(__self__, "invoice_currency", invoice_currency)
        pulumi.set(__self__, "invoice_number", invoice_number)
        pulumi.set(__self__, "invoice_total_amount", invoice_total_amount)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "redemption_email", redemption_email)
        pulumi.set(__self__, "time_invoiced", time_invoiced)
        pulumi.set(__self__, "time_redeemed", time_redeemed)

    @property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> builtins.float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> builtins.float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> builtins.str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> builtins.str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> builtins.float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> builtins.float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> builtins.str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> builtins.str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> builtins.str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRedemptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemArgs'] items: The list of redemption summary.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemItemArgs'] items: The list of redemption summary.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: builtins.float,
                 fx_rate: builtins.float,
                 invoice_currency: builtins.str,
                 invoice_number: builtins.str,
                 invoice_total_amount: builtins.float,
                 redeemed_rewards: builtins.float,
                 redemption_code: builtins.str,
                 redemption_email: builtins.str,
                 time_invoiced: builtins.str,
                 time_redeemed: builtins.str):
        """
        :param builtins.float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param builtins.float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param builtins.str invoice_currency: The currency associated with invoice.
        :param builtins.str invoice_number: It provides the invoice number against the redemption.
        :param builtins.float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param builtins.float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param builtins.str redemption_email: It provides the redemption email id.
        :param builtins.str time_invoiced: It provides the invoice date.
        :param builtins.str time_redeemed: It provides redeem date.
        """
        pulumi.set(__self__, "base_rewards", base_rewards)
        pulumi.set(__self__, "fx_rate", fx_rate)
        pulumi.set(__self__, "invoice_currency", invoice_currency)
        pulumi.set(__self__, "invoice_number", invoice_number)
        pulumi.set(__self__, "invoice_total_amount", invoice_total_amount)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "redemption_email", redemption_email)
        pulumi.set(__self__, "time_invoiced", time_invoiced)
        pulumi.set(__self__, "time_redeemed", time_redeemed)

    @property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> builtins.float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> builtins.float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> builtins.str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> builtins.str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> builtins.float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> builtins.float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> builtins.str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> builtins.str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> builtins.str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRewardItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: builtins.float,
                 earned_rewards: builtins.float,
                 eligible_usage_amount: builtins.float,
                 ineligible_usage_amount: builtins.float,
                 is_manual: builtins.bool,
                 redeemed_rewards: builtins.float,
                 time_rewards_earned: builtins.str,
                 time_rewards_expired: builtins.str,
                 time_usage_ended: builtins.str,
                 time_usage_started: builtins.str,
                 usage_amount: builtins.float,
                 usage_period_key: builtins.str):
        """
        :param builtins.float available_rewards: The number of rewards available for a specific usage period.
        :param builtins.float earned_rewards: The number of rewards earned for the specific usage period.
        :param builtins.float eligible_usage_amount: The eligible usage amount for the usage period.
        :param builtins.float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param builtins.bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param builtins.float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param builtins.str time_rewards_earned: The date and time when rewards accrue.
        :param builtins.str time_rewards_expired: The date and time when rewards expire.
        :param builtins.str time_usage_ended: The end date and time for the usage period.
        :param builtins.str time_usage_started: The start date and time for the usage period.
        :param builtins.float usage_amount: The usage amount for the usage period.
        :param builtins.str usage_period_key: The usage period ID.
        """
        pulumi.set(__self__, "available_rewards", available_rewards)
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "eligible_usage_amount", eligible_usage_amount)
        pulumi.set(__self__, "ineligible_usage_amount", ineligible_usage_amount)
        pulumi.set(__self__, "is_manual", is_manual)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "time_rewards_earned", time_rewards_earned)
        pulumi.set(__self__, "time_rewards_expired", time_rewards_expired)
        pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        pulumi.set(__self__, "time_usage_started", time_usage_started)
        pulumi.set(__self__, "usage_amount", usage_amount)
        pulumi.set(__self__, "usage_period_key", usage_period_key)

    @property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> builtins.float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> builtins.float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> builtins.float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> builtins.float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> builtins.bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> builtins.float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> builtins.str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> builtins.str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> builtins.str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> builtins.str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> builtins.float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> builtins.str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardSummaryResult(dict):
    def __init__(__self__, *,
                 currency: builtins.str,
                 redemption_code: builtins.str,
                 rewards_rate: builtins.float,
                 subscription_id: builtins.str,
                 tenancy_id: builtins.str,
                 total_rewards_available: builtins.float):
        """
        :param builtins.str currency: The currency unit for the reward amount.
        :param builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param builtins.float rewards_rate: The current Rewards percentage in decimal format.
        :param builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param builtins.str tenancy_id: The OCID of the tenancy.
        :param builtins.float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "rewards_rate", rewards_rate)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "total_rewards_available", total_rewards_available)

    @property
    @pulumi.getter
    def currency(self) -> builtins.str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> builtins.float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> builtins.float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetSubscriptionRewardsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemArgs'] items: The monthly summary of rewards.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult'],
                 summaries: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemItemArgs'] items: The monthly summary of rewards.
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemSummaryArgs'] summaries: The overall monthly reward summary.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "summaries", summaries)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def summaries(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']:
        """
        The overall monthly reward summary.
        """
        return pulumi.get(self, "summaries")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: builtins.float,
                 earned_rewards: builtins.float,
                 eligible_usage_amount: builtins.float,
                 ineligible_usage_amount: builtins.float,
                 is_manual: builtins.bool,
                 redeemed_rewards: builtins.float,
                 time_rewards_earned: builtins.str,
                 time_rewards_expired: builtins.str,
                 time_usage_ended: builtins.str,
                 time_usage_started: builtins.str,
                 usage_amount: builtins.float,
                 usage_period_key: builtins.str):
        """
        :param builtins.float available_rewards: The number of rewards available for a specific usage period.
        :param builtins.float earned_rewards: The number of rewards earned for the specific usage period.
        :param builtins.float eligible_usage_amount: The eligible usage amount for the usage period.
        :param builtins.float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param builtins.bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param builtins.float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param builtins.str time_rewards_earned: The date and time when rewards accrue.
        :param builtins.str time_rewards_expired: The date and time when rewards expire.
        :param builtins.str time_usage_ended: The end date and time for the usage period.
        :param builtins.str time_usage_started: The start date and time for the usage period.
        :param builtins.float usage_amount: The usage amount for the usage period.
        :param builtins.str usage_period_key: The usage period ID.
        """
        pulumi.set(__self__, "available_rewards", available_rewards)
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "eligible_usage_amount", eligible_usage_amount)
        pulumi.set(__self__, "ineligible_usage_amount", ineligible_usage_amount)
        pulumi.set(__self__, "is_manual", is_manual)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "time_rewards_earned", time_rewards_earned)
        pulumi.set(__self__, "time_rewards_expired", time_rewards_expired)
        pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        pulumi.set(__self__, "time_usage_started", time_usage_started)
        pulumi.set(__self__, "usage_amount", usage_amount)
        pulumi.set(__self__, "usage_period_key", usage_period_key)

    @property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> builtins.float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> builtins.float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> builtins.float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> builtins.float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> builtins.bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> builtins.float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> builtins.str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> builtins.str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> builtins.str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> builtins.str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> builtins.float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> builtins.str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemSummaryResult(dict):
    def __init__(__self__, *,
                 currency: builtins.str,
                 redemption_code: builtins.str,
                 rewards_rate: builtins.float,
                 subscription_id: builtins.str,
                 tenancy_id: builtins.str,
                 total_rewards_available: builtins.float):
        """
        :param builtins.str currency: The currency unit for the reward amount.
        :param builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param builtins.float rewards_rate: The current Rewards percentage in decimal format.
        :param builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param builtins.str tenancy_id: The OCID of the tenancy.
        :param builtins.float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "rewards_rate", rewards_rate)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "total_rewards_available", total_rewards_available)

    @property
    @pulumi.getter
    def currency(self) -> builtins.str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> builtins.float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> builtins.float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetUsagelimitsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']):
        """
        :param Sequence['GetUsagelimitsUsageLimitCollectionItemArgs'] items: The list of usage limits.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']:
        """
        The list of usage limits.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 alert_level: builtins.float,
                 created_by: builtins.str,
                 entitlement_id: builtins.str,
                 id: builtins.str,
                 limit: builtins.str,
                 limit_type: builtins.str,
                 max_hard_limit: builtins.str,
                 modified_by: builtins.str,
                 resource_name: builtins.str,
                 service_name: builtins.str,
                 sku_part_id: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_modified: builtins.str,
                 value_type: builtins.str):
        """
        :param builtins.str action: The action when usage limit is hit
        :param builtins.float alert_level: The alert level of the usage limit
        :param builtins.str created_by: The user who created the limit
        :param builtins.str entitlement_id: Entitlement ID of the usage limit
        :param builtins.str id: The usage limit ID
        :param builtins.str limit_type: Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        :param builtins.str max_hard_limit: The maximum hard limit set for the usage limit
        :param builtins.str modified_by: The user who modified the limit
        :param builtins.str resource_name: The resource for which the limit is defined
        :param builtins.str service_name: The service for which the limit is defined
        :param builtins.str sku_part_id: The SKU for which the usage limit is set
        :param builtins.str state: The usage limit lifecycle state.
        :param builtins.str time_created: Time when the usage limit was created
        :param builtins.str time_modified: Time when the usage limit was modified
        :param builtins.str value_type: The value type of the usage limit
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "alert_level", alert_level)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "entitlement_id", entitlement_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "limit_type", limit_type)
        pulumi.set(__self__, "max_hard_limit", max_hard_limit)
        pulumi.set(__self__, "modified_by", modified_by)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "sku_part_id", sku_part_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action when usage limit is hit
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> builtins.float:
        """
        The alert level of the usage limit
        """
        return pulumi.get(self, "alert_level")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The user who created the limit
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> builtins.str:
        """
        Entitlement ID of the usage limit
        """
        return pulumi.get(self, "entitlement_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The usage limit ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> builtins.str:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="limitType")
    def limit_type(self) -> builtins.str:
        """
        Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        """
        return pulumi.get(self, "limit_type")

    @property
    @pulumi.getter(name="maxHardLimit")
    def max_hard_limit(self) -> builtins.str:
        """
        The maximum hard limit set for the usage limit
        """
        return pulumi.get(self, "max_hard_limit")

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> builtins.str:
        """
        The user who modified the limit
        """
        return pulumi.get(self, "modified_by")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        The resource for which the limit is defined
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The service for which the limit is defined
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="skuPartId")
    def sku_part_id(self) -> builtins.str:
        """
        The SKU for which the usage limit is set
        """
        return pulumi.get(self, "sku_part_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The usage limit lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Time when the usage limit was created
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> builtins.str:
        """
        Time when the usage limit was modified
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> builtins.str:
        """
        The value type of the usage limit
        """
        return pulumi.get(self, "value_type")


