# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVbInstancesResult',
    'AwaitableGetVbInstancesResult',
    'get_vb_instances',
    'get_vb_instances_output',
]

@pulumi.output_type
class GetVbInstancesResult:
    """
    A collection of values returned by getVbInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, vb_instance_summary_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vb_instance_summary_collections and not isinstance(vb_instance_summary_collections, list):
            raise TypeError("Expected argument 'vb_instance_summary_collections' to be a list")
        pulumi.set(__self__, "vb_instance_summary_collections", vb_instance_summary_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Vb Instance Identifier, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVbInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the vb instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vbInstanceSummaryCollections")
    def vb_instance_summary_collections(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionResult']:
        """
        The list of vb_instance_summary_collection.
        """
        return pulumi.get(self, "vb_instance_summary_collections")


class AwaitableGetVbInstancesResult(GetVbInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVbInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vb_instance_summary_collections=self.vb_instance_summary_collections)


def get_vb_instances(compartment_id: Optional[builtins.str] = None,
                     display_name: Optional[builtins.str] = None,
                     filters: Optional[Sequence[Union['GetVbInstancesFilterArgs', 'GetVbInstancesFilterArgsDict']]] = None,
                     state: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVbInstancesResult:
    """
    This data source provides the list of Vb Instances in Oracle Cloud Infrastructure Visual Builder service.

    Returns a list of Vb Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instances = oci.VisualBuilder.get_vb_instances(compartment_id=compartment_id,
        display_name=vb_instance_display_name,
        state=vb_instance_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param builtins.str state: Life cycle state to query on.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VisualBuilder/getVbInstances:getVbInstances', __args__, opts=opts, typ=GetVbInstancesResult).value

    return AwaitableGetVbInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vb_instance_summary_collections=pulumi.get(__ret__, 'vb_instance_summary_collections'))
def get_vb_instances_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                            display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVbInstancesFilterArgs', 'GetVbInstancesFilterArgsDict']]]]] = None,
                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVbInstancesResult]:
    """
    This data source provides the list of Vb Instances in Oracle Cloud Infrastructure Visual Builder service.

    Returns a list of Vb Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vb_instances = oci.VisualBuilder.get_vb_instances(compartment_id=compartment_id,
        display_name=vb_instance_display_name,
        state=vb_instance_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param builtins.str state: Life cycle state to query on.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VisualBuilder/getVbInstances:getVbInstances', __args__, opts=opts, typ=GetVbInstancesResult)
    return __ret__.apply(lambda __response__: GetVbInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vb_instance_summary_collections=pulumi.get(__response__, 'vb_instance_summary_collections')))
