# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPathAnalyzerTestDestinationEndpointResult',
    'GetPathAnalyzerTestProtocolParameterResult',
    'GetPathAnalyzerTestQueryOptionResult',
    'GetPathAnalyzerTestSourceEndpointResult',
    'GetPathAnalyzerTestsFilterResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult',
    'PathAnalysiDestinationEndpoint',
    'PathAnalysiProtocolParameters',
    'PathAnalysiQueryOptions',
    'PathAnalysiSourceEndpoint',
    'PathAnalyzerTestDestinationEndpoint',
    'PathAnalyzerTestProtocolParameters',
    'PathAnalyzerTestQueryOptions',
    'PathAnalyzerTestSourceEndpoint',
]

@pulumi.output_type
class GetPathAnalyzerTestDestinationEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 instance_id: builtins.str,
                 listener_id: builtins.str,
                 load_balancer_id: builtins.str,
                 network_load_balancer_id: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 type: builtins.str,
                 vlan_id: builtins.str,
                 vnic_id: builtins.str):
        """
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: The current state of the `PathAnalyzerTest` resource.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestProtocolParameterResult(dict):
    def __init__(__self__, *,
                 destination_port: builtins.int,
                 icmp_code: builtins.int,
                 icmp_type: builtins.int,
                 source_port: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param builtins.int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param builtins.int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param builtins.int source_port: The source port to use in a `PathAnalyzerTest` resource.
        :param builtins.str type: The type of the `Endpoint`.
        """
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "icmp_type", icmp_type)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.int:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> builtins.int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> builtins.int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> builtins.int:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPathAnalyzerTestQueryOptionResult(dict):
    def __init__(__self__, *,
                 is_bi_directional_analysis: builtins.bool):
        """
        :param builtins.bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> builtins.bool:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class GetPathAnalyzerTestSourceEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 instance_id: builtins.str,
                 listener_id: builtins.str,
                 load_balancer_id: builtins.str,
                 network_load_balancer_id: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 type: builtins.str,
                 vlan_id: builtins.str,
                 vnic_id: builtins.str):
        """
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: The current state of the `PathAnalyzerTest` resource.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 destination_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult'],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 protocol: builtins.int,
                 protocol_parameters: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult'],
                 query_options: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult'],
                 source_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointArgs'] destination_endpoints: Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param builtins.str display_name: A filter that returns only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: A unique identifier established when the resource is created. The identifier can't be changed later.
        :param builtins.int protocol: The IP protocol to use for the `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterArgs'] protocol_parameters: Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionArgs'] query_options: Defines the query options required for a `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointArgs'] source_endpoints: Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param builtins.str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param builtins.str time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "destination_endpoints", destination_endpoints)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        pulumi.set(__self__, "query_options", query_options)
        pulumi.set(__self__, "source_endpoints", source_endpoints)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="destinationEndpoints")
    def destination_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoints")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter that returns only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier established when the resource is created. The identifier can't be changed later.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.int:
        """
        The IP protocol to use for the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult']:
        """
        Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult']:
        """
        Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @property
    @pulumi.getter(name="sourceEndpoints")
    def source_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoints")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 instance_id: builtins.str,
                 listener_id: builtins.str,
                 load_balancer_id: builtins.str,
                 network_load_balancer_id: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 type: builtins.str,
                 vlan_id: builtins.str,
                 vnic_id: builtins.str):
        """
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult(dict):
    def __init__(__self__, *,
                 destination_port: builtins.int,
                 icmp_code: builtins.int,
                 icmp_type: builtins.int,
                 source_port: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param builtins.int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param builtins.int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param builtins.int source_port: The source port to use in a `PathAnalyzerTest` resource.
        :param builtins.str type: The type of the `Endpoint`.
        """
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "icmp_type", icmp_type)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.int:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> builtins.int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> builtins.int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> builtins.int:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult(dict):
    def __init__(__self__, *,
                 is_bi_directional_analysis: builtins.bool):
        """
        :param builtins.bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> builtins.bool:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 instance_id: builtins.str,
                 listener_id: builtins.str,
                 load_balancer_id: builtins.str,
                 network_load_balancer_id: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 type: builtins.str,
                 vlan_id: builtins.str,
                 vnic_id: builtins.str):
        """
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalysiDestinationEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiDestinationEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiDestinationEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiDestinationEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 address: Optional[builtins.str] = None,
                 instance_id: Optional[builtins.str] = None,
                 listener_id: Optional[builtins.str] = None,
                 load_balancer_id: Optional[builtins.str] = None,
                 network_load_balancer_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 vlan_id: Optional[builtins.str] = None,
                 vnic_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalysiProtocolParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "icmpCode":
            suggest = "icmp_code"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiProtocolParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiProtocolParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiProtocolParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 destination_port: Optional[builtins.int] = None,
                 icmp_code: Optional[builtins.int] = None,
                 icmp_type: Optional[builtins.int] = None,
                 source_port: Optional[builtins.int] = None):
        """
        :param builtins.str type: The type of the `ProtocolParameters` object.
        :param builtins.int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param builtins.int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param builtins.int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param builtins.int source_port: The source port to use in a `PathAnalyzerTest` resource.
        """
        pulumi.set(__self__, "type", type)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `ProtocolParameters` object.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[builtins.int]:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[builtins.int]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[builtins.int]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[builtins.int]:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class PathAnalysiQueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isBiDirectionalAnalysis":
            suggest = "is_bi_directional_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiQueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiQueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiQueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[builtins.bool] = None):
        """
        :param builtins.bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        if is_bi_directional_analysis is not None:
            pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[builtins.bool]:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class PathAnalysiSourceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiSourceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiSourceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiSourceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 address: Optional[builtins.str] = None,
                 instance_id: Optional[builtins.str] = None,
                 listener_id: Optional[builtins.str] = None,
                 load_balancer_id: Optional[builtins.str] = None,
                 network_load_balancer_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 vlan_id: Optional[builtins.str] = None,
                 vnic_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the `Endpoint`.
        :param builtins.str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalyzerTestDestinationEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestDestinationEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestDestinationEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestDestinationEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 address: Optional[builtins.str] = None,
                 instance_id: Optional[builtins.str] = None,
                 listener_id: Optional[builtins.str] = None,
                 load_balancer_id: Optional[builtins.str] = None,
                 network_load_balancer_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 vlan_id: Optional[builtins.str] = None,
                 vnic_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: (Updatable) The type of the `Endpoint`.
        :param builtins.str address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: The current state of the `PathAnalyzerTest` resource.
        :param builtins.str subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalyzerTestProtocolParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "icmpCode":
            suggest = "icmp_code"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestProtocolParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestProtocolParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestProtocolParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 destination_port: Optional[builtins.int] = None,
                 icmp_code: Optional[builtins.int] = None,
                 icmp_type: Optional[builtins.int] = None,
                 source_port: Optional[builtins.int] = None):
        """
        :param builtins.str type: (Updatable) The type of the `ProtocolParameters` object.
        :param builtins.int destination_port: (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        :param builtins.int icmp_code: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param builtins.int icmp_type: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param builtins.int source_port: (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        pulumi.set(__self__, "type", type)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (Updatable) The type of the `ProtocolParameters` object.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[builtins.int]:
        """
        (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[builtins.int]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[builtins.int]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[builtins.int]:
        """
        (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class PathAnalyzerTestQueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isBiDirectionalAnalysis":
            suggest = "is_bi_directional_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestQueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestQueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestQueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[builtins.bool] = None):
        """
        :param builtins.bool is_bi_directional_analysis: (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        if is_bi_directional_analysis is not None:
            pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[builtins.bool]:
        """
        (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class PathAnalyzerTestSourceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestSourceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestSourceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestSourceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 address: Optional[builtins.str] = None,
                 instance_id: Optional[builtins.str] = None,
                 listener_id: Optional[builtins.str] = None,
                 load_balancer_id: Optional[builtins.str] = None,
                 network_load_balancer_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 vlan_id: Optional[builtins.str] = None,
                 vnic_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: (Updatable) The type of the `Endpoint`.
        :param builtins.str address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param builtins.str instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param builtins.str listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param builtins.str load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param builtins.str network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param builtins.str state: The current state of the `PathAnalyzerTest` resource.
        :param builtins.str subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param builtins.str vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param builtins.str vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vnic_id")


