# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAppAccelerationPoliciesResult',
    'AwaitableGetAppAccelerationPoliciesResult',
    'get_app_acceleration_policies',
    'get_app_acceleration_policies_output',
]

@pulumi.output_type
class GetAppAccelerationPoliciesResult:
    """
    A collection of values returned by getAppAccelerationPolicies.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, states=None, web_app_acceleration_policy_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if web_app_acceleration_policy_collections and not isinstance(web_app_acceleration_policy_collections, list):
            raise TypeError("Expected argument 'web_app_acceleration_policy_collections' to be a list")
        pulumi.set(__self__, "web_app_acceleration_policy_collections", web_app_acceleration_policy_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        WebAppAccelerationPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAppAccelerationPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[builtins.str]]:
        """
        The current state of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="webAppAccelerationPolicyCollections")
    def web_app_acceleration_policy_collections(self) -> Sequence['outputs.GetAppAccelerationPoliciesWebAppAccelerationPolicyCollectionResult']:
        """
        The list of web_app_acceleration_policy_collection.
        """
        return pulumi.get(self, "web_app_acceleration_policy_collections")


class AwaitableGetAppAccelerationPoliciesResult(GetAppAccelerationPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppAccelerationPoliciesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            states=self.states,
            web_app_acceleration_policy_collections=self.web_app_acceleration_policy_collections)


def get_app_acceleration_policies(compartment_id: Optional[builtins.str] = None,
                                  display_name: Optional[builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetAppAccelerationPoliciesFilterArgs', 'GetAppAccelerationPoliciesFilterArgsDict']]] = None,
                                  id: Optional[builtins.str] = None,
                                  states: Optional[Sequence[builtins.str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppAccelerationPoliciesResult:
    """
    This data source provides the list of Web App Acceleration Policies in Oracle Cloud Infrastructure Waa service.

    Gets a list of all WebAppAccelerationPolicies in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_acceleration_policies = oci.Waa.get_app_acceleration_policies(compartment_id=compartment_id,
        display_name=web_app_acceleration_policy_display_name,
        id=web_app_acceleration_policy_id,
        states=web_app_acceleration_policy_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A filter to return only the WebAppAccelerationPolicy with the given [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[builtins.str] states: A filter to return only resources that match the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['states'] = states
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waa/getAppAccelerationPolicies:getAppAccelerationPolicies', __args__, opts=opts, typ=GetAppAccelerationPoliciesResult).value

    return AwaitableGetAppAccelerationPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        states=pulumi.get(__ret__, 'states'),
        web_app_acceleration_policy_collections=pulumi.get(__ret__, 'web_app_acceleration_policy_collections'))
def get_app_acceleration_policies_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAppAccelerationPoliciesFilterArgs', 'GetAppAccelerationPoliciesFilterArgsDict']]]]] = None,
                                         id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         states: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppAccelerationPoliciesResult]:
    """
    This data source provides the list of Web App Acceleration Policies in Oracle Cloud Infrastructure Waa service.

    Gets a list of all WebAppAccelerationPolicies in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_acceleration_policies = oci.Waa.get_app_acceleration_policies(compartment_id=compartment_id,
        display_name=web_app_acceleration_policy_display_name,
        id=web_app_acceleration_policy_id,
        states=web_app_acceleration_policy_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: A filter to return only the WebAppAccelerationPolicy with the given [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[builtins.str] states: A filter to return only resources that match the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['states'] = states
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waa/getAppAccelerationPolicies:getAppAccelerationPolicies', __args__, opts=opts, typ=GetAppAccelerationPoliciesResult)
    return __ret__.apply(lambda __response__: GetAppAccelerationPoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        states=pulumi.get(__response__, 'states'),
        web_app_acceleration_policy_collections=pulumi.get(__response__, 'web_app_acceleration_policy_collections')))
