from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class AddMergeToProject:
    """*
    Add a merged scan to the current project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"AddMergeToProject"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"AddMergeToProject",
    "Output":{
    "groups":[
    {
    "index":1,
    "name":"Scan-1",
    "scan": 1,
    "color":[0.5, 0.8, 0.3]
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `AddMergeToProject` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "AddMergeToProject"
            self.Type = Type

    class Response:

        """
         Server response for the `AddMergeToProject` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "AddMergeToProject"
            self.Type = Type
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

