from MF.V3.Descriptors.Transform import Transform as MF_V3_Descriptors_Transform_Transform
from MF.V3.Settings.Align import Align as MF_V3_Settings_Align_Align
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class Align:
    """*
    Align two scan groups.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Align",
    "Input":{
    "source":1,
    "target":2,
    "rough":{"method": "FastGlobal"},
    "fine":{"method": "ICP"}
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Align",
    "Input":{
    "source":1,
    "target":2,
    "rough":{"method": "FastGlobal"},
    "fine":{"method": "ICP"}
    },
    "Output":{
    "rotation":[0.2, 0.4, 0.6],
    "translation":[11, -10, 24]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `Align` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Align_Align):
            # A unique identifier generated by the client.
            self.Index = Index
            # "Align"
            self.Type = Type
            # The align settings.
            self.Input = Input

    class Response:

        """
         Server response for the `Align` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Align_Align, Output: MF_V3_Descriptors_Transform_Transform, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "Align"
            self.Type = Type
            # The requested align settings.
            self.Input = Input
            # The transform that aligns the source scan group to the target scan group.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

