from MF.V3.Descriptors.Settings.Camera import Camera as MF_V3_Descriptors_Settings_Camera_Camera
from MF.V3.Settings.AutoFocus import AutoFocus as MF_V3_Settings_AutoFocus_AutoFocus
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class AutoFocus:
    """*
    Auto focus one or both cameras.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"AutoFocus",
    "Input":{
    "cameras":[{
    "index":1,
    "box":{"x":196,"y":130,"width":64,"height":64}
    }],
    "applyAll":false
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"AutoFocus",
    "Input":{
    "cameras":[{
    "index":1,
    "box":{"x":196,"y":130,"width":64,"height":64}
    }],
    "applyAll":false
    }
    "Output":{
    "analogGain":{"default":512.0,"max":1024.0,"min":256.0,"value":256.0},
    "autoExposure":{"default":false,"value":true},
    "digitalGain":{"default":256,"max":65536,"min":256,"value":320},
    "exposure":{"default":27000,"max":90000,"min":9000,"value":18000},
    "focus":{
    "box":{
    "default":[
    {"height":64,"width":64,"x":224,"y":158},
    {"height":64,"width":64,"x":224,"y":158}
    ],
    "value":[
    {"height":64,"width":64,"x":271,"y":134},
    {"height":64,"width":64,"x":196,"y":130}
    ]
    },
    "value":{"default":[350,350],"max":1024,"min":0,"value":[396,392]}
    }
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `AutoFocus` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_AutoFocus_AutoFocus = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "AutoFocus"
            self.Type = Type
            # AutoFocus settings.
            self.Input = Input

    class Response:

        """
         Server response for the `AutoFocus` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_AutoFocus_AutoFocus = None, Output: MF_V3_Descriptors_Settings_Camera_Camera = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "AutoFocus"
            self.Type = Type
            # Requested auto focus settings.
            self.Input = Input
            # Actual camera settings after auto focusing the camera(s).
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

