from MF.V3.Descriptors.BoundingBox import BoundingBox as MF_V3_Descriptors_BoundingBox_BoundingBox
from MF.V3.Settings.BoundingBox import BoundingBox as MF_V3_Settings_BoundingBox_BoundingBox
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class BoundingBox:
    """*
    Get the bounding box of a set of scan groups.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"BoundingBox",
    "Input":{
    "selection":{"mode":"visible"},
    "axisAligned":false
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"BoundingBox",
    "Input":{
    "selection":{"mode":"visible"},
    "axisAligned":false
    },
    "Output":{
    "center":[11.9,-10.1,94.5],
    "rotation":[
    0.7, -0.7, 0.0,
    0.7,  0.7, 0.0,
    0.0,  0.0, 1.0],
    "size":[442.2,253.1,447.1],
    "transform":[
    221, 0.0, 0.0,  11.9,
    0.0, 126, 0.0, -10.1,
    0.0, 0.0, 223,  94.5,
    0.0, 0.0, 0.0,   1.0]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `BoundingBox` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_BoundingBox_BoundingBox):
            # A unique identifier generated by the client.
            self.Index = Index
            # "BoundingBox"
            self.Type = Type
            # The bounding box settings.
            self.Input = Input

    class Response:

        """
         Server response for the `BoundingBox` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_BoundingBox_BoundingBox, Output: MF_V3_Descriptors_BoundingBox_BoundingBox, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "BoundingBox"
            self.Type = Type
            # The requested bounding box settings.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

