from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CalibrateCameras:
    """*
    Calibrate the cameras.

    This task starts the camera calibration capture sequence where the user is guided to place the calibration card with a card outline drawn on the video feed.  Once each calibration card pose is captured, the cameras are calibrated and the calibration results are returned as a string.  If the cameras cannot be calibrated the task finishes in a `Failed` state.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrateCameras"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrateCameras",
    "Output":"Camera calibration results: ...",
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CalibrateCameras` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CalibrateCameras"
            self.Type = Type

    class Response:

        """
         Server response for the `CalibrateCameras` task.
        """
        def __init__(self, Index: int, Type: str, Output: str = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CalibrateCameras"
            self.Type = Type
            # Camera calibration results.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

