from MF.V3.Descriptors.Calibration import Turntable as MF_V3_Descriptors_Calibration_Turntable
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CalibrateTurntable:
    """*
    Calibrate the turntable.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrateTurntable"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrateTurntable",
    "Output":{
    "date":[2024,4,27,16,57,35],
    "quality":"Excellent",
    "focus":[300,320]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CalibrateTurntable` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CalibrateTurntable"
            self.Type = Type

    class Response:

        """
         Server response for the `CalibrateTurntable` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Calibration_Turntable = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CalibrateTurntable"
            self.Type = Type
            # The Turntable calibration descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

