from MF.V3.Descriptors.Calibration import CaptureTarget as MF_V3_Descriptors_Calibration_CaptureTarget
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CalibrationCaptureTargets:
    """*
    Get the camera calibration targets.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrationCaptureTargets"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CalibrationCaptureTargets",
    "Output":{[
    {
    "camera":0,
    "quads":[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]
    },
    {
    "camera":1,
    "quads":[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]
    },
    ]},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CalibrationCaptureTargets` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CalibrationCaptureTargets"
            self.Type = Type

    class Response:

        """
         Server response for the `CalibrationCaptureTargets` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Calibration_CaptureTarget = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CalibrationCaptureTargets"
            self.Type = Type
            # The calibration capture target descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

