from MF.V3.Descriptors.Calibration import Camera as MF_V3_Descriptors_Calibration_Camera
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CameraCalibration:
    """*
    Get the camera calibration descriptor.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CameraCalibration"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CameraCalibration",
    "Output":{
    "date":[2024,4,27,16,57,35],
    "quality":"Excellent"
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CameraCalibration` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CameraCalibration"
            self.Type = Type

    class Response:

        """
         Server response for the `CameraCalibration` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Calibration_Camera = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CameraCalibration"
            self.Type = Type
            # The camera calibration descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

