from MF.V3.Descriptors.CaptureImage import CaptureImage as MF_V3_Descriptors_CaptureImage_CaptureImage
from MF.V3.Settings.CaptureImage import CaptureImage as MF_V3_Settings_CaptureImage_CaptureImage
from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task
from typing import List


class CaptureImage:
    """*
    Capture an image from one or both cameras.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CaptureImage"
    "Input":{
    "selection":{0,1},
    "grayscale":false,
    "codec":jpg
    }
    }
    }
    ```

    > Buffer messages from server.

    ```json
    {
    "Buffer":{
    "Descriptor":"{"camera":0,"codec":"jpg","grayscale":false,"height":1560,"step":6312,"width":2104},
    "Index":0,
    "Size":856664,
    "Task":{
    "Index":1,
    "Type":"CaptureImage",
    "Input":{"selection":{0,1}, "grayscale":false, "codec":jpg}
    }
    }
    }
    ```
    ```json
    {
    "Buffer":{
    "Descriptor":"{"camera":1,"codec":"jpg","grayscale":false,"height":1560,"step":6312,"width":2104},
    "Index":1,
    "Size":847726,
    "Task":{
    "Index":1,
    "Type":"CaptureImage",
    "Input":{"selection":{0,1}, "grayscale":false, "codec":jpg}
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CaptureImage"
    "Input":{
    "selection":{0,1},
    "grayscale":false,
    "codec":jpg
    }
    "Output":[
    {"camera":0,"codec":"jpg","grayscale":false,"height":1560,"step":6312,"width":2104},
    {"camera":1,"codec":"jpg","grayscale":false,"height":1560,"step":6312,"width":2104}
    ],
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CaptureImage` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_CaptureImage_CaptureImage):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CaptureImage"
            self.Type = Type
            # The Image settings
            self.Input = Input

    class Response:

        """
         Server response for the `CaptureImage` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_CaptureImage_CaptureImage, Output: List[MF_V3_Descriptors_CaptureImage_CaptureImage] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CaptureImage"
            self.Type = Type
            # Requested capture image settings.s
            self.Input = Input
            # A capture image descriptors for each selected camera.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `CaptureImage` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task, Descriptor: MF_V3_Descriptors_CaptureImage_CaptureImage):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested CaptureImage task.
            self.Task = Task
            # The capture image descriptor.
            self.Descriptor = Descriptor

    def __init__(self):
        pass

