from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CloseProject:
    """*
    Close the current open project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CloseProject",
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CloseProject",
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CloseProject` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CloseProject"
            self.Type = Type

    class Response:

        """
         Server response for the `CloseProject` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CloseProject"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

