from MF.V3.Settings.Wifi import Wifi as MF_V3_Settings_Wifi_Wifi
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class ConnectWifi:
    """*
    Connect to a wifi network.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ConnectWifi",
    "Input":{
    "ssid":"Network1"
    "password":"password"
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ConnectWifi",
    "Input":{
    {
    "ssid":"Network1"
    "password":"password"
    }
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ConnectWifi` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Wifi_Wifi):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ConnectWifi"
            self.Type = Type
            # Wifi settings.
            self.Input = Input

    class Response:

        """
         Server response for the `ConnectWifi` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Wifi_Wifi, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ConnectWifi"
            self.Type = Type
            # The requested wifi settings.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

