from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.CopyGroups import CopyGroups as MF_V3_Settings_CopyGroups_CopyGroups
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class CopyGroups:
    """*
    Copy a set of scan groups.

    Say we have a scan group three with three groups:

    ```json
    {
    "groups":[
    {"index":1, "name":"Group 1"},
    {"index":2, "name":"Group 2"},
    {"index":3, "name":"Group 3"}
    ],
    }
    ```

    and we want to copy groups 1 and 3.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CopyGroups",
    "Input":{
    "sourceIndexes": [1,3],
    "nameSuffix": "-copy"
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"CopyGroups",
    "Input":{"sourceIndexes":[1,3,5]},
    "Output":{
    "groups":[
    {"index":1, "name":"Group 1"},
    {"index":4, "name":"Group 1-copy"}
    {"index":2, "name":"Group 2"},
    {"index":3, "name":"Group 3"},
    {"index":5, "name":"Group 3-copy"},
    ],
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `CopyGroups` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_CopyGroups_CopyGroups):
            # A unique identifier generated by the client.
            self.Index = Index
            # "CopyGroups"
            self.Type = Type
            # The copy groups settings.
            self.Input = Input

    class Response:

        """
         Server response for the `CopyGroups` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_CopyGroups_CopyGroups, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "CopyGroups"
            self.Type = Type
            # The requested copy groups settings.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

