from MF.V3.Descriptors.Image import Image as MF_V3_Descriptors_Image_Image
from MF.V3.Settings.Scan import Scan as MF_V3_Settings_Scan_Scan
from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task
from typing import List


class DepthMap:
    """*
    Capture a new scan.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"DepthMap"
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    },
    }
    }
    ```

    > Depth map buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":13128960,
    "Descriptor":{
    "cols":2104,
    "rows":1560,
    "step":8416,
    "type":5
    },
    "Task":{
    "Index":1,
    "Type":"DepthMap",
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    }
    }
    }
    }
    ```

    > Depth map binary data transfer from server [13128960 bytes].

    > Texture buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":1,
    "Size":9846720,
    "Descriptor":{
    "cols":2104,
    "rows":1560,
    "step":6312,
    "type":16
    },
    "Task":{
    "Index":1,
    "Type":"DepthMap",
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    }
    }
    }
    }
    ```

    > Texture binary data transfer from server [9846720 bytes].

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"DepthMap"
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    },
    "Output":[2500,0,1052,0,2500,780,0,0,1],
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `DepthMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Scan_Scan = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "DepthMap"
            self.Type = Type
            # Scan settings.
            self.Input = Input

    class Response:

        """
         Server response for the `DepthMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Scan_Scan = None, Output: List[float] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "DepthMap"
            self.Type = Type
            # Requested scan settings.
            self.Input = Input
            # The 9 values of the camera matrix corresponding to the depth map (row-major).
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `DepthMap` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task, Descriptor: MF_V3_Descriptors_Image_Image):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested DepthMap task.
            self.Task = Task
            # The image descriptor.
            self.Descriptor = Descriptor

    def __init__(self):
        pass

