from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class DetectCalibrationCard:
    """*
    Turns on the detection the calibration card on one or both cameras.
    Use the Video Frame Descriptor to get the results of the detection.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"DetectCalibrationCard",
    "Input":3
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Input":3,
    "Type":"DetectCalibrationCard",
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `DetectCalibrationCard` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "DetectCalibrationCard"
            self.Type = Type
            """
            Flag specifying on which camera(s) to start the detection the calibration card.
            [0: neither camera (disable), 1: left camera, 2: right camera, 3: both cameras]
            """
            self.Input = Input

    class Response:

        """
         Server response for the `DetectCalibrationCard` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "DetectCalibrationCard"
            self.Type = Type
            """
            Flag sent in the request specifying on which camera(s) to start the detection the calibration card.
            [0: neither camera (disable), 1: left camera, 2: right camera, 3: both cameras]
            """
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

