from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class DownloadProject:
    """*
    Download a project from the scanner.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"DownloadProject",
    "Input":5
    }
    }
    ```

    > Buffer message from server.

    ```json
    {
    "Buffer":{
    "Descriptor":"Project-5.zip",
    "Index":0,
    "Size":15682096,
    "Task":{
    "Index":1,
    "Type":"DownloadProject",
    "Input":5
    }
    }
    }
    ```

    > Binary data transfer from server: The project zip file [15682096 bytes].
    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"DownloadProject"
    "Input":5,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `DownloadProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "DownloadProject"
            self.Type = Type
            # Index of the project to download.
            self.Input = Input

    class Response:

        """
         Server response for the `DownloadProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "DownloadProject"
            self.Type = Type
            # Requested index of the project to download.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `DownloadProject` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task, Descriptor: str):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested DownloadProject task.
            self.Task = Task
            # The downloaded project filename.
            self.Descriptor = Descriptor

    def __init__(self):
        pass

