from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class ExportFactoryCalibrationLogs:
    """*
    Export facotry calibration logs.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportFactoryCalibrationLogs"
    }
    }
    ```

    > Export file buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":41337,
    "Task":{
    "Index":1,
    "Type":"ExportFactoryCalibrationLogs"
    }
    }
    }
    ```

    > Export file binary data transfer from server [41337 bytes].

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportFactoryCalibrationLogs"
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ExportFactoryCalibrationLogs` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ExportFactoryCalibrationLogs"
            self.Type = Type

    class Response:

        """
         Server response for the `ExportFactoryCalibrationLogs` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ExportFactoryCalibrationLogs"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `ExportFactoryCalibrationLogs` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested ExportFactoryCalibrationLogs task.
            self.Task = Task

    def __init__(self):
        pass

