from MF.V3.Settings.Export import Export as MF_V3_Settings_Export_Export
from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class ExportHeatMap:
    """*
    Export a mesh with vertex colors generated by the 'HeatMap' task.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportHeatMap",
    "Input":{"color":{"min":0.0,"max":1.0}}
    }
    }
    ```

    > Export file buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":8413737,
    "Task":{
    "Index":1,
    "Type":"ExportHeatMap",
    "Input":{"color":{"min":0.0,"max":1.0}}
    }
    }
    }
    ```

    > Export file binary data transfer from server [8413737 bytes].

    > Response from server:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportHeatMap",
    "Input":{"color":{"min":0.0,"max":1.0}},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ExportHeatMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Export_Export):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ExportHeatMap"
            self.Type = Type
            # Export settings.
            self.Input = Input

    class Response:

        """
         Server response for the `ExportHeatMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Export_Export, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ExportHeatMap"
            self.Type = Type
            # Requested export settings.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `ExportHeatMap` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested ExportHeatMap task.
            self.Task = Task

    def __init__(self):
        pass

